/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.server.http.service;

import dlshade.com.google.common.collect.ImmutableMap;
import dlshade.com.google.common.util.concurrent.UncheckedExecutionException;
import dlshade.org.apache.bookkeeper.common.util.JsonUtil;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.http.HttpServer;
import dlshade.org.apache.bookkeeper.http.service.HttpEndpointService;
import dlshade.org.apache.bookkeeper.http.service.HttpServiceRequest;
import dlshade.org.apache.bookkeeper.http.service.HttpServiceResponse;
import dlshade.org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import dlshade.org.apache.bookkeeper.meta.MetadataDrivers;
import dlshade.org.apache.commons.lang3.ObjectUtils;
import java.util.Collections;
import java.util.Map;

public class AutoRecoveryStatusService
implements HttpEndpointService {
    protected final ServerConfiguration conf;

    public AutoRecoveryStatusService(ServerConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        return MetadataDrivers.runFunctionWithLedgerManagerFactory(this.conf, ledgerManagerFactory -> {
            try (LedgerUnderreplicationManager ledgerUnderreplicationManager = ledgerManagerFactory.newLedgerUnderreplicationManager();){
                switch (request.getMethod()) {
                    case GET: {
                        HttpServiceResponse httpServiceResponse = this.handleGetStatus(ledgerUnderreplicationManager);
                        return httpServiceResponse;
                    }
                    case PUT: {
                        HttpServiceResponse httpServiceResponse = this.handlePutStatus(request, ledgerUnderreplicationManager);
                        return httpServiceResponse;
                    }
                }
                HttpServiceResponse httpServiceResponse = new HttpServiceResponse("Not found method. Should be GET or PUT method", HttpServer.StatusCode.NOT_FOUND);
                return httpServiceResponse;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new UncheckedExecutionException(e);
            }
            catch (Exception e) {
                throw new UncheckedExecutionException(e);
            }
        });
    }

    private HttpServiceResponse handleGetStatus(LedgerUnderreplicationManager ledgerUnderreplicationManager) throws Exception {
        String body = JsonUtil.toJson(ImmutableMap.of("enabled", ledgerUnderreplicationManager.isLedgerReplicationEnabled()));
        return new HttpServiceResponse(body, HttpServer.StatusCode.OK);
    }

    private HttpServiceResponse handlePutStatus(HttpServiceRequest request, LedgerUnderreplicationManager ledgerUnderreplicationManager) throws Exception {
        Map params = ObjectUtils.defaultIfNull(request.getParams(), Collections.emptyMap());
        String enabled = (String)params.get("enabled");
        if (enabled == null) {
            return new HttpServiceResponse("Param 'enabled' not found in " + params, HttpServer.StatusCode.BAD_REQUEST);
        }
        if (Boolean.parseBoolean(enabled)) {
            if (!ledgerUnderreplicationManager.isLedgerReplicationEnabled()) {
                ledgerUnderreplicationManager.enableLedgerReplication();
            }
        } else if (ledgerUnderreplicationManager.isLedgerReplicationEnabled()) {
            ledgerUnderreplicationManager.disableLedgerReplication();
        }
        String body = JsonUtil.toJson(ImmutableMap.of("enabled", ledgerUnderreplicationManager.isLedgerReplicationEnabled()));
        return new HttpServiceResponse(body, HttpServer.StatusCode.OK);
    }
}

