/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.server.http.service;

import dlshade.com.google.common.base.Preconditions;
import dlshade.org.apache.bookkeeper.bookie.Bookie;
import dlshade.org.apache.bookkeeper.bookie.BookieStateManager;
import dlshade.org.apache.bookkeeper.http.HttpServer;
import dlshade.org.apache.bookkeeper.http.service.HttpEndpointService;
import dlshade.org.apache.bookkeeper.http.service.HttpServiceRequest;
import dlshade.org.apache.bookkeeper.http.service.HttpServiceResponse;

public class BookieIsReadyService
implements HttpEndpointService {
    private final Bookie bookie;

    public BookieIsReadyService(Bookie bookie) {
        this.bookie = Preconditions.checkNotNull(bookie);
    }

    @Override
    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        if (HttpServer.Method.GET != request.getMethod()) {
            response.setCode(HttpServer.StatusCode.NOT_FOUND);
            response.setBody("Only support GET method check if bookie is ready.");
            return response;
        }
        BookieStateManager sm = this.bookie.getStateManager();
        if (sm.isRunning() && !sm.isShuttingDown()) {
            response.setCode(HttpServer.StatusCode.OK);
            response.setBody("");
        } else {
            response.setCode(HttpServer.StatusCode.SERVICE_UNAVAILABLE);
            response.setBody("Bookie is not fully started yet");
        }
        return response;
    }
}

