/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.server.http.service;

import dlshade.com.google.common.base.Preconditions;
import dlshade.com.google.common.collect.Maps;
import dlshade.org.apache.bookkeeper.client.api.LedgerMetadata;
import dlshade.org.apache.bookkeeper.common.util.JsonUtil;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.http.HttpServer;
import dlshade.org.apache.bookkeeper.http.service.HttpEndpointService;
import dlshade.org.apache.bookkeeper.http.service.HttpServiceRequest;
import dlshade.org.apache.bookkeeper.http.service.HttpServiceResponse;
import dlshade.org.apache.bookkeeper.meta.LedgerManager;
import dlshade.org.apache.bookkeeper.meta.LedgerManagerFactory;
import dlshade.org.apache.bookkeeper.meta.LedgerMetadataSerDe;
import dlshade.org.apache.bookkeeper.proto.BookieServer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetLedgerMetaService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(GetLedgerMetaService.class);
    protected ServerConfiguration conf;
    protected BookieServer bookieServer;
    private final LedgerMetadataSerDe serDe;

    public GetLedgerMetaService(ServerConfiguration conf, BookieServer bookieServer) {
        Preconditions.checkNotNull(conf);
        this.conf = conf;
        this.bookieServer = bookieServer;
        this.serDe = new LedgerMetadataSerDe();
    }

    @Override
    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        Map<String, String> params = request.getParams();
        if (HttpServer.Method.GET == request.getMethod() && params != null && params.containsKey("ledger_id")) {
            Long ledgerId = Long.parseLong(params.get("ledger_id"));
            LedgerManagerFactory mFactory = this.bookieServer.getBookie().getLedgerManagerFactory();
            LedgerManager manager = mFactory.newLedgerManager();
            HashMap<String, LedgerMetadata> output = Maps.newHashMap();
            LedgerMetadata md = manager.readLedgerMetadata(ledgerId).get().getValue();
            output.put(ledgerId.toString(), md);
            manager.close();
            String jsonResponse = JsonUtil.toJson(output);
            LOG.debug("output body:" + jsonResponse);
            response.setBody(jsonResponse);
            response.setCode(HttpServer.StatusCode.OK);
            return response;
        }
        response.setCode(HttpServer.StatusCode.NOT_FOUND);
        response.setBody("Not found method. Should be GET method");
        return response;
    }
}

