/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.server.http.service;

import dlshade.com.google.common.base.Preconditions;
import dlshade.com.google.common.collect.Maps;
import dlshade.org.apache.bookkeeper.client.BookKeeperAdmin;
import dlshade.org.apache.bookkeeper.client.LedgerEntry;
import dlshade.org.apache.bookkeeper.common.util.JsonUtil;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.http.HttpServer;
import dlshade.org.apache.bookkeeper.http.service.HttpEndpointService;
import dlshade.org.apache.bookkeeper.http.service.HttpServiceRequest;
import dlshade.org.apache.bookkeeper.http.service.HttpServiceResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadLedgerEntryService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(ReadLedgerEntryService.class);
    protected ServerConfiguration conf;
    protected BookKeeperAdmin bka;
    static final Long ENTRIES_PER_PAE = 1000L;

    public ReadLedgerEntryService(ServerConfiguration conf, BookKeeperAdmin bka) {
        Preconditions.checkNotNull(conf);
        this.conf = conf;
        this.bka = bka;
    }

    @Override
    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        Map<String, String> params = request.getParams();
        if (HttpServer.Method.GET == request.getMethod() && params != null && params.containsKey("ledger_id")) {
            Long ledgerId = Long.parseLong(params.get("ledger_id"));
            Long startEntryId = 0L;
            Long endEntryId = -1L;
            if (params.containsKey("start_entry_id")) {
                startEntryId = Long.parseLong(params.get("start_entry_id"));
            }
            if (params.containsKey("end_entry_id")) {
                endEntryId = Long.parseLong(params.get("end_entry_id"));
            }
            HashMap<String, String> output = Maps.newHashMap();
            Integer pageIndex = params.containsKey("page") ? Integer.parseInt(params.get("page")) : -1;
            if (pageIndex > 0) {
                Long startIndexInPage = (long)(pageIndex - 1) * ENTRIES_PER_PAE;
                Long endIndexInPage = startIndexInPage + ENTRIES_PER_PAE - 1L;
                if (startEntryId == 0L || startEntryId < startIndexInPage) {
                    startEntryId = startIndexInPage;
                }
                if (endEntryId == -1L || endEntryId > endIndexInPage) {
                    endEntryId = endIndexInPage;
                }
                output.put("Entries for page: ", pageIndex.toString());
            }
            if (endEntryId != -1L && startEntryId > endEntryId) {
                response.setCode(HttpServer.StatusCode.INTERNAL_ERROR);
                response.setBody("parameter for start_entry_id: " + startEntryId + " and end_entry_id: " + endEntryId + " conflict with page=" + pageIndex);
                return response;
            }
            for (LedgerEntry entry : this.bka.readEntries(ledgerId, startEntryId, endEntryId)) {
                output.put(Long.valueOf(entry.getEntryId()).toString(), new String(entry.getEntry(), StandardCharsets.US_ASCII));
            }
            String jsonResponse = JsonUtil.toJson(output);
            LOG.debug("output body:" + jsonResponse);
            response.setBody(jsonResponse);
            response.setCode(HttpServer.StatusCode.OK);
            return response;
        }
        response.setCode(HttpServer.StatusCode.NOT_FOUND);
        response.setBody("Not found method. Should be GET method, with ledger_id provided");
        return response;
    }
}

