/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.server.service;

import dlshade.org.apache.bookkeeper.common.util.ReflectionUtils;
import dlshade.org.apache.bookkeeper.server.component.ServerLifecycleComponent;
import dlshade.org.apache.bookkeeper.server.conf.BookieConfiguration;
import dlshade.org.apache.bookkeeper.stats.NullStatsLogger;
import dlshade.org.apache.bookkeeper.stats.StatsLogger;
import dlshade.org.apache.bookkeeper.stats.StatsProvider;
import java.io.IOException;

public class StatsProviderService
extends ServerLifecycleComponent {
    public static final String NAME = "stats-provider";
    private final StatsProvider statsProvider;

    public StatsProviderService(BookieConfiguration conf) throws Exception {
        super(NAME, conf, (StatsLogger)NullStatsLogger.INSTANCE);
        Class<? extends StatsProvider> statsProviderClass = conf.getServerConf().getStatsProviderClass();
        this.statsProvider = ReflectionUtils.newInstance(statsProviderClass);
    }

    public StatsProvider getStatsProvider() {
        return this.statsProvider;
    }

    @Override
    protected void doStart() {
        this.statsProvider.start(this.conf);
    }

    @Override
    protected void doStop() {
        this.statsProvider.stop();
    }

    @Override
    protected void doClose() throws IOException {
    }
}

