/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.stats;

import java.util.Arrays;

public class OpStatsData {
    private final long numSuccessfulEvents;
    private final long numFailedEvents;
    private final double avgLatencyMillis;
    private final long[] percentileLatenciesMillis;

    public OpStatsData(long numSuccessfulEvents, long numFailedEvents, double avgLatencyMillis, long[] percentileLatenciesMillis) {
        this.numSuccessfulEvents = numSuccessfulEvents;
        this.numFailedEvents = numFailedEvents;
        this.avgLatencyMillis = avgLatencyMillis;
        this.percentileLatenciesMillis = Arrays.copyOf(percentileLatenciesMillis, percentileLatenciesMillis.length);
    }

    public long getP10Latency() {
        return this.percentileLatenciesMillis[0];
    }

    public long getP50Latency() {
        return this.percentileLatenciesMillis[1];
    }

    public long getP90Latency() {
        return this.percentileLatenciesMillis[2];
    }

    public long getP99Latency() {
        return this.percentileLatenciesMillis[3];
    }

    public long getP999Latency() {
        return this.percentileLatenciesMillis[4];
    }

    public long getP9999Latency() {
        return this.percentileLatenciesMillis[5];
    }

    public long getNumSuccessfulEvents() {
        return this.numSuccessfulEvents;
    }

    public long getNumFailedEvents() {
        return this.numFailedEvents;
    }

    public double getAvgLatencyMillis() {
        return this.avgLatencyMillis;
    }
}

