/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.tools.cli.commands.autorecovery;

import com.beust.jcommander.Parameter;
import dlshade.com.google.common.util.concurrent.UncheckedExecutionException;
import dlshade.org.apache.bookkeeper.client.BKException;
import dlshade.org.apache.bookkeeper.client.BookKeeperAdmin;
import dlshade.org.apache.bookkeeper.conf.ClientConfiguration;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.replication.ReplicationException;
import dlshade.org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import dlshade.org.apache.bookkeeper.tools.framework.CliFlags;
import dlshade.org.apache.bookkeeper.tools.framework.CliSpec;
import dlshade.org.apache.zookeeper.KeeperException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LostBookieRecoveryDelayCommand
extends BookieCommand<LBRDFlags> {
    static final Logger LOG = LoggerFactory.getLogger(LostBookieRecoveryDelayCommand.class);
    private static final String NAME = "lostbookierecoverydelay";
    private static final String DESC = "Setter and Getter for LostBookieRecoveryDelay value (in seconds) in metadata store";
    private static final int DEFAULT = 0;

    public LostBookieRecoveryDelayCommand() {
        this(new LBRDFlags());
    }

    private LostBookieRecoveryDelayCommand(LBRDFlags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(flags).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, LBRDFlags cmdFlags) {
        try {
            return this.handler(conf, cmdFlags);
        }
        catch (Exception e) {
            throw new UncheckedExecutionException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handler(ServerConfiguration conf, LBRDFlags flags) throws InterruptedException, BKException, IOException, ReplicationException.UnavailableException, ReplicationException.CompatibilityException, KeeperException {
        boolean getter = flags.get;
        boolean setter = false;
        if (flags.set != 0) {
            setter = true;
        }
        if (!getter && !setter || getter && setter) {
            LOG.error("One and only one of -get and -set must be specified");
            return false;
        }
        ClientConfiguration adminConf = new ClientConfiguration(conf);
        try (BookKeeperAdmin admin = new BookKeeperAdmin(adminConf);){
            if (getter) {
                int lostBookieRecoveryDelay = admin.getLostBookieRecoveryDelay();
                LOG.info("LostBookieRecoveryDelay value in ZK: {}", (Object)String.valueOf(lostBookieRecoveryDelay));
            } else {
                int lostBookieRecoveryDelay = flags.set;
                admin.setLostBookieRecoveryDelay(lostBookieRecoveryDelay);
                LOG.info("Successfully set LostBookieRecoveryDelay value in ZK: {}", (Object)String.valueOf(lostBookieRecoveryDelay));
            }
        }
        return true;
    }

    public static class LBRDFlags
    extends CliFlags {
        @Parameter(names={"-g", "--get"}, description="Get LostBookieRecoveryDelay value (in seconds)")
        private boolean get;
        @Parameter(names={"-s", "--set"}, description="Set LostBookieRecoveryDelay value (in seconds)")
        private int set = 0;

        public LBRDFlags get(boolean get) {
            this.get = get;
            return this;
        }

        public LBRDFlags set(int set) {
            this.set = set;
            return this;
        }
    }
}

