/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.tools.cli.commands.bookie;

import com.beust.jcommander.Parameter;
import dlshade.com.google.common.util.concurrent.UncheckedExecutionException;
import dlshade.org.apache.bookkeeper.bookie.Bookie;
import dlshade.org.apache.bookkeeper.bookie.BookieShell;
import dlshade.org.apache.bookkeeper.client.BKException;
import dlshade.org.apache.bookkeeper.client.BookKeeper;
import dlshade.org.apache.bookkeeper.client.BookKeeperAdmin;
import dlshade.org.apache.bookkeeper.client.UpdateLedgerOp;
import dlshade.org.apache.bookkeeper.conf.ClientConfiguration;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.net.BookieId;
import dlshade.org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import dlshade.org.apache.bookkeeper.tools.framework.CliFlags;
import dlshade.org.apache.bookkeeper.tools.framework.CliSpec;
import dlshade.org.apache.bookkeeper.util.MathUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlipBookieIdCommand
extends BookieCommand<FlipBookieIdFlags> {
    static final Logger LOG = LoggerFactory.getLogger(FlipBookieIdCommand.class);
    private static final String NAME = "flip-bookie-id";
    private static final String DESC = "Update bookie id in ledgers (this may take a long time).";

    public FlipBookieIdCommand() {
        this(new FlipBookieIdFlags());
    }

    private FlipBookieIdCommand(FlipBookieIdFlags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(flags).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, FlipBookieIdFlags cmdFlags) {
        try {
            return this.updateLedger(conf, cmdFlags);
        }
        catch (Exception e) {
            throw new UncheckedExecutionException(e.getMessage(), e);
        }
    }

    private boolean updateLedger(ServerConfiguration conf, FlipBookieIdFlags flags) throws InterruptedException, BKException, IOException {
        if (!conf.getUseHostNameAsBookieID() && flags.hostname) {
            LOG.error("Expects configuration useHostNameAsBookieID=true as the option value");
            return false;
        }
        if (conf.getUseHostNameAsBookieID() && !flags.hostname) {
            LOG.error("Expects configuration useHostNameAsBookieID=false as the option value'");
            return false;
        }
        int rate = flags.updatePerSec;
        if (rate <= 0) {
            LOG.error("Invalid updatespersec {}, should be > 0", (Object)rate);
            return false;
        }
        int maxOutstandingReads = flags.maxOutstandingReads;
        if (maxOutstandingReads <= 0) {
            LOG.error("Invalid maxOutstandingReads {}, should be > 0", (Object)maxOutstandingReads);
            return false;
        }
        int limit = flags.limit;
        if (limit <= 0 && limit != Integer.MIN_VALUE) {
            LOG.error("Invalid limit {}, should be > 0", (Object)limit);
            return false;
        }
        final long printProgress = flags.verbose ? 10L : flags.printProgress;
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.addConfiguration((Configuration)conf);
        BookKeeper bk = new BookKeeper(clientConfiguration);
        BookKeeperAdmin admin = new BookKeeperAdmin(bk);
        UpdateLedgerOp updateLedgerOp = new UpdateLedgerOp(bk, admin);
        ServerConfiguration serverConfiguration = new ServerConfiguration(conf);
        BookieId newBookieId = Bookie.getBookieId(serverConfiguration);
        serverConfiguration.setUseHostNameAsBookieID(!flags.hostname);
        BookieId oldBookieId = Bookie.getBookieId(serverConfiguration);
        BookieShell.UpdateLedgerNotifier progressable = new BookieShell.UpdateLedgerNotifier(){
            long lastReport = System.nanoTime();

            @Override
            public void progress(long updated, long issued) {
                if (printProgress <= 0L) {
                    return;
                }
                if (TimeUnit.MILLISECONDS.toSeconds(MathUtils.elapsedMSec(this.lastReport)) >= printProgress) {
                    LOG.info("Number of ledgers issued={}, updated={}", (Object)issued, (Object)updated);
                    this.lastReport = MathUtils.nowInNano();
                }
            }
        };
        try {
            updateLedgerOp.updateBookieIdInLedgers(oldBookieId, newBookieId, rate, maxOutstandingReads, limit, progressable);
        }
        catch (IOException e) {
            LOG.error("Failed to update ledger metadata", (Throwable)e);
            return false;
        }
        return true;
    }

    public static class FlipBookieIdFlags
    extends CliFlags {
        @Parameter(names={"-host", "--hostname"}, description="Expects configuration useHostNameAsBookieID=true as the option value (default: ip address)")
        private boolean hostname;
        @Parameter(names={"-s", "--updatepersec"}, description="Number of ledgers updating per second (default: 5 per sec)")
        private int updatePerSec = 5;
        @Parameter(names={"-r", "--maxOutstandingReads"}, description="Max outstanding reads (default: 5 * updatespersec)")
        private int maxOutstandingReads = this.updatePerSec * 5;
        @Parameter(names={"-l", "--limit"}, description="Maximum number of ledgers of ledgers to update (default: no limit)")
        private int limit = Integer.MIN_VALUE;
        @Parameter(names={"-v", "--verbose"}, description="Print status of the ledger updation (default: false)")
        private boolean verbose;
        @Parameter(names={"-p", "--printprogress"}, description="Print messages on every configured seconds if verbose turned on (default: 10 secs)")
        private long printProgress = 10L;

        public FlipBookieIdFlags hostname(boolean hostname) {
            this.hostname = hostname;
            return this;
        }

        public FlipBookieIdFlags updatePerSec(int updatePerSec) {
            this.updatePerSec = updatePerSec;
            return this;
        }

        public FlipBookieIdFlags maxOutstandingReads(int maxOutstandingReads) {
            this.maxOutstandingReads = maxOutstandingReads;
            return this;
        }

        public FlipBookieIdFlags limit(int limit) {
            this.limit = limit;
            return this;
        }

        public FlipBookieIdFlags verbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public FlipBookieIdFlags printProgress(long printProgress) {
            this.printProgress = printProgress;
            return this;
        }
    }
}

