/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.tools.cli.commands.bookie;

import com.beust.jcommander.Parameter;
import dlshade.com.google.common.util.concurrent.UncheckedExecutionException;
import dlshade.org.apache.bookkeeper.bookie.Bookie;
import dlshade.org.apache.bookkeeper.bookie.InterleavedLedgerStorage;
import dlshade.org.apache.bookkeeper.bookie.LedgerCache;
import dlshade.org.apache.bookkeeper.bookie.LedgerEntryPage;
import dlshade.org.apache.bookkeeper.bookie.SortedLedgerStorage;
import dlshade.org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorage;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import dlshade.org.apache.bookkeeper.tools.framework.CliFlags;
import dlshade.org.apache.bookkeeper.tools.framework.CliSpec;
import dlshade.org.apache.bookkeeper.util.LedgerIdFormatter;
import dlshade.org.apache.commons.lang.mutable.MutableLong;
import java.io.IOException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerCommand
extends BookieCommand<LedgerFlags> {
    static final Logger LOG = LoggerFactory.getLogger(LedgerCommand.class);
    private static final String NAME = "ledger";
    private static final String DESC = "Dump ledger index entries into readable format";
    private LedgerIdFormatter ledgerIdFormatter;
    private Consumer<String> print = this::printInfoLine;

    public void setPrint(Consumer<String> print) {
        this.print = print;
    }

    public LedgerCommand() {
        this(new LedgerFlags());
    }

    public LedgerCommand(LedgerIdFormatter ledgerIdFormatter) {
        this(new LedgerFlags());
        this.ledgerIdFormatter = ledgerIdFormatter;
    }

    private LedgerCommand(LedgerFlags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(flags).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, LedgerFlags cmdFlags) {
        this.initLedgerIdFormatter(conf, cmdFlags);
        long ledgerId = cmdFlags.ledgerId;
        if (conf.getLedgerStorageClass().equals(DbLedgerStorage.class.getName())) {
            return this.dumpLedgerInfo(ledgerId, conf);
        }
        if (conf.getLedgerStorageClass().equals(SortedLedgerStorage.class.getName()) || conf.getLedgerStorageClass().equals(InterleavedLedgerStorage.class.getName())) {
            ServerConfiguration tConf = new ServerConfiguration(conf);
            InterleavedLedgerStorage interleavedLedgerStorage = new InterleavedLedgerStorage();
            try {
                Bookie.mountLedgerStorageOffline(tConf, interleavedLedgerStorage);
            }
            catch (IOException e) {
                throw new UncheckedExecutionException(e.getMessage(), e);
            }
            if (cmdFlags.meta) {
                this.printMeta(ledgerId, interleavedLedgerStorage);
            }
            try {
                this.print.accept("===== LEDGER: " + this.ledgerIdFormatter.formatLedgerId(ledgerId) + " =====");
                for (LedgerCache.PageEntries page : interleavedLedgerStorage.getIndexEntries(ledgerId)) {
                    if (!this.printPageEntries(page)) continue;
                    return true;
                }
            }
            catch (IOException e) {
                LOG.error("Failed to read index page");
                return true;
            }
        }
        return true;
    }

    private void initLedgerIdFormatter(ServerConfiguration conf, LedgerFlags flags) {
        this.ledgerIdFormatter = flags.ledgerIdFormatter.equals("") ? LedgerIdFormatter.newLedgerIdFormatter(conf) : LedgerIdFormatter.newLedgerIdFormatter(flags.ledgerIdFormatter, conf);
    }

    private boolean dumpLedgerInfo(long ledgerId, ServerConfiguration conf) {
        try {
            DbLedgerStorage.readLedgerIndexEntries(ledgerId, conf, (currentEntry, entryLodId, position) -> System.out.println("entry " + currentEntry + "\t:\t(log: " + entryLodId + ", pos: " + position + ")"));
        }
        catch (IOException e) {
            System.err.printf("ERROR: initializing dbLedgerStorage %s", e.getMessage());
            return false;
        }
        return true;
    }

    private void printMeta(long ledgerId, InterleavedLedgerStorage interleavedLedgerStorage) {
        this.print.accept("===== LEDGER: " + this.ledgerIdFormatter.formatLedgerId(ledgerId) + " =====");
        try {
            LedgerCache.LedgerIndexMetadata meta = interleavedLedgerStorage.readLedgerIndexMetadata(ledgerId);
            this.print.accept("master key  : " + meta.getMasterKeyHex());
            long size = meta.size;
            if (size % 8L == 0L) {
                this.print.accept("size         : " + size);
            } else {
                this.print.accept("size : " + size + "(not aligned with 8, may be corrupted or under flushing now)");
            }
            this.print.accept("entries      : " + size / 8L);
            this.print.accept("isFenced     : " + meta.fenced);
        }
        catch (IOException e) {
            throw new UncheckedExecutionException(e.getMessage(), e);
        }
    }

    private boolean printPageEntries(LedgerCache.PageEntries page) {
        MutableLong curEntry = new MutableLong(page.getFirstEntry());
        try (LedgerEntryPage lep = page.getLEP();){
            lep.getEntries((entry, offset) -> {
                while (curEntry.longValue() < entry) {
                    this.print.accept("entry " + curEntry + "\t:\tN/A");
                    curEntry.increment();
                }
                long entryLogId = offset >> 32;
                long pos = offset & 0xFFFFFFFFL;
                this.print.accept("entry " + curEntry + "\t:\t(log:" + entryLogId + ", pos: " + pos + ")");
                curEntry.increment();
                return true;
            });
        }
        catch (Exception e) {
            this.print.accept("Failed to read index page @ " + page.getFirstEntry() + ", the index file may be corrupted : " + e.getMessage());
            return true;
        }
        while (curEntry.longValue() < page.getLastEntry()) {
            this.print.accept("entry " + curEntry + "\t:\tN/A");
            curEntry.increment();
        }
        return false;
    }

    private void printInfoLine(String mes) {
        System.out.println(mes);
    }

    public static class LedgerFlags
    extends CliFlags {
        @Parameter(names={"-id", "--ledgerId"}, description="Specific ledger id", required=true)
        private long ledgerId;
        @Parameter(names={"-m", "--meta"}, description="Print meta information")
        private boolean meta;
        @Parameter(names={"-l", "--ledgeridformatter"}, description="Set ledger id formatter")
        private String ledgerIdFormatter = "";

        public LedgerFlags ledgerId(long ledgerId) {
            this.ledgerId = ledgerId;
            return this;
        }

        public LedgerFlags meta(boolean meta) {
            this.meta = meta;
            return this;
        }

        public LedgerFlags ledgerIdFormatter(String ledgerIdFormatter) {
            this.ledgerIdFormatter = ledgerIdFormatter;
            return this;
        }
    }
}

