/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.tools.cli.commands.bookie;

import com.beust.jcommander.Parameter;
import dlshade.com.google.common.util.concurrent.UncheckedExecutionException;
import dlshade.org.apache.bookkeeper.bookie.LocalBookieEnsemblePlacementPolicy;
import dlshade.org.apache.bookkeeper.client.BookKeeper;
import dlshade.org.apache.bookkeeper.client.LedgerEntry;
import dlshade.org.apache.bookkeeper.client.LedgerHandle;
import dlshade.org.apache.bookkeeper.conf.ClientConfiguration;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import dlshade.org.apache.bookkeeper.tools.framework.CliFlags;
import dlshade.org.apache.bookkeeper.tools.framework.CliSpec;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SanityTestCommand
extends BookieCommand<SanityFlags> {
    private static final Logger LOG = LoggerFactory.getLogger(SanityTestCommand.class);
    private static final String NAME = "sanitytest";
    private static final String DESC = "Sanity test for local bookie. Create ledger and write/reads entries on local bookie.";

    public SanityTestCommand() {
        this(new SanityFlags());
    }

    public SanityTestCommand(SanityFlags flags) {
        super(CliSpec.newBuilder().withFlags(flags).withName(NAME).withDescription(DESC).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, SanityFlags cmdFlags) {
        try {
            return this.handle(conf, cmdFlags);
        }
        catch (Exception e) {
            throw new UncheckedExecutionException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handle(ServerConfiguration conf, SanityFlags cmdFlags) throws Exception {
        ClientConfiguration clientConf = new ClientConfiguration();
        clientConf.addConfiguration((Configuration)conf);
        clientConf.setEnsemblePlacementPolicy(LocalBookieEnsemblePlacementPolicy.class);
        clientConf.setAddEntryTimeout(cmdFlags.timeout);
        clientConf.setReadEntryTimeout(cmdFlags.timeout);
        BookKeeper bk = new BookKeeper(clientConf);
        LedgerHandle lh = null;
        try {
            lh = bk.createLedger(1, 1, BookKeeper.DigestType.MAC, new byte[0]);
            LOG.info("Create ledger {}", (Object)lh.getId());
            for (int i = 0; i < cmdFlags.entries; ++i) {
                String content = "entry-" + i;
                lh.addEntry(content.getBytes(StandardCharsets.UTF_8));
            }
            LOG.info("Written {} entries in ledger {}", (Object)cmdFlags.entries, (Object)lh.getId());
            lh = bk.openLedger(lh.getId(), BookKeeper.DigestType.MAC, new byte[0]);
            if (lh.getLastAddConfirmed() != (long)(cmdFlags.entries - 1)) {
                throw new Exception("Invalid last entry found on ledger. expecting: " + (cmdFlags.entries - 1) + " -- found: " + lh.getLastAddConfirmed());
            }
            Enumeration<LedgerEntry> entries = lh.readEntries(0L, cmdFlags.entries - 1);
            int i = 0;
            while (entries.hasMoreElements()) {
                LedgerEntry entry = entries.nextElement();
                String actualMsg = new String(entry.getEntry(), StandardCharsets.UTF_8);
                String expectedMsg = "entry-" + i++;
                if (expectedMsg.equals(actualMsg)) continue;
                throw new Exception("Failed validation of received message - Expected: " + expectedMsg + ", Actual: " + actualMsg);
            }
            LOG.info("Read {} entries from ledger {}", (Object)i, (Object)lh.getId());
        }
        catch (Exception e) {
            LOG.warn("Error in bookie sanity test", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (lh != null) {
                bk.deleteLedger(lh.getId());
                LOG.info("Deleted ledger {}", (Object)lh.getId());
            }
            bk.close();
        }
        LOG.info("Bookie sanity test succeeded");
        return true;
    }

    public static class SanityFlags
    extends CliFlags {
        @Parameter(names={"-e", "--entries"}, description="Total entries to be added for the test (default 10)")
        private int entries = 10;
        @Parameter(names={"-t", "--timeout"}, description="Timeout for write/read operations in seconds (default 1)")
        private int timeout = 1;

        public SanityFlags entries(int entries) {
            this.entries = entries;
            return this;
        }

        public SanityFlags timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }
    }
}

