/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.tools.cli.commands.cookie;

import com.beust.jcommander.Parameter;
import dlshade.org.apache.bookkeeper.bookie.Cookie;
import dlshade.org.apache.bookkeeper.discover.RegistrationManager;
import dlshade.org.apache.bookkeeper.net.BookieId;
import dlshade.org.apache.bookkeeper.tools.cli.commands.cookie.CookieCommand;
import dlshade.org.apache.bookkeeper.tools.framework.CliFlags;
import dlshade.org.apache.bookkeeper.tools.framework.CliSpec;
import dlshade.org.apache.commons.lang3.StringUtils;
import java.io.File;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateCookieCommand
extends CookieCommand<Flags> {
    private static final Logger log = LoggerFactory.getLogger(GenerateCookieCommand.class);
    private static final String NAME = "generate";
    private static final String DESC = "Generate a cookie for a given bookie";

    public GenerateCookieCommand() {
        this(new Flags());
    }

    GenerateCookieCommand(PrintStream console) {
        this(new Flags(), console);
    }

    public GenerateCookieCommand(Flags flags) {
        this(flags, System.out);
    }

    private GenerateCookieCommand(Flags flags, PrintStream console) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(flags).withConsole(console).withArgumentsUsage("<bookie-id>").build());
    }

    @Override
    protected void apply(RegistrationManager rm, Flags cmdFlags) throws Exception {
        BookieId bookieId = this.getBookieId(cmdFlags);
        String instanceId = null == cmdFlags.instanceId ? rm.getClusterInstanceId() : cmdFlags.instanceId;
        Cookie.Builder builder = Cookie.newBuilder();
        builder.setBookieId(bookieId.toString());
        if (StringUtils.isEmpty(instanceId)) {
            builder.setInstanceId(null);
        } else {
            builder.setInstanceId(instanceId);
        }
        builder.setJournalDirs(cmdFlags.journalDirs);
        builder.setLedgerDirs(Cookie.encodeDirPaths(cmdFlags.ledgerDirs.split(",")));
        Cookie cookie = builder.build();
        cookie.writeToFile(new File(cmdFlags.outputFile));
        this.spec.console().println("Successfully saved the generated cookie to " + cmdFlags.outputFile);
    }

    public static class Flags
    extends CliFlags {
        @Parameter(names={"-j", "--journal-dirs"}, description="The journal directories used by this bookie", required=true)
        private String journalDirs;
        @Parameter(names={"-l", "--ledger-dirs"}, description="The ledger directories used by this bookie", required=true)
        private String ledgerDirs;
        @Parameter(names={"-i", "--instance-id"}, description="The instance id of the cluster that this bookie belongs to. If omitted, it will used the instance id of the cluster that this cli connects to.")
        private String instanceId = null;
        @Parameter(names={"-o", "--output-file"}, description="The output file to save the generated cookie.", required=true)
        private String outputFile;

        public Flags journalDirs(String journalDirs) {
            this.journalDirs = journalDirs;
            return this;
        }

        public Flags ledgerDirs(String ledgerDirs) {
            this.ledgerDirs = ledgerDirs;
            return this;
        }

        public Flags instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Flags outputFile(String outputFile) {
            this.outputFile = outputFile;
            return this;
        }
    }
}

