/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.tools.framework;

import dlshade.com.google.common.collect.Sets;
import dlshade.org.apache.bookkeeper.tools.framework.CliFlags;
import dlshade.org.apache.bookkeeper.tools.framework.Command;
import java.io.PrintStream;
import java.util.Set;
import java.util.function.Function;

public class CliSpec<CliFlagsT extends CliFlags> {
    private final String category;
    private final String name;
    private final String parent;
    private final String usage;
    private final String argumentsUsage;
    private final CliFlagsT flags;
    private final String description;
    private final Set<Command> commands;
    private final String tailer;
    private final Function<CliFlagsT, Boolean> runFunc;
    private final PrintStream console;
    private final boolean isCommandGroup;

    public static <T extends CliFlags> Builder<T> newBuilder() {
        return new Builder();
    }

    public static <T extends CliFlags> Builder<T> newBuilder(CliSpec<T> spec) {
        return new Builder(spec);
    }

    private CliSpec(String category, String name, String parent, String usage, String argumentsUsage, CliFlagsT flags, String description, Set<Command> commands, String tailer, Function<CliFlagsT, Boolean> runFunc, PrintStream console, boolean isCommandGroup) {
        this.category = category;
        this.name = name;
        this.parent = parent;
        this.usage = usage;
        this.flags = flags;
        this.argumentsUsage = argumentsUsage;
        this.description = description;
        this.commands = commands;
        this.tailer = tailer;
        this.runFunc = runFunc;
        this.console = console;
        this.isCommandGroup = isCommandGroup;
    }

    public String category() {
        return this.category;
    }

    public String name() {
        return this.name;
    }

    public String parent() {
        return this.parent;
    }

    public String usage() {
        return this.usage;
    }

    public String argumentsUsage() {
        return this.argumentsUsage;
    }

    public CliFlagsT flags() {
        return this.flags;
    }

    public String description() {
        return this.description;
    }

    public Set<Command> commands() {
        return this.commands;
    }

    public String tailer() {
        return this.tailer;
    }

    public Function<CliFlagsT, Boolean> runFunc() {
        return this.runFunc;
    }

    public PrintStream console() {
        return this.console;
    }

    public boolean isCommandGroup() {
        return this.isCommandGroup;
    }

    public String toString() {
        return "CliSpec(category=" + this.category + ", name=" + this.name + ", parent=" + this.parent + ", usage=" + this.usage + ", argumentsUsage=" + this.argumentsUsage + ", flags=" + this.flags + ", description=" + this.description + ", commands=" + this.commands + ", tailer=" + this.tailer + ", runFunc=" + this.runFunc + ", console=" + this.console + ", isCommandGroup=" + this.isCommandGroup() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CliSpec)) {
            return false;
        }
        CliSpec other = (CliSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCommandGroup() != other.isCommandGroup()) {
            return false;
        }
        String this$category = this.category;
        String other$category = other.category;
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$parent = this.parent;
        String other$parent = other.parent;
        if (this$parent == null ? other$parent != null : !this$parent.equals(other$parent)) {
            return false;
        }
        String this$usage = this.usage;
        String other$usage = other.usage;
        if (this$usage == null ? other$usage != null : !this$usage.equals(other$usage)) {
            return false;
        }
        String this$argumentsUsage = this.argumentsUsage;
        String other$argumentsUsage = other.argumentsUsage;
        if (this$argumentsUsage == null ? other$argumentsUsage != null : !this$argumentsUsage.equals(other$argumentsUsage)) {
            return false;
        }
        CliFlagsT this$flags = this.flags;
        CliFlagsT other$flags = other.flags;
        if (this$flags == null ? other$flags != null : !this$flags.equals(other$flags)) {
            return false;
        }
        String this$description = this.description;
        String other$description = other.description;
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Set<Command> this$commands = this.commands;
        Set<Command> other$commands = other.commands;
        if (this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands)) {
            return false;
        }
        String this$tailer = this.tailer;
        String other$tailer = other.tailer;
        if (this$tailer == null ? other$tailer != null : !this$tailer.equals(other$tailer)) {
            return false;
        }
        Function<CliFlagsT, Boolean> this$runFunc = this.runFunc;
        Function<CliFlagsT, Boolean> other$runFunc = other.runFunc;
        if (this$runFunc == null ? other$runFunc != null : !this$runFunc.equals(other$runFunc)) {
            return false;
        }
        PrintStream this$console = this.console;
        PrintStream other$console = other.console;
        return !(this$console == null ? other$console != null : !this$console.equals(other$console));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CliSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCommandGroup() ? 79 : 97);
        String $category = this.category;
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $parent = this.parent;
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        String $usage = this.usage;
        result = result * 59 + ($usage == null ? 43 : $usage.hashCode());
        String $argumentsUsage = this.argumentsUsage;
        result = result * 59 + ($argumentsUsage == null ? 43 : $argumentsUsage.hashCode());
        CliFlagsT $flags = this.flags;
        result = result * 59 + ($flags == null ? 43 : $flags.hashCode());
        String $description = this.description;
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Set<Command> $commands = this.commands;
        result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
        String $tailer = this.tailer;
        result = result * 59 + ($tailer == null ? 43 : $tailer.hashCode());
        Function<CliFlagsT, Boolean> $runFunc = this.runFunc;
        result = result * 59 + ($runFunc == null ? 43 : $runFunc.hashCode());
        PrintStream $console = this.console;
        result = result * 59 + ($console == null ? 43 : $console.hashCode());
        return result;
    }

    /* synthetic */ CliSpec(String x0, String x1, String x2, String x3, String x4, CliFlags x5, String x6, Set x7, String x8, Function x9, PrintStream x10, boolean x11, 1 x12) {
        this(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11);
    }

    public static class Builder<CliFlagsT extends CliFlags> {
        private String name = "unknown";
        private String parent = "";
        private String usage = "";
        private CliFlagsT flags = null;
        private String description = "unset";
        private final Set<Command> commands = Sets.newHashSet();
        private String tailer = "";
        private Function<CliFlagsT, Boolean> runFunc = null;
        private PrintStream console = System.out;
        private boolean isCommandGroup = false;
        private String argumentsUsage = "";
        private String category = "";

        private Builder() {
        }

        private Builder(CliSpec<CliFlagsT> spec) {
            this.category = ((CliSpec)spec).category;
            this.name = ((CliSpec)spec).name;
            this.parent = ((CliSpec)spec).parent;
            this.usage = ((CliSpec)spec).usage;
            this.argumentsUsage = ((CliSpec)spec).argumentsUsage;
            this.flags = ((CliSpec)spec).flags;
            this.description = ((CliSpec)spec).description;
            this.commands.clear();
            this.commands.addAll(((CliSpec)spec).commands);
            this.tailer = ((CliSpec)spec).tailer;
            this.runFunc = ((CliSpec)spec).runFunc;
            this.console = ((CliSpec)spec).console;
            this.isCommandGroup = ((CliSpec)spec).isCommandGroup;
        }

        public Builder<CliFlagsT> withCategory(String category) {
            this.category = category;
            return this;
        }

        public Builder<CliFlagsT> withName(String name) {
            this.name = name;
            return this;
        }

        public Builder<CliFlagsT> withParent(String parent) {
            this.parent = parent;
            return this;
        }

        public Builder<CliFlagsT> withUsage(String usage) {
            this.usage = usage;
            return this;
        }

        public Builder<CliFlagsT> withArgumentsUsage(String usage) {
            this.argumentsUsage = usage;
            return this;
        }

        public Builder<CliFlagsT> withFlags(CliFlagsT flags) {
            this.flags = flags;
            return this;
        }

        public Builder<CliFlagsT> withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder<CliFlagsT> addCommand(Command command) {
            this.commands.add(command);
            return this;
        }

        public Builder<CliFlagsT> withTailer(String tailer) {
            this.tailer = tailer;
            return this;
        }

        public Builder<CliFlagsT> withRunFunc(Function<CliFlagsT, Boolean> func) {
            this.runFunc = func;
            return this;
        }

        public Builder<CliFlagsT> withConsole(PrintStream console) {
            this.console = console;
            return this;
        }

        public Builder<CliFlagsT> setCommandGroup(boolean enabled) {
            this.isCommandGroup = enabled;
            return this;
        }

        public CliSpec<CliFlagsT> build() {
            return new CliSpec(this.category, this.name, this.parent, this.usage, this.argumentsUsage, (CliFlags)this.flags, this.description, this.commands, this.tailer, this.runFunc, this.console, this.isCommandGroup, null);
        }
    }
}

