/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.util;

import dlshade.org.apache.bookkeeper.common.util.ReflectionUtils;
import dlshade.org.apache.bookkeeper.conf.AbstractConfiguration;
import dlshade.org.apache.bookkeeper.util.HexDumpEntryFormatter;
import dlshade.org.apache.bookkeeper.util.StringEntryFormatter;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntryFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(EntryFormatter.class);
    public static final EntryFormatter STRING_FORMATTER = new StringEntryFormatter();

    public abstract void formatEntry(byte[] var1);

    public abstract void formatEntry(InputStream var1);

    public static EntryFormatter newEntryFormatter(AbstractConfiguration<?> conf) {
        EntryFormatter formatter;
        try {
            Class<EntryFormatter> entryFormatterClass = conf.getEntryFormatterClass();
            formatter = ReflectionUtils.newInstance(entryFormatterClass);
        }
        catch (Exception e) {
            LOG.warn("No formatter class found", (Throwable)e);
            LOG.warn("Using Default String Formatter.");
            formatter = new StringEntryFormatter();
        }
        return formatter;
    }

    public static EntryFormatter newEntryFormatter(String opt, AbstractConfiguration conf) {
        EntryFormatter formatter;
        if ("hex".equals(opt)) {
            formatter = new HexDumpEntryFormatter();
        } else if ("string".equals(opt)) {
            formatter = new StringEntryFormatter();
        } else {
            LOG.warn("specified unexpected entryformat {}, so default EntryFormatter is used", (Object)opt);
            formatter = EntryFormatter.newEntryFormatter(conf);
        }
        return formatter;
    }
}

