/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.http.impl.io;

import dlshade.org.apache.http.HttpResponse;
import dlshade.org.apache.http.HttpResponseFactory;
import dlshade.org.apache.http.annotation.Contract;
import dlshade.org.apache.http.annotation.ThreadingBehavior;
import dlshade.org.apache.http.config.MessageConstraints;
import dlshade.org.apache.http.impl.DefaultHttpResponseFactory;
import dlshade.org.apache.http.impl.io.DefaultHttpResponseParser;
import dlshade.org.apache.http.io.HttpMessageParser;
import dlshade.org.apache.http.io.HttpMessageParserFactory;
import dlshade.org.apache.http.io.SessionInputBuffer;
import dlshade.org.apache.http.message.BasicLineParser;
import dlshade.org.apache.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

