/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.rocksdb;

import dlshade.org.rocksdb.RateLimiterMode;
import dlshade.org.rocksdb.RocksObject;

public class RateLimiter
extends RocksObject {
    public static final long DEFAULT_REFILL_PERIOD_MICROS = 100000L;
    public static final int DEFAULT_FAIRNESS = 10;
    public static final RateLimiterMode DEFAULT_MODE = RateLimiterMode.WRITES_ONLY;
    public static final boolean DEFAULT_AUTOTUNE = false;

    public RateLimiter(long l) {
        this(l, 100000L, 10, DEFAULT_MODE, false);
    }

    public RateLimiter(long l, long l2) {
        this(l, l2, 10, DEFAULT_MODE, false);
    }

    public RateLimiter(long l, long l2, int n) {
        this(l, l2, n, DEFAULT_MODE, false);
    }

    public RateLimiter(long l, long l2, int n, RateLimiterMode rateLimiterMode) {
        this(l, l2, n, rateLimiterMode, false);
    }

    public RateLimiter(long l, long l2, int n, RateLimiterMode rateLimiterMode, boolean bl) {
        super(RateLimiter.newRateLimiterHandle(l, l2, n, rateLimiterMode.getValue(), bl));
    }

    public void setBytesPerSecond(long l) {
        assert (this.isOwningHandle());
        this.setBytesPerSecond(this.nativeHandle_, l);
    }

    public long getBytesPerSecond() {
        assert (this.isOwningHandle());
        return this.getBytesPerSecond(this.nativeHandle_);
    }

    public void request(long l) {
        assert (this.isOwningHandle());
        this.request(this.nativeHandle_, l);
    }

    public long getSingleBurstBytes() {
        assert (this.isOwningHandle());
        return this.getSingleBurstBytes(this.nativeHandle_);
    }

    public long getTotalBytesThrough() {
        assert (this.isOwningHandle());
        return this.getTotalBytesThrough(this.nativeHandle_);
    }

    public long getTotalRequests() {
        assert (this.isOwningHandle());
        return this.getTotalRequests(this.nativeHandle_);
    }

    private static native long newRateLimiterHandle(long var0, long var2, int var4, byte var5, boolean var6);

    @Override
    protected final native void disposeInternal(long var1);

    private native void setBytesPerSecond(long var1, long var3);

    private native long getBytesPerSecond(long var1);

    private native void request(long var1, long var3);

    private native long getSingleBurstBytes(long var1);

    private native long getTotalBytesThrough(long var1);

    private native long getTotalRequests(long var1);
}

