/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import dlshade.com.google.common.base.Ticker;
import dlshade.org.apache.bookkeeper.common.concurrent.FutureUtils;
import dlshade.org.apache.bookkeeper.common.util.OrderedScheduler;
import dlshade.org.apache.bookkeeper.feature.FeatureProvider;
import dlshade.org.apache.bookkeeper.stats.StatsLogger;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.configuration.Configuration;
import org.apache.distributedlog.BKDistributedLogManager;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.acl.AccessControlManager;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.callback.NamespaceListener;
import org.apache.distributedlog.common.util.PermitLimiter;
import org.apache.distributedlog.common.util.SchedulerUtils;
import org.apache.distributedlog.config.DynamicDistributedLogConfiguration;
import org.apache.distributedlog.exceptions.AlreadyClosedException;
import org.apache.distributedlog.exceptions.InvalidStreamNameException;
import org.apache.distributedlog.exceptions.LogNotFoundException;
import org.apache.distributedlog.injector.AsyncFailureInjector;
import org.apache.distributedlog.logsegment.LogSegmentMetadataCache;
import org.apache.distributedlog.namespace.NamespaceDriver;
import org.apache.distributedlog.util.ConfUtils;
import org.apache.distributedlog.util.DLUtils;
import org.apache.distributedlog.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BKDistributedLogNamespace
implements Namespace {
    static final Logger LOG = LoggerFactory.getLogger(BKDistributedLogNamespace.class);
    private final String clientId;
    private final int regionId;
    private final DistributedLogConfiguration conf;
    private final URI namespace;
    private final NamespaceDriver driver;
    private final OrderedScheduler scheduler;
    private final PermitLimiter writeLimiter;
    private final AsyncFailureInjector failureInjector;
    private final LogSegmentMetadataCache logSegmentMetadataCache;
    private final FeatureProvider featureProvider;
    private final StatsLogger statsLogger;
    private final StatsLogger perLogStatsLogger;
    protected final AtomicBoolean closed = new AtomicBoolean(false);

    public BKDistributedLogNamespace(DistributedLogConfiguration conf, URI uri, NamespaceDriver driver, OrderedScheduler scheduler, FeatureProvider featureProvider, PermitLimiter writeLimiter, AsyncFailureInjector failureInjector, StatsLogger statsLogger, StatsLogger perLogStatsLogger, String clientId, int regionId) {
        this.conf = conf;
        this.namespace = uri;
        this.driver = driver;
        this.scheduler = scheduler;
        this.featureProvider = featureProvider;
        this.writeLimiter = writeLimiter;
        this.failureInjector = failureInjector;
        this.statsLogger = statsLogger;
        this.perLogStatsLogger = perLogStatsLogger;
        this.clientId = clientId;
        this.regionId = regionId;
        this.logSegmentMetadataCache = new LogSegmentMetadataCache(conf, Ticker.systemTicker());
    }

    @Override
    public NamespaceDriver getNamespaceDriver() {
        return this.driver;
    }

    @Override
    public void createLog(String logName) throws InvalidStreamNameException, IOException {
        this.checkState();
        logName = DLUtils.validateAndNormalizeName(logName);
        URI uri = Utils.ioResult(this.driver.getLogMetadataStore().createLog(logName));
        Utils.ioResult(this.driver.getLogStreamMetadataStore(NamespaceDriver.Role.WRITER).getLog(uri, logName, true, true));
    }

    @Override
    public void deleteLog(String logName) throws InvalidStreamNameException, LogNotFoundException, IOException {
        this.checkState();
        logName = DLUtils.validateAndNormalizeName(logName);
        Optional<URI> uri = Utils.ioResult(this.driver.getLogMetadataStore().getLogLocation(logName));
        if (!uri.isPresent()) {
            throw new LogNotFoundException("Log " + logName + " isn't found.");
        }
        DistributedLogManager dlm = this.openLogInternal(uri.get(), logName, Optional.empty(), Optional.empty());
        dlm.delete();
    }

    @Override
    public DistributedLogManager openLog(String logName) throws InvalidStreamNameException, IOException {
        return this.openLog(logName, Optional.empty(), Optional.empty(), Optional.empty());
    }

    @Override
    public DistributedLogManager openLog(String logName, Optional<DistributedLogConfiguration> logConf, Optional<DynamicDistributedLogConfiguration> dynamicLogConf, Optional<StatsLogger> perStreamStatsLogger) throws InvalidStreamNameException, IOException {
        this.checkState();
        logName = DLUtils.validateAndNormalizeName(logName);
        Optional<URI> uri = Utils.ioResult(this.driver.getLogMetadataStore().getLogLocation(logName));
        if (!uri.isPresent()) {
            throw new LogNotFoundException("Log " + logName + " isn't found.");
        }
        return this.openLogInternal(uri.get(), logName, logConf, dynamicLogConf);
    }

    @Override
    public CompletableFuture<Void> renameLog(String oldName, String newName) {
        try {
            this.checkState();
            String oldLogName = DLUtils.validateAndNormalizeName(oldName);
            String newLogName = DLUtils.validateAndNormalizeName(newName);
            return this.driver.getLogMetadataStore().getLogLocation(oldName).thenCompose(uriOptional -> {
                if (uriOptional.isPresent()) {
                    return this.driver.getLogStreamMetadataStore(NamespaceDriver.Role.WRITER).renameLog((URI)uriOptional.get(), oldLogName, newLogName);
                }
                return FutureUtils.exception(new LogNotFoundException("Log " + oldLogName + " isn't found."));
            });
        }
        catch (IOException ioe) {
            return FutureUtils.exception(ioe);
        }
    }

    @Override
    public boolean logExists(String logName) throws IOException, IllegalArgumentException {
        this.checkState();
        Optional<URI> uri = Utils.ioResult(this.driver.getLogMetadataStore().getLogLocation(logName));
        if (uri.isPresent()) {
            try {
                Utils.ioResult(this.driver.getLogStreamMetadataStore(NamespaceDriver.Role.WRITER).logExists(uri.get(), logName));
                return true;
            }
            catch (LogNotFoundException lnfe) {
                return false;
            }
        }
        return false;
    }

    @Override
    public Iterator<String> getLogs() throws IOException {
        this.checkState();
        return Utils.ioResult(this.driver.getLogMetadataStore().getLogs(""));
    }

    @Override
    public Iterator<String> getLogs(String logNamePrefix) throws IOException {
        this.checkState();
        logNamePrefix = DLUtils.validateAndNormalizeName(logNamePrefix);
        return Utils.ioResult(this.driver.getLogMetadataStore().getLogs(logNamePrefix));
    }

    @Override
    public void registerNamespaceListener(NamespaceListener listener) {
        this.driver.getLogMetadataStore().registerNamespaceListener(listener);
    }

    @Override
    public synchronized AccessControlManager createAccessControlManager() throws IOException {
        this.checkState();
        return this.driver.getAccessControlManager();
    }

    protected DistributedLogManager openLogInternal(URI uri, String nameOfLogStream, Optional<DistributedLogConfiguration> logConfiguration, Optional<DynamicDistributedLogConfiguration> dynamicLogConfiguration) throws InvalidStreamNameException, IOException {
        this.checkState();
        nameOfLogStream = DLUtils.validateAndNormalizeName(nameOfLogStream);
        DistributedLogConfiguration mergedConfiguration = new DistributedLogConfiguration();
        mergedConfiguration.addConfiguration((Configuration)this.conf);
        mergedConfiguration.loadStreamConf(logConfiguration);
        DynamicDistributedLogConfiguration dynConf = null;
        dynConf = dynamicLogConfiguration.isPresent() ? dynamicLogConfiguration.get() : ConfUtils.getConstDynConf(mergedConfiguration);
        return new BKDistributedLogManager(nameOfLogStream, mergedConfiguration, dynConf, uri, this.driver, this.logSegmentMetadataCache, this.scheduler, this.clientId, this.regionId, this.writeLimiter, this.featureProvider.scope("dl"), this.failureInjector, this.statsLogger, this.perLogStatsLogger, Optional.empty());
    }

    private void checkState() throws IOException {
        if (this.closed.get()) {
            LOG.error("BK namespace {} is already closed", (Object)this.namespace);
            throw new AlreadyClosedException("BK namespace " + this.namespace + " is already closed");
        }
    }

    @Override
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.writeLimiter.close();
        Utils.close(this.driver);
        SchedulerUtils.shutdownScheduler(this.scheduler, this.conf.getSchedulerShutdownTimeoutMs(), TimeUnit.MILLISECONDS);
        LOG.info("Executor Service Stopped.");
    }
}

