/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import dlshade.com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.LogRecordSet;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.RecordStream;
import org.apache.distributedlog.common.util.ByteBufUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class LogRecord {
    private static final Logger LOG = LoggerFactory.getLogger(LogRecord.class);
    public static final int MAX_LOGRECORD_SIZE = 1040384;
    public static final int MAX_LOGRECORDSET_SIZE = 1044480;
    private static final int INPUTSTREAM_MARK_LIMIT = 16;
    static final long LOGRECORD_METADATA_FLAGS_MASK = 65535L;
    static final long LOGRECORD_METADATA_FLAGS_UMASK = -65536L;
    static final long LOGRECORD_METADATA_POSITION_MASK = 0xFFFFFFFF0000L;
    static final long LOGRECORD_METADATA_POSITION_UMASK = -281474976645121L;
    static final int LOGRECORD_METADATA_POSITION_SHIFT = 16;
    static final long LOGRECORD_METADATA_UNUSED_MASK = -281474976710656L;
    static final long LOGRECORD_FLAGS_CONTROL_MESSAGE = 1L;
    static final long LOGRECORD_FLAGS_END_OF_STREAM = 2L;
    static final long LOGRECORD_FLAGS_RECORD_SET = 4L;
    private long metadata;
    private long txid;
    private ByteBuf payload;

    protected LogRecord() {
        this.txid = 0L;
        this.metadata = 0L;
    }

    public LogRecord(long txid, byte[] payload) {
        this.txid = txid;
        this.payload = Unpooled.wrappedBuffer((byte[])payload);
    }

    public LogRecord(long txid, ByteBuffer buffer) {
        this.txid = txid;
        this.payload = Unpooled.wrappedBuffer((ByteBuffer)buffer);
    }

    public LogRecord(long txid, ByteBuf payload) {
        this.txid = txid;
        this.payload = payload;
        this.metadata = 0L;
    }

    public long getTransactionId() {
        return this.txid;
    }

    protected void setTransactionId(long txid) {
        this.txid = txid;
    }

    public byte[] getPayload() {
        return ByteBufUtils.getArray(this.payload);
    }

    public ByteBuf getPayloadBuf() {
        return this.payload.slice();
    }

    void setPayloadBuf(ByteBuf payload, boolean copyData) {
        if (null != this.payload) {
            this.payload.release();
        }
        this.payload = copyData ? Unpooled.copiedBuffer((ByteBuf)payload) : payload;
    }

    public InputStream getPayLoadInputStream() {
        return new ByteBufInputStream(this.payload.retainedSlice(), true);
    }

    protected void setMetadata(long metadata) {
        this.metadata = metadata;
    }

    protected long getMetadata() {
        return this.metadata;
    }

    void setPositionWithinLogSegment(int positionWithinLogSegment) {
        assert (positionWithinLogSegment >= 0);
        this.metadata = this.metadata & 0xFFFF00000000FFFFL | (long)positionWithinLogSegment << 16;
    }

    public int getPositionWithinLogSegment() {
        long ret = (this.metadata & 0xFFFFFFFF0000L) >> 16;
        if (ret < 0L || ret > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(ret + " position should never exceed max integer value");
        }
        return (int)ret;
    }

    int getLastPositionWithinLogSegment() {
        if (this.isRecordSet()) {
            try {
                return this.getPositionWithinLogSegment() + LogRecordSet.numRecords(this) - 1;
            }
            catch (IOException e) {
                return this.getPositionWithinLogSegment();
            }
        }
        return this.getPositionWithinLogSegment();
    }

    public void setRecordSet() {
        this.metadata |= 4L;
    }

    public boolean isRecordSet() {
        return LogRecord.isRecordSet(this.metadata);
    }

    public static boolean isRecordSet(long metadata) {
        return (metadata & 4L) != 0L;
    }

    @VisibleForTesting
    public void setControl() {
        this.metadata |= 1L;
    }

    public boolean isControl() {
        return LogRecord.isControl(this.metadata);
    }

    public static boolean isControl(long flags) {
        return (flags & 1L) != 0L;
    }

    void setEndOfStream() {
        this.metadata |= 2L;
    }

    boolean isEndOfStream() {
        return (this.metadata & 2L) != 0L;
    }

    protected void readPayload(ByteBuf in, boolean copyData) throws IOException {
        int length = in.readInt();
        if (length < 0) {
            throw new EOFException("Log Record is corrupt: Negative length " + length);
        }
        if (copyData) {
            this.setPayloadBuf(in.slice(in.readerIndex(), length), true);
        } else {
            this.setPayloadBuf(in.retainedSlice(in.readerIndex(), length), false);
        }
        in.skipBytes(length);
    }

    private void writePayload(ByteBuf out) {
        out.writeInt(this.payload.readableBytes());
        out.writeBytes(this.payload, this.payload.readerIndex(), this.payload.readableBytes());
    }

    private void writeToStream(ByteBuf out) {
        out.writeLong(this.metadata);
        out.writeLong(this.txid);
        this.writePayload(out);
    }

    int getPersistentSize() {
        return 20 + this.payload.readableBytes();
    }

    public static class Reader {
        private final RecordStream recordStream;
        private final ByteBuf in;
        private final long startSequenceId;
        private final boolean deserializeRecordSet;
        private static final int SKIP_BUFFER_SIZE = 512;
        private LogRecordSet.Reader recordSetReader = null;
        private LogRecordWithDLSN lastRecordSkipTo = null;

        public Reader(RecordStream recordStream, ByteBuf in, long startSequenceId) {
            this(recordStream, in, startSequenceId, true);
        }

        public Reader(RecordStream recordStream, ByteBuf in, long startSequenceId, boolean deserializeRecordSet) {
            this.recordStream = recordStream;
            this.in = in;
            this.startSequenceId = startSequenceId;
            this.deserializeRecordSet = deserializeRecordSet;
        }

        /*
         * Exception decompiling
         */
        public LogRecordWithDLSN readOp() throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public boolean skipTo(long txId, boolean skipControl) throws IOException {
            return this.skipTo(txId, null, skipControl);
        }

        public boolean skipTo(DLSN dlsn) throws IOException {
            return this.skipTo(null, dlsn, false);
        }

        private boolean skipTo(Long txId, DLSN dlsn, boolean skipControl) throws IOException {
            boolean found = false;
            try {
                while (true) {
                    long currTxId;
                    long flags;
                    if (null == this.recordSetReader) {
                        this.in.markReaderIndex();
                        flags = this.in.readLong();
                        currTxId = this.in.readLong();
                    } else {
                        this.lastRecordSkipTo = this.recordSetReader.nextRecord();
                        if (null == this.lastRecordSkipTo) {
                            this.recordSetReader = null;
                            continue;
                        }
                        flags = this.lastRecordSkipTo.getMetadata();
                        currTxId = this.lastRecordSkipTo.getTransactionId();
                    }
                    if (null != dlsn && this.recordStream.getCurrentPosition().compareTo(dlsn) >= 0) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Found position {} beyond {}", (Object)this.recordStream.getCurrentPosition(), (Object)dlsn);
                        }
                        if (null == this.lastRecordSkipTo) {
                            this.in.resetReaderIndex();
                        }
                        found = true;
                        break;
                    }
                    if (!(null == txId || currTxId < txId || skipControl && LogRecord.isControl(flags))) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Found position {} beyond {}", (Object)currTxId, (Object)txId);
                        }
                        if (null == this.lastRecordSkipTo) {
                            this.in.resetReaderIndex();
                        }
                        found = true;
                        break;
                    }
                    if (null != this.lastRecordSkipTo) {
                        this.recordStream.advance(1);
                        continue;
                    }
                    if (LogRecord.isRecordSet(flags)) {
                        LogRecordWithDLSN record = new LogRecordWithDLSN(this.recordStream.getCurrentPosition(), this.startSequenceId);
                        record.setMetadata(flags);
                        record.setTransactionId(currTxId);
                        record.readPayload(this.in, false);
                        this.recordSetReader = LogRecordSet.of(record);
                        continue;
                    }
                    int length = this.in.readInt();
                    if (length < 0) {
                        LOG.info("Encountered Record with negative length at TxId: {}", (Object)currTxId);
                        break;
                    }
                    this.in.skipBytes(length);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Skipped Record with TxId {} DLSN {}", (Object)currTxId, (Object)this.recordStream.getCurrentPosition());
                    }
                    this.recordStream.advance(1);
                }
            }
            catch (EOFException eof) {
                LOG.debug("Skip encountered end of file Exception", (Throwable)eof);
            }
            return found;
        }
    }

    public static class Writer {
        private final ByteBuf buf;

        public Writer(ByteBuf out) {
            this.buf = out;
        }

        public void writeOp(LogRecord record) {
            record.writeToStream(this.buf);
        }

        public int getPendingBytes() {
            return this.buf.readableBytes();
        }
    }
}

