/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import dlshade.com.google.common.annotations.VisibleForTesting;
import dlshade.com.google.common.base.Objects;
import dlshade.org.apache.bookkeeper.common.concurrent.FutureUtils;
import dlshade.org.apache.zookeeper.AsyncCallback;
import dlshade.org.apache.zookeeper.CreateMode;
import dlshade.org.apache.zookeeper.KeeperException;
import dlshade.org.apache.zookeeper.data.Stat;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.exceptions.DLInterruptedException;
import org.apache.distributedlog.exceptions.LogSegmentNotFoundException;
import org.apache.distributedlog.exceptions.UnsupportedMetadataVersionException;
import org.apache.distributedlog.exceptions.ZKException;
import org.apache.distributedlog.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogSegmentMetadata {
    static final Logger LOG = LoggerFactory.getLogger(LogSegmentMetadata.class);
    private final String zkPath;
    private final long logSegmentId;
    private final LogSegmentMetadataVersion version;
    private final long firstTxId;
    private final int regionId;
    private final long status;
    private final long lastTxId;
    private final long completionTime;
    private final int recordCount;
    private final DLSN lastDLSN;
    private final DLSN minActiveDLSN;
    private final long startSequenceId;
    private final boolean inprogress;
    private final boolean envelopeEntries;
    public static final Comparator<LogSegmentMetadata> COMPARATOR = new Comparator<LogSegmentMetadata>(){

        @Override
        public int compare(LogSegmentMetadata o1, LogSegmentMetadata o2) {
            if (o1.getLogSegmentSequenceNumber() == 0L || o2.getLogSegmentSequenceNumber() == 0L) {
                if (o1.firstTxId < o2.firstTxId) {
                    return -1;
                }
                if (o1.firstTxId == o2.firstTxId) {
                    return 0;
                }
                return 1;
            }
            if (o1.getLogSegmentSequenceNumber() < o2.getLogSegmentSequenceNumber()) {
                return -1;
            }
            if (o1.getLogSegmentSequenceNumber() == o2.getLogSegmentSequenceNumber()) {
                if (o1.isInProgress() && !o2.isInProgress()) {
                    return -1;
                }
                if (!o1.isInProgress() && o2.isInProgress()) {
                    return 1;
                }
                return 0;
            }
            return 1;
        }
    };
    public static final Comparator<LogSegmentMetadata> DESC_COMPARATOR = new Comparator<LogSegmentMetadata>(){

        @Override
        public int compare(LogSegmentMetadata o1, LogSegmentMetadata o2) {
            if (o1.getLogSegmentSequenceNumber() == 0L || o2.getLogSegmentSequenceNumber() == 0L) {
                if (o1.firstTxId > o2.firstTxId) {
                    return -1;
                }
                if (o1.firstTxId == o2.firstTxId) {
                    return 0;
                }
                return 1;
            }
            if (o1.getLogSegmentSequenceNumber() > o2.getLogSegmentSequenceNumber()) {
                return -1;
            }
            if (o1.getLogSegmentSequenceNumber() == o2.getLogSegmentSequenceNumber()) {
                if (o1.isInProgress() && !o2.isInProgress()) {
                    return 1;
                }
                if (!o1.isInProgress() && o2.isInProgress()) {
                    return -1;
                }
                return 0;
            }
            return 1;
        }
    };
    public static final int LEDGER_METADATA_CURRENT_LAYOUT_VERSION = LogSegmentMetadataVersion.VERSION_V5_SEQUENCE_ID.value;
    public static final int LEDGER_METADATA_OLDEST_SUPPORTED_VERSION = LogSegmentMetadataVersion.VERSION_V2_LEDGER_SEQNO.value;
    static final int LOGRECORD_COUNT_SHIFT = 32;
    static final long LOGRECORD_COUNT_MASK = -4294967296L;
    static final int REGION_SHIFT = 28;
    static final long MAX_REGION_ID = 15L;
    static final long REGION_MASK = 0xF0000000L;
    static final int STATUS_BITS_SHIFT = 8;
    static final long STATUS_BITS_MASK = 65280L;
    static final long UNUSED_BITS_MASK = 0xFFF0000L;
    static final long METADATA_VERSION_MASK = 255L;
    static final long METADATA_TRUNCATION_STATUS_MASK = 3L;
    static final long METADATA_STATUS_BIT_MAX = 255L;

    private LogSegmentMetadata(String zkPath, LogSegmentMetadataVersion version, long logSegmentId, long firstTxId, long lastTxId, long completionTime, boolean inprogress, int recordCount, long logSegmentSequenceNumber, long lastEntryId, long lastSlotId, int regionId, long status, long minActiveEntryId, long minActiveSlotId, long startSequenceId, boolean envelopeEntries) {
        this.zkPath = zkPath;
        this.logSegmentId = logSegmentId;
        this.version = version;
        this.firstTxId = firstTxId;
        this.lastTxId = lastTxId;
        this.inprogress = inprogress;
        this.completionTime = completionTime;
        this.recordCount = recordCount;
        this.lastDLSN = new DLSN(logSegmentSequenceNumber, lastEntryId, lastSlotId);
        this.minActiveDLSN = new DLSN(logSegmentSequenceNumber, minActiveEntryId, minActiveSlotId);
        this.startSequenceId = startSequenceId;
        this.regionId = regionId;
        this.status = status;
        this.envelopeEntries = envelopeEntries;
    }

    public String getZkPath() {
        return this.zkPath;
    }

    public String getZNodeName() {
        return new File(this.zkPath).getName();
    }

    public long getFirstTxId() {
        return this.firstTxId;
    }

    public long getLastTxId() {
        return this.lastTxId;
    }

    public long getCompletionTime() {
        return this.completionTime;
    }

    public long getLogSegmentId() {
        return this.logSegmentId;
    }

    public long getLogSegmentSequenceNumber() {
        return this.lastDLSN.getLogSegmentSequenceNo();
    }

    public int getVersion() {
        return this.version.value;
    }

    public boolean getEnvelopeEntries() {
        return this.envelopeEntries;
    }

    public long getLastEntryId() {
        return this.lastDLSN.getEntryId();
    }

    long getStatus() {
        return this.status;
    }

    public long getStartSequenceId() {
        return this.supportsSequenceId() && this.startSequenceId != -1L ? this.startSequenceId : Long.MIN_VALUE + (this.getLogSegmentSequenceNumber() << 32);
    }

    public TruncationStatus getTruncationStatus() {
        switch ((int)(this.status & 3L)) {
            case 0: {
                return TruncationStatus.ACTIVE;
            }
            case 1: {
                return TruncationStatus.PARTIALLY_TRUNCATED;
            }
            case 2: {
                return TruncationStatus.TRUNCATED;
            }
        }
        return TruncationStatus.UNKNOWN;
    }

    public boolean isTruncated() {
        return (this.status & 3L) == (long)TruncationStatus.TRUNCATED.value;
    }

    public boolean isPartiallyTruncated() {
        return (this.status & 3L) == (long)TruncationStatus.PARTIALLY_TRUNCATED.value;
    }

    public boolean isNonTruncated() {
        return (this.status & 3L) == (long)TruncationStatus.ACTIVE.value;
    }

    public long getLastSlotId() {
        return this.lastDLSN.getSlotId();
    }

    public DLSN getLastDLSN() {
        return this.lastDLSN;
    }

    public DLSN getMinActiveDLSN() {
        return this.minActiveDLSN;
    }

    public long getMinActiveEntryId() {
        return this.minActiveDLSN.getEntryId();
    }

    public long getMinActiveSlotId() {
        return this.minActiveDLSN.getSlotId();
    }

    public DLSN getFirstDLSN() {
        return new DLSN(this.getLogSegmentSequenceNumber(), 0L, 0L);
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public int getRegionId() {
        return this.regionId;
    }

    public boolean isInProgress() {
        return this.inprogress;
    }

    @VisibleForTesting
    public boolean isDLSNinThisSegment(DLSN dlsn) {
        return dlsn.getLogSegmentSequenceNo() == this.getLogSegmentSequenceNumber();
    }

    @VisibleForTesting
    public boolean isRecordPositionWithinSegmentScope(LogRecord record) {
        return record.getLastPositionWithinLogSegment() <= this.getRecordCount();
    }

    @VisibleForTesting
    public boolean isRecordLastPositioninThisSegment(LogRecord record) {
        return record.getLastPositionWithinLogSegment() == this.getRecordCount();
    }

    LogSegmentMetadata completeLogSegment(String zkPath, long newLastTxId, int recordCount, long lastEntryId, long lastSlotId, long startSequenceId) {
        assert (this.lastTxId == -999L);
        return new Mutator(this).setZkPath(zkPath).setLastDLSN(new DLSN(this.lastDLSN.getLogSegmentSequenceNo(), lastEntryId, lastSlotId)).setLastTxId(newLastTxId).setInprogress(false).setCompletionTime(Utils.nowInMillis()).setRecordCount(recordCount).setStartSequenceId(startSequenceId).build();
    }

    public static CompletableFuture<LogSegmentMetadata> read(ZooKeeperClient zkc, String path) {
        return LogSegmentMetadata.read(zkc, path, false);
    }

    public static CompletableFuture<LogSegmentMetadata> read(ZooKeeperClient zkc, String path, final boolean skipMinVersionCheck) {
        final CompletableFuture<LogSegmentMetadata> result = new CompletableFuture<LogSegmentMetadata>();
        try {
            zkc.get().getData(path, false, new AsyncCallback.DataCallback(){

                @Override
                public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                    if (KeeperException.Code.OK.intValue() != rc) {
                        if (KeeperException.Code.NONODE.intValue() == rc) {
                            FutureUtils.completeExceptionally(result, new LogSegmentNotFoundException(path));
                        } else {
                            FutureUtils.completeExceptionally(result, new ZKException("Failed to read log segment metadata from " + path, KeeperException.Code.get(rc)));
                        }
                        return;
                    }
                    try {
                        LogSegmentMetadata metadata = LogSegmentMetadata.parseData(path, data, skipMinVersionCheck);
                        FutureUtils.complete(result, metadata);
                    }
                    catch (IOException ie) {
                        LOG.error("Error on parsing log segment metadata from {} : ", (Object)path, (Object)ie);
                        result.completeExceptionally(ie);
                    }
                }
            }, null);
        }
        catch (ZooKeeperClient.ZooKeeperConnectionException e) {
            result.completeExceptionally(Utils.zkException(e, path));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            result.completeExceptionally(Utils.zkException(e, path));
        }
        return result;
    }

    static LogSegmentMetadata parseDataV1(String path, byte[] data, String[] parts) throws IOException {
        long versionStatusCount = Long.parseLong(parts[0]);
        long version = versionStatusCount & 0xFFL;
        assert (version >= Integer.MIN_VALUE && version <= Integer.MAX_VALUE);
        assert (1L == version);
        LogSegmentMetadataVersion llmv = LogSegmentMetadataVersion.VERSION_V1_ORIGINAL;
        int regionId = (int)(versionStatusCount & 0xF0000000L) >> 28;
        assert (regionId >= 0 && regionId <= 15);
        long status = (versionStatusCount & 0xFF00L) >> 8;
        assert (status >= 0L && status <= 255L);
        if (parts.length == 3) {
            long logSegmentId = Long.parseLong(parts[1]);
            long txId = Long.parseLong(parts[2]);
            return new LogSegmentMetadataBuilder(path, llmv, logSegmentId, txId).setRegionId(regionId).setStatus(status).build();
        }
        if (parts.length == 5) {
            long recordCount = (versionStatusCount & 0xFFFFFFFF00000000L) >> 32;
            assert (recordCount >= Integer.MIN_VALUE && recordCount <= Integer.MAX_VALUE);
            long logSegmentId = Long.parseLong(parts[1]);
            long firstTxId = Long.parseLong(parts[2]);
            long lastTxId = Long.parseLong(parts[3]);
            long completionTime = Long.parseLong(parts[4]);
            return new LogSegmentMetadataBuilder(path, llmv, logSegmentId, firstTxId).setInprogress(false).setLastTxId(lastTxId).setCompletionTime(completionTime).setRecordCount((int)recordCount).setRegionId(regionId).setStatus(status).build();
        }
        throw new IOException("Invalid log segment metadata : " + new String(data, StandardCharsets.UTF_8));
    }

    static LogSegmentMetadata parseDataV2(String path, byte[] data, String[] parts) throws IOException {
        long versionStatusCount = Long.parseLong(parts[0]);
        long version = versionStatusCount & 0xFFL;
        assert (version >= Integer.MIN_VALUE && version <= Integer.MAX_VALUE);
        assert (2L == version);
        LogSegmentMetadataVersion llmv = LogSegmentMetadataVersion.VERSION_V2_LEDGER_SEQNO;
        int regionId = (int)((versionStatusCount & 0xF0000000L) >> 28);
        assert (regionId >= 0 && regionId <= 15);
        long status = (versionStatusCount & 0xFF00L) >> 8;
        assert (status >= 0L && status <= 255L);
        if (parts.length == 4) {
            long logSegmentId = Long.parseLong(parts[1]);
            long txId = Long.parseLong(parts[2]);
            long logSegmentSequenceNumber = Long.parseLong(parts[3]);
            return new LogSegmentMetadataBuilder(path, llmv, logSegmentId, txId).setLogSegmentSequenceNo(logSegmentSequenceNumber).setRegionId(regionId).setStatus(status).build();
        }
        if (parts.length == 8) {
            long recordCount = (versionStatusCount & 0xFFFFFFFF00000000L) >> 32;
            assert (recordCount >= Integer.MIN_VALUE && recordCount <= Integer.MAX_VALUE);
            long logSegmentId = Long.parseLong(parts[1]);
            long firstTxId = Long.parseLong(parts[2]);
            long lastTxId = Long.parseLong(parts[3]);
            long completionTime = Long.parseLong(parts[4]);
            long logSegmentSequenceNumber = Long.parseLong(parts[5]);
            long lastEntryId = Long.parseLong(parts[6]);
            long lastSlotId = Long.parseLong(parts[7]);
            return new LogSegmentMetadataBuilder(path, llmv, logSegmentId, firstTxId).setInprogress(false).setLastTxId(lastTxId).setCompletionTime(completionTime).setRecordCount((int)recordCount).setLogSegmentSequenceNo(logSegmentSequenceNumber).setLastEntryId(lastEntryId).setLastSlotId(lastSlotId).setRegionId(regionId).setStatus(status).build();
        }
        throw new IOException("Invalid logsegment metadata : " + new String(data, StandardCharsets.UTF_8));
    }

    static LogSegmentMetadata parseDataVersionsWithMinActiveDLSN(String path, byte[] data, String[] parts) throws IOException {
        long versionStatusCount = Long.parseLong(parts[0]);
        long version = versionStatusCount & 0xFFL;
        assert (version >= Integer.MIN_VALUE && version <= Integer.MAX_VALUE);
        assert ((long)LogSegmentMetadataVersion.VERSION_V3_MIN_ACTIVE_DLSN.value <= version && (long)LogSegmentMetadataVersion.VERSION_V4_ENVELOPED_ENTRIES.value >= version);
        LogSegmentMetadataVersion llmv = LogSegmentMetadataVersion.of((int)version);
        int regionId = (int)((versionStatusCount & 0xF0000000L) >> 28);
        assert (regionId >= 0 && regionId <= 15);
        long status = (versionStatusCount & 0xFF00L) >> 8;
        assert (status >= 0L && status <= 255L);
        if (parts.length == 6) {
            long logSegmentId = Long.parseLong(parts[1]);
            long txId = Long.parseLong(parts[2]);
            long logSegmentSequenceNumber = Long.parseLong(parts[3]);
            long minActiveEntryId = Long.parseLong(parts[4]);
            long minActiveSlotId = Long.parseLong(parts[5]);
            LogSegmentMetadataBuilder builder = new LogSegmentMetadataBuilder(path, llmv, logSegmentId, txId).setLogSegmentSequenceNo(logSegmentSequenceNumber).setMinActiveEntryId(minActiveEntryId).setMinActiveSlotId(minActiveSlotId).setRegionId(regionId).setStatus(status);
            if (LogSegmentMetadata.supportsEnvelopedEntries((int)version)) {
                builder = builder.setEnvelopeEntries(true);
            }
            return builder.build();
        }
        if (parts.length == 10) {
            long recordCount = (versionStatusCount & 0xFFFFFFFF00000000L) >> 32;
            assert (recordCount >= Integer.MIN_VALUE && recordCount <= Integer.MAX_VALUE);
            long logSegmentId = Long.parseLong(parts[1]);
            long firstTxId = Long.parseLong(parts[2]);
            long lastTxId = Long.parseLong(parts[3]);
            long completionTime = Long.parseLong(parts[4]);
            long logSegmentSequenceNumber = Long.parseLong(parts[5]);
            long lastEntryId = Long.parseLong(parts[6]);
            long lastSlotId = Long.parseLong(parts[7]);
            long minActiveEntryId = Long.parseLong(parts[8]);
            long minActiveSlotId = Long.parseLong(parts[9]);
            LogSegmentMetadataBuilder builder = new LogSegmentMetadataBuilder(path, llmv, logSegmentId, firstTxId).setInprogress(false).setLastTxId(lastTxId).setCompletionTime(completionTime).setRecordCount((int)recordCount).setLogSegmentSequenceNo(logSegmentSequenceNumber).setLastEntryId(lastEntryId).setLastSlotId(lastSlotId).setMinActiveEntryId(minActiveEntryId).setMinActiveSlotId(minActiveSlotId).setRegionId(regionId).setStatus(status);
            if (LogSegmentMetadata.supportsEnvelopedEntries((int)version)) {
                builder = builder.setEnvelopeEntries(true);
            }
            return builder.build();
        }
        throw new IOException("Invalid logsegment metadata : " + new String(data, StandardCharsets.UTF_8));
    }

    static LogSegmentMetadata parseDataVersionsWithSequenceId(String path, byte[] data, String[] parts) throws IOException {
        long versionStatusCount = Long.parseLong(parts[0]);
        long version = versionStatusCount & 0xFFL;
        assert (version >= Integer.MIN_VALUE && version <= Integer.MAX_VALUE);
        assert ((long)LogSegmentMetadataVersion.VERSION_V5_SEQUENCE_ID.value <= version && (long)LEDGER_METADATA_CURRENT_LAYOUT_VERSION >= version);
        LogSegmentMetadataVersion llmv = LogSegmentMetadataVersion.of((int)version);
        int regionId = (int)((versionStatusCount & 0xF0000000L) >> 28);
        assert (regionId >= 0 && regionId <= 15);
        long status = (versionStatusCount & 0xFF00L) >> 8;
        assert (status >= 0L && status <= 255L);
        if (parts.length == 7) {
            long logSegmentId = Long.parseLong(parts[1]);
            long txId = Long.parseLong(parts[2]);
            long logSegmentSequenceNumber = Long.parseLong(parts[3]);
            long minActiveEntryId = Long.parseLong(parts[4]);
            long minActiveSlotId = Long.parseLong(parts[5]);
            long startSequenceId = Long.parseLong(parts[6]);
            LogSegmentMetadataBuilder builder = new LogSegmentMetadataBuilder(path, llmv, logSegmentId, txId).setLogSegmentSequenceNo(logSegmentSequenceNumber).setMinActiveEntryId(minActiveEntryId).setMinActiveSlotId(minActiveSlotId).setRegionId(regionId).setStatus(status).setStartSequenceId(startSequenceId).setEnvelopeEntries(true);
            return builder.build();
        }
        if (parts.length == 11) {
            long recordCount = (versionStatusCount & 0xFFFFFFFF00000000L) >> 32;
            assert (recordCount >= Integer.MIN_VALUE && recordCount <= Integer.MAX_VALUE);
            long logSegmentId = Long.parseLong(parts[1]);
            long firstTxId = Long.parseLong(parts[2]);
            long lastTxId = Long.parseLong(parts[3]);
            long completionTime = Long.parseLong(parts[4]);
            long logSegmentSequenceNumber = Long.parseLong(parts[5]);
            long lastEntryId = Long.parseLong(parts[6]);
            long lastSlotId = Long.parseLong(parts[7]);
            long minActiveEntryId = Long.parseLong(parts[8]);
            long minActiveSlotId = Long.parseLong(parts[9]);
            long startSequenceId = Long.parseLong(parts[10]);
            LogSegmentMetadataBuilder builder = new LogSegmentMetadataBuilder(path, llmv, logSegmentId, firstTxId).setInprogress(false).setLastTxId(lastTxId).setCompletionTime(completionTime).setRecordCount((int)recordCount).setLogSegmentSequenceNo(logSegmentSequenceNumber).setLastEntryId(lastEntryId).setLastSlotId(lastSlotId).setMinActiveEntryId(minActiveEntryId).setMinActiveSlotId(minActiveSlotId).setRegionId(regionId).setStatus(status).setStartSequenceId(startSequenceId).setEnvelopeEntries(true);
            return builder.build();
        }
        throw new IOException("Invalid log segment metadata : " + new String(data, StandardCharsets.UTF_8));
    }

    public static LogSegmentMetadata parseData(String path, byte[] data) throws IOException {
        return LogSegmentMetadata.parseData(path, data, false);
    }

    static LogSegmentMetadata parseData(String path, byte[] data, boolean skipMinVersionCheck) throws IOException {
        long version;
        String[] parts = new String(data, StandardCharsets.UTF_8).split(";");
        try {
            version = Long.parseLong(parts[0]) & 0xFFL;
        }
        catch (Exception exc) {
            throw new IOException("Invalid ledger entry, " + new String(data, StandardCharsets.UTF_8));
        }
        if (!skipMinVersionCheck && version < (long)LEDGER_METADATA_OLDEST_SUPPORTED_VERSION) {
            throw new UnsupportedMetadataVersionException("Ledger metadata version '" + version + "' is no longer supported: " + new String(data, StandardCharsets.UTF_8));
        }
        if (version > (long)LEDGER_METADATA_CURRENT_LAYOUT_VERSION) {
            throw new UnsupportedMetadataVersionException("Metadata version '" + version + "' is higher than the highest supported version : " + new String(data, StandardCharsets.UTF_8));
        }
        if ((long)LogSegmentMetadataVersion.VERSION_V1_ORIGINAL.value == version) {
            return LogSegmentMetadata.parseDataV1(path, data, parts);
        }
        if ((long)LogSegmentMetadataVersion.VERSION_V2_LEDGER_SEQNO.value == version) {
            return LogSegmentMetadata.parseDataV2(path, data, parts);
        }
        if ((long)LogSegmentMetadataVersion.VERSION_V4_ENVELOPED_ENTRIES.value >= version && (long)LogSegmentMetadataVersion.VERSION_V3_MIN_ACTIVE_DLSN.value <= version) {
            return LogSegmentMetadata.parseDataVersionsWithMinActiveDLSN(path, data, parts);
        }
        assert (version >= (long)LogSegmentMetadataVersion.VERSION_V5_SEQUENCE_ID.value);
        return LogSegmentMetadata.parseDataVersionsWithSequenceId(path, data, parts);
    }

    public String getFinalisedData() {
        return this.getFinalisedData(this.version);
    }

    public String getFinalisedData(LogSegmentMetadataVersion version) {
        String finalisedData;
        long logSegmentSeqNo = this.getLogSegmentSequenceNumber();
        long lastEntryId = this.getLastEntryId();
        long lastSlotId = this.getLastSlotId();
        long minActiveEntryId = this.minActiveDLSN.getEntryId();
        long minActiveSlotId = this.minActiveDLSN.getSlotId();
        if (LogSegmentMetadataVersion.VERSION_V1_ORIGINAL == version) {
            if (this.inprogress) {
                finalisedData = String.format("%d;%d;%d", version.value, this.logSegmentId, this.firstTxId);
            } else {
                long versionAndCount = (long)version.value | (long)this.recordCount << 32;
                finalisedData = String.format("%d;%d;%d;%d;%d", versionAndCount, this.logSegmentId, this.firstTxId, this.lastTxId, this.completionTime);
            }
        } else {
            long versionStatusCount = version.value;
            versionStatusCount |= (this.status & 0xFFL) << 8;
            versionStatusCount |= ((long)this.regionId & 0xFL) << 28;
            if (!this.inprogress) {
                versionStatusCount |= (long)this.recordCount << 32;
            }
            if (LogSegmentMetadataVersion.VERSION_V2_LEDGER_SEQNO == version) {
                finalisedData = this.inprogress ? String.format("%d;%d;%d;%d", versionStatusCount, this.logSegmentId, this.firstTxId, logSegmentSeqNo) : String.format("%d;%d;%d;%d;%d;%d;%d;%d", versionStatusCount, this.logSegmentId, this.firstTxId, this.lastTxId, this.completionTime, logSegmentSeqNo, lastEntryId, lastSlotId);
            } else if (LogSegmentMetadataVersion.VERSION_V4_ENVELOPED_ENTRIES.value >= version.value && LogSegmentMetadataVersion.VERSION_V3_MIN_ACTIVE_DLSN.value <= version.value) {
                finalisedData = this.inprogress ? String.format("%d;%d;%d;%d;%d;%d", versionStatusCount, this.logSegmentId, this.firstTxId, logSegmentSeqNo, minActiveEntryId, minActiveSlotId) : String.format("%d;%d;%d;%d;%d;%d;%d;%d;%d;%d", versionStatusCount, this.logSegmentId, this.firstTxId, this.lastTxId, this.completionTime, logSegmentSeqNo, lastEntryId, lastSlotId, minActiveEntryId, minActiveSlotId);
            } else if (LogSegmentMetadataVersion.VERSION_V5_SEQUENCE_ID.value <= version.value && LEDGER_METADATA_CURRENT_LAYOUT_VERSION >= version.value) {
                finalisedData = this.inprogress ? String.format("%d;%d;%d;%d;%d;%d;%d", versionStatusCount, this.logSegmentId, this.firstTxId, logSegmentSeqNo, minActiveEntryId, minActiveSlotId, this.startSequenceId) : String.format("%d;%d;%d;%d;%d;%d;%d;%d;%d;%d;%d", versionStatusCount, this.logSegmentId, this.firstTxId, this.lastTxId, this.completionTime, logSegmentSeqNo, lastEntryId, lastSlotId, minActiveEntryId, minActiveSlotId, this.startSequenceId);
            } else {
                throw new IllegalStateException("Unsupported log segment ledger metadata version '" + (Object)((Object)version) + "'");
            }
        }
        return finalisedData;
    }

    String getSegmentName() {
        String[] parts = this.zkPath.split("/");
        if (parts.length <= 0) {
            throw new IllegalStateException("ZK Path is not valid");
        }
        return parts[parts.length - 1];
    }

    public void write(ZooKeeperClient zkc) throws IOException, KeeperException.NodeExistsException {
        String finalisedData = this.getFinalisedData(this.version);
        try {
            zkc.get().create(this.zkPath, finalisedData.getBytes(StandardCharsets.UTF_8), zkc.getDefaultACL(), CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nee) {
            throw nee;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new DLInterruptedException("Interrupted on creating ledger znode " + this.zkPath, (Throwable)ie);
        }
        catch (Exception e) {
            LOG.error("Error creating ledger znode {}", (Object)this.zkPath, (Object)e);
            throw new IOException("Error creating ledger znode " + this.zkPath);
        }
    }

    boolean checkEquivalence(ZooKeeperClient zkc, String path) {
        try {
            boolean retVal;
            LogSegmentMetadata other = FutureUtils.result(LogSegmentMetadata.read(zkc, path));
            if (LOG.isTraceEnabled()) {
                LOG.trace("Verifying {} against {}", (Object)this, (Object)other);
            }
            if (this.getLogSegmentSequenceNumber() != other.getLogSegmentSequenceNumber() || this.logSegmentId != other.logSegmentId || this.firstTxId != other.firstTxId) {
                retVal = false;
            } else if (this.inprogress) {
                retVal = other.inprogress;
            } else {
                boolean bl = retVal = !other.inprogress && this.lastTxId == other.lastTxId;
            }
            if (!retVal) {
                LOG.warn("Equivalence check failed between {} and {}", (Object)this, (Object)other);
            }
            return retVal;
        }
        catch (Exception e) {
            LOG.error("Could not check equivalence between:" + this + " and data in " + path, (Throwable)e);
            return false;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof LogSegmentMetadata)) {
            return false;
        }
        LogSegmentMetadata ol = (LogSegmentMetadata)o;
        return this.getLogSegmentSequenceNumber() == ol.getLogSegmentSequenceNumber() && this.logSegmentId == ol.logSegmentId && this.firstTxId == ol.firstTxId && this.lastTxId == ol.lastTxId && this.version == ol.version && this.completionTime == ol.completionTime && Objects.equal(this.lastDLSN, ol.lastDLSN) && Objects.equal(this.minActiveDLSN, ol.minActiveDLSN) && this.startSequenceId == ol.startSequenceId && this.status == ol.status;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + (int)this.logSegmentId;
        hash = hash * 31 + (int)this.firstTxId;
        hash = hash * 31 + (int)this.lastTxId;
        hash = hash * 31 + this.version.value;
        hash = hash * 31 + (int)this.completionTime;
        hash = hash * 31 + (int)this.getLogSegmentSequenceNumber();
        return hash;
    }

    public String toString() {
        return "[LogSegmentId:" + this.logSegmentId + ", firstTxId:" + this.firstTxId + ", lastTxId:" + this.lastTxId + ", version:" + (Object)((Object)this.version) + ", completionTime:" + this.completionTime + ", recordCount:" + this.recordCount + ", regionId:" + this.regionId + ", status:" + this.status + ", logSegmentSequenceNumber:" + this.getLogSegmentSequenceNumber() + ", lastEntryId:" + this.getLastEntryId() + ", lastSlotId:" + this.getLastSlotId() + ", inprogress:" + this.inprogress + ", minActiveDLSN:" + this.minActiveDLSN + ", startSequenceId:" + this.startSequenceId + "]";
    }

    public Mutator mutator() {
        return new Mutator(this);
    }

    public boolean supportsLogSegmentSequenceNo() {
        return LogSegmentMetadata.supportsLogSegmentSequenceNo(this.version.value);
    }

    public static boolean supportsLogSegmentSequenceNo(int version) {
        return version >= LogSegmentMetadataVersion.VERSION_V2_LEDGER_SEQNO.value;
    }

    public static boolean supportsEnvelopedEntries(int version) {
        return version >= LogSegmentMetadataVersion.VERSION_V4_ENVELOPED_ENTRIES.value;
    }

    public boolean supportsSequenceId() {
        return LogSegmentMetadata.supportsSequenceId(this.version.value);
    }

    public static boolean supportsSequenceId(int version) {
        return version >= LogSegmentMetadataVersion.VERSION_V5_SEQUENCE_ID.value;
    }

    public static class Mutator
    extends LogSegmentMetadataBuilder {
        Mutator(LogSegmentMetadata original) {
            super(original.getZkPath(), original.getVersion(), original.getLogSegmentId(), original.getFirstTxId());
            this.inprogress = original.isInProgress();
            this.logSegmentSequenceNo = original.getLogSegmentSequenceNumber();
            this.lastEntryId = original.getLastEntryId();
            this.lastSlotId = original.getLastSlotId();
            this.lastTxId = original.getLastTxId();
            this.completionTime = original.getCompletionTime();
            this.recordCount = original.getRecordCount();
            this.regionId = original.getRegionId();
            this.status = original.getStatus();
            this.minActiveEntryId = original.getMinActiveDLSN().getEntryId();
            this.minActiveSlotId = original.getMinActiveDLSN().getSlotId();
            this.startSequenceId = original.getStartSequenceId();
            this.envelopeEntries = original.getEnvelopeEntries();
        }

        @VisibleForTesting
        public Mutator setVersion(LogSegmentMetadataVersion version) {
            this.version = version;
            return this;
        }

        public Mutator setLogSegmentSequenceNumber(long seqNo) {
            this.logSegmentSequenceNo = seqNo;
            return this;
        }

        public Mutator setZkPath(String zkPath) {
            this.zkPath = zkPath;
            return this;
        }

        public Mutator setLastDLSN(DLSN dlsn) {
            this.logSegmentSequenceNo = dlsn.getLogSegmentSequenceNo();
            this.lastEntryId = dlsn.getEntryId();
            this.lastSlotId = dlsn.getSlotId();
            return this;
        }

        public Mutator setMinActiveDLSN(DLSN dlsn) {
            if (this.logSegmentSequenceNo != dlsn.getLogSegmentSequenceNo()) {
                throw new IllegalArgumentException("Updating minDLSN in an incorrect log segment");
            }
            this.minActiveEntryId = dlsn.getEntryId();
            this.minActiveSlotId = dlsn.getSlotId();
            return this;
        }

        public Mutator setTruncationStatus(TruncationStatus truncationStatus) {
            this.status &= 0xFFFFFFFFFFFFFFFCL;
            this.status |= (long)truncationStatus.value & 3L;
            return this;
        }

        @Override
        public Mutator setStartSequenceId(long startSequenceId) {
            this.startSequenceId = startSequenceId;
            return this;
        }
    }

    public static class LogSegmentMetadataBuilder {
        protected String zkPath;
        protected long logSegmentId;
        protected LogSegmentMetadataVersion version;
        protected long firstTxId;
        protected int regionId;
        protected long status;
        protected long lastTxId;
        protected long completionTime;
        protected int recordCount;
        protected long logSegmentSequenceNo;
        protected long lastEntryId;
        protected long lastSlotId;
        protected long minActiveEntryId;
        protected long minActiveSlotId;
        protected long startSequenceId;
        protected boolean inprogress;
        protected boolean envelopeEntries = false;

        LogSegmentMetadataBuilder(String zkPath, LogSegmentMetadataVersion version, long logSegmentId, long firstTxId) {
            this.initialize();
            this.zkPath = zkPath;
            this.version = version;
            this.logSegmentId = logSegmentId;
            this.firstTxId = firstTxId;
        }

        LogSegmentMetadataBuilder(String zkPath, int version, long logSegmentId, long firstTxId) {
            this(zkPath, LogSegmentMetadataVersion.values()[version], logSegmentId, firstTxId);
        }

        private void initialize() {
            this.regionId = 0;
            this.status = 0L;
            this.lastTxId = -999L;
            this.completionTime = 0L;
            this.recordCount = 0;
            this.lastEntryId = -1L;
            this.lastSlotId = -1L;
            this.minActiveEntryId = 0L;
            this.minActiveSlotId = 0L;
            this.startSequenceId = -1L;
            this.inprogress = true;
        }

        LogSegmentMetadataBuilder setRegionId(int regionId) {
            this.regionId = regionId;
            return this;
        }

        LogSegmentMetadataBuilder setStatus(long status) {
            this.status = status;
            return this;
        }

        public LogSegmentMetadataBuilder setLastTxId(long lastTxId) {
            this.lastTxId = lastTxId;
            return this;
        }

        public LogSegmentMetadataBuilder setCompletionTime(long completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public LogSegmentMetadataBuilder setRecordCount(int recordCount) {
            this.recordCount = recordCount;
            return this;
        }

        public LogSegmentMetadataBuilder setRecordCount(LogRecord record) {
            this.recordCount = record.getLastPositionWithinLogSegment();
            return this;
        }

        public LogSegmentMetadataBuilder setInprogress(boolean inprogress) {
            this.inprogress = inprogress;
            return this;
        }

        LogSegmentMetadataBuilder setLogSegmentSequenceNo(long logSegmentSequenceNo) {
            this.logSegmentSequenceNo = logSegmentSequenceNo;
            return this;
        }

        public LogSegmentMetadataBuilder setLastEntryId(long lastEntryId) {
            this.lastEntryId = lastEntryId;
            return this;
        }

        LogSegmentMetadataBuilder setLastSlotId(long lastSlotId) {
            this.lastSlotId = lastSlotId;
            return this;
        }

        LogSegmentMetadataBuilder setEnvelopeEntries(boolean envelopeEntries) {
            this.envelopeEntries = envelopeEntries;
            return this;
        }

        LogSegmentMetadataBuilder setMinActiveEntryId(long minActiveEntryId) {
            this.minActiveEntryId = minActiveEntryId;
            return this;
        }

        LogSegmentMetadataBuilder setMinActiveSlotId(long minActiveSlotId) {
            this.minActiveSlotId = minActiveSlotId;
            return this;
        }

        LogSegmentMetadataBuilder setStartSequenceId(long startSequenceId) {
            this.startSequenceId = startSequenceId;
            return this;
        }

        public LogSegmentMetadata build() {
            return new LogSegmentMetadata(this.zkPath, this.version, this.logSegmentId, this.firstTxId, this.lastTxId, this.completionTime, this.inprogress, this.recordCount, this.logSegmentSequenceNo, this.lastEntryId, this.lastSlotId, this.regionId, this.status, this.minActiveEntryId, this.minActiveSlotId, this.startSequenceId, this.envelopeEntries);
        }
    }

    public static enum TruncationStatus {
        UNKNOWN(-1),
        ACTIVE(0),
        PARTIALLY_TRUNCATED(1),
        TRUNCATED(2);

        private final int value;

        private TruncationStatus(int value) {
            this.value = value;
        }
    }

    public static enum LogSegmentMetadataVersion {
        VERSION_INVALID(0),
        VERSION_V1_ORIGINAL(1),
        VERSION_V2_LEDGER_SEQNO(2),
        VERSION_V3_MIN_ACTIVE_DLSN(3),
        VERSION_V4_ENVELOPED_ENTRIES(4),
        VERSION_V5_SEQUENCE_ID(5);

        public final int value;

        private LogSegmentMetadataVersion(int value) {
            this.value = value;
        }

        public static LogSegmentMetadataVersion of(int version) {
            switch (version) {
                case 5: {
                    return VERSION_V5_SEQUENCE_ID;
                }
                case 4: {
                    return VERSION_V4_ENVELOPED_ENTRIES;
                }
                case 3: {
                    return VERSION_V3_MIN_ACTIVE_DLSN;
                }
                case 2: {
                    return VERSION_V2_LEDGER_SEQNO;
                }
                case 1: {
                    return VERSION_V1_ORIGINAL;
                }
                case 0: {
                    return VERSION_INVALID;
                }
            }
            throw new IllegalArgumentException("unknown version " + version);
        }
    }
}

