/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.feature;

import dlshade.org.apache.bookkeeper.feature.CacheableFeatureProvider;
import dlshade.org.apache.bookkeeper.feature.Feature;
import dlshade.org.apache.bookkeeper.feature.FeatureProvider;
import dlshade.org.apache.bookkeeper.feature.SettableFeature;
import java.util.concurrent.ConcurrentMap;
import org.apache.distributedlog.common.config.ConcurrentBaseConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigurationFeatureProvider
extends CacheableFeatureProvider {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationFeatureProvider.class);
    private final ConcurrentBaseConfiguration featuresConf;
    private final ConcurrentMap<String, SettableFeature> features;

    static SettableFeature makeFeature(ConcurrentBaseConfiguration featuresConf, ConcurrentMap<String, SettableFeature> features, String featureName) {
        SettableFeature feature = (SettableFeature)features.get(featureName);
        if (null == feature) {
            int availability = featuresConf.getInt(featureName, 0);
            feature = new SettableFeature(featureName, availability);
            SettableFeature oldFeature = features.putIfAbsent(featureName, feature);
            if (null != oldFeature) {
                feature = oldFeature;
            } else {
                logger.info("Load feature {}={}", (Object)featureName, (Object)availability);
            }
        }
        return feature;
    }

    ConfigurationFeatureProvider(String rootScope, ConcurrentBaseConfiguration featuresConf, ConcurrentMap<String, SettableFeature> features) {
        super(rootScope);
        this.featuresConf = featuresConf;
        this.features = features;
    }

    protected Feature makeFeature(String featureName) {
        return ConfigurationFeatureProvider.makeFeature(this.featuresConf, this.features, featureName);
    }

    @Override
    protected FeatureProvider makeProvider(String fullScopeName) {
        return new ConfigurationFeatureProvider(fullScopeName, this.featuresConf, this.features);
    }
}

