/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.impl;

import dlshade.org.apache.bookkeeper.common.util.OrderedScheduler;
import dlshade.org.apache.zookeeper.AsyncCallback;
import dlshade.org.apache.zookeeper.KeeperException;
import dlshade.org.apache.zookeeper.WatchedEvent;
import dlshade.org.apache.zookeeper.Watcher;
import dlshade.org.apache.zookeeper.data.Stat;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.callback.NamespaceListener;
import org.apache.distributedlog.namespace.NamespaceWatcher;
import org.apache.distributedlog.util.DLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKNamespaceWatcher
extends NamespaceWatcher
implements Runnable,
Watcher,
AsyncCallback.Children2Callback {
    private static final Logger logger = LoggerFactory.getLogger(ZKNamespaceWatcher.class);
    private final DistributedLogConfiguration conf;
    private final URI uri;
    private final ZooKeeperClient zkc;
    private final OrderedScheduler scheduler;
    private final AtomicBoolean namespaceWatcherSet = new AtomicBoolean(false);

    public ZKNamespaceWatcher(DistributedLogConfiguration conf, URI uri, ZooKeeperClient zkc, OrderedScheduler scheduler) {
        this.conf = conf;
        this.uri = uri;
        this.zkc = zkc;
        this.scheduler = scheduler;
    }

    private void scheduleTask(Runnable r, long ms) {
        try {
            this.scheduler.schedule(r, ms, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException ree) {
            logger.error("Task {} scheduled in {} ms is rejected : ", new Object[]{r, ms, ree});
        }
    }

    @Override
    public void run() {
        try {
            this.doWatchNamespaceChanges();
        }
        catch (Exception e) {
            logger.error("Encountered unknown exception on watching namespace {} ", (Object)this.uri, (Object)e);
        }
    }

    @Override
    public void watchNamespaceChanges() {
        if (!this.namespaceWatcherSet.compareAndSet(false, true)) {
            return;
        }
        this.doWatchNamespaceChanges();
    }

    private void doWatchNamespaceChanges() {
        try {
            this.zkc.get().getChildren(this.uri.getPath(), (Watcher)this, (AsyncCallback.Children2Callback)this, null);
        }
        catch (ZooKeeperClient.ZooKeeperConnectionException e) {
            this.scheduleTask(this, this.conf.getZKSessionTimeoutMilliseconds());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("Interrupted on watching namespace changes for {} : ", (Object)this.uri, (Object)e);
            this.scheduleTask(this, this.conf.getZKSessionTimeoutMilliseconds());
        }
    }

    @Override
    public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
        if (KeeperException.Code.OK.intValue() == rc) {
            logger.info("Received updated logs under {} : {}", (Object)this.uri, children);
            ArrayList<String> result = new ArrayList<String>(children.size());
            for (String s : children) {
                if (DLUtils.isReservedStreamName(s)) continue;
                result.add(s);
            }
            for (NamespaceListener listener : this.listeners) {
                listener.onStreamsChanged(result.iterator());
            }
        } else {
            this.scheduleTask(this, this.conf.getZKSessionTimeoutMilliseconds());
        }
    }

    @Override
    public void process(WatchedEvent event) {
        if (event.getType() == Watcher.Event.EventType.None) {
            if (event.getState() == Watcher.Event.KeeperState.Expired) {
                this.scheduleTask(this, this.conf.getZKSessionTimeoutMilliseconds());
            }
            return;
        }
        if (event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
            this.doWatchNamespaceChanges();
        }
    }
}

