/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.impl.metadata;

import dlshade.com.google.common.annotations.VisibleForTesting;
import dlshade.com.google.common.base.Objects;
import dlshade.org.apache.thrift.TException;
import dlshade.org.apache.thrift.protocol.TJSONProtocol;
import dlshade.org.apache.thrift.transport.TMemoryBuffer;
import dlshade.org.apache.thrift.transport.TMemoryInputTransport;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.impl.BKNamespaceDriver;
import org.apache.distributedlog.impl.metadata.ZkMetadataResolver;
import org.apache.distributedlog.metadata.DLConfig;
import org.apache.distributedlog.thrift.BKDLConfigFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BKDLConfig
implements DLConfig {
    private static final Logger LOG = LoggerFactory.getLogger(BKDLConfig.class);
    private static final int BUFFER_SIZE = 4096;
    private static final ConcurrentMap<URI, DLConfig> cachedDLConfigs = new ConcurrentHashMap<URI, DLConfig>();
    private String bkZkServersForWriter;
    private String bkZkServersForReader;
    private String bkLedgersPath;
    private boolean sanityCheckTxnID = true;
    private boolean encodeRegionID = false;
    private String dlZkServersForWriter;
    private String dlZkServersForReader;
    private String aclRootPath;
    private Long firstLogSegmentSeqNo;
    private boolean isFederatedNamespace = false;

    public static void propagateConfiguration(BKDLConfig bkdlConfig, DistributedLogConfiguration dlConf) {
        dlConf.setEncodeRegionIDInLogSegmentMetadata(bkdlConfig.getEncodeRegionID());
        dlConf.setFirstLogSegmentSequenceNumber(bkdlConfig.getFirstLogSegmentSeqNo());
        if (bkdlConfig.isFederatedNamespace()) {
            dlConf.setCreateStreamIfNotExists(false);
            LOG.info("Disabled createIfNotExists for federated namespace.");
        }
        LOG.info("Propagate BKDLConfig to DLConfig : encodeRegionID = {}, firstLogSegmentSequenceNumber = {}, createStreamIfNotExists = {}, isFederated = {}.", new Object[]{dlConf.getEncodeRegionIDInLogSegmentMetadata(), dlConf.getFirstLogSegmentSequenceNumber(), dlConf.getCreateStreamIfNotExists(), bkdlConfig.isFederatedNamespace()});
    }

    public static BKDLConfig resolveDLConfig(ZooKeeperClient zkc, URI uri) throws IOException {
        DLConfig oldDLConfig;
        DLConfig dlConfig = (DLConfig)cachedDLConfigs.get(uri);
        if (dlConfig == null && null != (oldDLConfig = cachedDLConfigs.putIfAbsent(uri, dlConfig = new ZkMetadataResolver(zkc).resolve(uri).getDLConfig()))) {
            dlConfig = oldDLConfig;
        }
        assert (dlConfig instanceof BKDLConfig);
        return (BKDLConfig)dlConfig;
    }

    @VisibleForTesting
    public static void clearCachedDLConfigs() {
        cachedDLConfigs.clear();
    }

    public BKDLConfig(URI uri) {
        this(BKNamespaceDriver.getZKServersFromDLUri(uri), BKNamespaceDriver.getZKServersFromDLUri(uri), null, null, null);
    }

    @VisibleForTesting
    public BKDLConfig(String zkServers, String ledgersPath) {
        this(zkServers, zkServers, zkServers, zkServers, ledgersPath);
    }

    public BKDLConfig(String dlZkServersForWriter, String dlZkServersForReader, String bkZkServersForWriter, String bkZkServersForReader, String bkLedgersPath) {
        this.dlZkServersForWriter = dlZkServersForWriter;
        this.dlZkServersForReader = dlZkServersForReader;
        this.bkZkServersForWriter = bkZkServersForWriter;
        this.bkZkServersForReader = bkZkServersForReader;
        this.bkLedgersPath = bkLedgersPath;
    }

    public String getBkZkServersForWriter() {
        return this.bkZkServersForWriter;
    }

    public String getBkZkServersForReader() {
        return this.bkZkServersForReader;
    }

    public String getDlZkServersForWriter() {
        return this.dlZkServersForWriter;
    }

    public String getDlZkServersForReader() {
        return this.dlZkServersForReader;
    }

    public String getBkLedgersPath() {
        return this.bkLedgersPath;
    }

    public BKDLConfig setSanityCheckTxnID(boolean enabled) {
        this.sanityCheckTxnID = enabled;
        return this;
    }

    public boolean getSanityCheckTxnID() {
        return this.sanityCheckTxnID;
    }

    public BKDLConfig setEncodeRegionID(boolean enabled) {
        this.encodeRegionID = enabled;
        return this;
    }

    public boolean getEncodeRegionID() {
        return this.encodeRegionID;
    }

    public BKDLConfig setACLRootPath(String aclRootPath) {
        this.aclRootPath = aclRootPath;
        return this;
    }

    public String getACLRootPath() {
        return this.aclRootPath;
    }

    public BKDLConfig setFirstLogSegmentSeqNo(long firstLogSegmentSeqNo) {
        this.firstLogSegmentSeqNo = firstLogSegmentSeqNo;
        return this;
    }

    public Long getFirstLogSegmentSeqNo() {
        if (null == this.firstLogSegmentSeqNo) {
            return 1L;
        }
        return this.firstLogSegmentSeqNo;
    }

    public BKDLConfig setFederatedNamespace(boolean isFederatedNamespace) {
        this.isFederatedNamespace = isFederatedNamespace;
        return this;
    }

    public boolean isFederatedNamespace() {
        return this.isFederatedNamespace;
    }

    public int hashCode() {
        return Objects.hashCode(this.bkZkServersForWriter, this.bkZkServersForReader, this.dlZkServersForWriter, this.dlZkServersForReader, this.bkLedgersPath);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BKDLConfig)) {
            return false;
        }
        BKDLConfig another = (BKDLConfig)o;
        return Objects.equal(this.bkZkServersForWriter, another.bkZkServersForWriter) && Objects.equal(this.bkZkServersForReader, another.bkZkServersForReader) && Objects.equal(this.dlZkServersForWriter, another.dlZkServersForWriter) && Objects.equal(this.dlZkServersForReader, another.dlZkServersForReader) && Objects.equal(this.bkLedgersPath, another.bkLedgersPath) && this.sanityCheckTxnID == another.sanityCheckTxnID && this.encodeRegionID == another.encodeRegionID && Objects.equal(this.aclRootPath, another.aclRootPath) && Objects.equal(this.firstLogSegmentSeqNo, another.firstLogSegmentSeqNo) && Objects.equal(this.isFederatedNamespace, another.isFederatedNamespace);
    }

    public String toString() {
        return this.serialize();
    }

    @Override
    public String serialize() {
        BKDLConfigFormat configFormat = new BKDLConfigFormat();
        if (null != this.bkZkServersForWriter) {
            configFormat.setBkZkServers(this.bkZkServersForWriter);
        }
        if (null != this.bkZkServersForReader) {
            configFormat.setBkZkServersForReader(this.bkZkServersForReader);
        }
        if (null != this.dlZkServersForWriter) {
            configFormat.setDlZkServersForWriter(this.dlZkServersForWriter);
        }
        if (null != this.dlZkServersForReader) {
            configFormat.setDlZkServersForReader(this.dlZkServersForReader);
        }
        if (null != this.bkLedgersPath) {
            configFormat.setBkLedgersPath(this.bkLedgersPath);
        }
        configFormat.setSanityCheckTxnID(this.sanityCheckTxnID);
        configFormat.setEncodeRegionID(this.encodeRegionID);
        if (null != this.aclRootPath) {
            configFormat.setAclRootPath(this.aclRootPath);
        }
        if (null != this.firstLogSegmentSeqNo) {
            configFormat.setFirstLogSegmentSeqNo(this.firstLogSegmentSeqNo);
        }
        if (this.isFederatedNamespace) {
            configFormat.setFederatedNamespace(true);
        }
        return this.serialize(configFormat);
    }

    String serialize(BKDLConfigFormat configFormat) {
        try {
            TMemoryBuffer transport = new TMemoryBuffer(4096);
            TJSONProtocol protocol = new TJSONProtocol(transport);
            configFormat.write(protocol);
            transport.flush();
            return transport.toString(StandardCharsets.UTF_8);
        }
        catch (TException e) {
            throw new RuntimeException("Failed to serialize BKDLConfig : ", e);
        }
    }

    @Override
    public void deserialize(byte[] data) throws IOException {
        BKDLConfigFormat configFormat = new BKDLConfigFormat();
        try {
            TMemoryInputTransport transport = new TMemoryInputTransport(data);
            TJSONProtocol protocol = new TJSONProtocol(transport);
            configFormat.read(protocol);
        }
        catch (TException e) {
            throw new IOException("Failed to deserialize data '" + new String(data, StandardCharsets.UTF_8) + "' : ", e);
        }
        if (configFormat.isSetBkZkServers()) {
            this.bkZkServersForWriter = configFormat.getBkZkServers();
        }
        this.bkZkServersForReader = configFormat.isSetBkZkServersForReader() ? configFormat.getBkZkServersForReader() : this.bkZkServersForWriter;
        if (configFormat.isSetBkLedgersPath()) {
            this.bkLedgersPath = configFormat.getBkLedgersPath();
        }
        if (configFormat.isSetDlZkServersForWriter()) {
            this.dlZkServersForWriter = configFormat.getDlZkServersForWriter();
        }
        this.dlZkServersForReader = configFormat.isSetDlZkServersForReader() ? configFormat.getDlZkServersForReader() : this.dlZkServersForWriter;
        this.sanityCheckTxnID = !configFormat.isSetSanityCheckTxnID() || configFormat.isSanityCheckTxnID();
        boolean bl = this.encodeRegionID = configFormat.isSetEncodeRegionID() && configFormat.isEncodeRegionID();
        if (configFormat.isSetAclRootPath()) {
            this.aclRootPath = configFormat.getAclRootPath();
        }
        if (configFormat.isSetFirstLogSegmentSeqNo()) {
            this.firstLogSegmentSeqNo = configFormat.getFirstLogSegmentSeqNo();
        }
        boolean bl2 = this.isFederatedNamespace = configFormat.isSetFederatedNamespace() && configFormat.isFederatedNamespace();
        if (null == this.bkZkServersForWriter || null == this.bkZkServersForReader || null == this.bkLedgersPath || null == this.dlZkServersForWriter || null == this.dlZkServersForReader) {
            throw new IOException("Missing zk/bk settings in BKDL Config : " + new String(data, StandardCharsets.UTF_8));
        }
    }
}

