/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.limiter;

import dlshade.com.google.common.base.Stopwatch;
import dlshade.com.google.common.collect.ImmutableList;
import dlshade.org.apache.bookkeeper.stats.NullStatsLogger;
import dlshade.org.apache.bookkeeper.stats.OpStatsLogger;
import dlshade.org.apache.bookkeeper.stats.StatsLogger;
import java.util.concurrent.TimeUnit;
import org.apache.distributedlog.exceptions.OverCapacityException;
import org.apache.distributedlog.limiter.RequestLimiter;

public class ChainedRequestLimiter<Request>
implements RequestLimiter<Request> {
    private final ImmutableList<RequestLimiter<Request>> limiters;
    private final OpStatsLogger applyTime;

    private ChainedRequestLimiter(ImmutableList<RequestLimiter<Request>> limiters, StatsLogger statsLogger) {
        this.limiters = limiters;
        this.applyTime = statsLogger.getOpStatsLogger("apply");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Request request) throws OverCapacityException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            for (RequestLimiter requestLimiter : this.limiters) {
                requestLimiter.apply(request);
            }
        }
        finally {
            this.applyTime.registerSuccessfulEvent(stopwatch.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
        }
    }

    public static class Builder<Request> {
        private final ImmutableList.Builder<RequestLimiter<Request>> limitersBuilder;
        private StatsLogger statsLogger = NullStatsLogger.INSTANCE;

        public Builder() {
            this.limitersBuilder = new ImmutableList.Builder();
        }

        public Builder<Request> addLimiter(RequestLimiter<Request> limiter) {
            this.limitersBuilder.add((Object)limiter);
            return this;
        }

        public Builder<Request> statsLogger(StatsLogger statsLogger) {
            this.statsLogger = statsLogger;
            return this;
        }

        public ChainedRequestLimiter<Request> build() {
            return new ChainedRequestLimiter((ImmutableList)this.limitersBuilder.build(), this.statsLogger);
        }
    }
}

