/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.limiter;

import dlshade.com.google.common.base.Preconditions;
import org.apache.distributedlog.limiter.RateLimiter;

public class GuavaRateLimiter
implements RateLimiter {
    dlshade.com.google.common.util.concurrent.RateLimiter limiter;

    public static RateLimiter of(int limit) {
        if (limit == 0) {
            return RateLimiter.REJECT;
        }
        if (limit < 0) {
            return RateLimiter.ACCEPT;
        }
        return new GuavaRateLimiter(limit);
    }

    public GuavaRateLimiter(int limit) {
        double effectiveLimit = limit;
        if (limit < 0) {
            effectiveLimit = Double.POSITIVE_INFINITY;
        }
        this.limiter = dlshade.com.google.common.util.concurrent.RateLimiter.create(effectiveLimit);
    }

    @Override
    public boolean acquire(int permits) {
        Preconditions.checkState(permits >= 0);
        if (permits > 0) {
            return this.limiter.tryAcquire(permits);
        }
        return true;
    }
}

