/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.zk;

import dlshade.org.apache.bookkeeper.stats.Gauge;
import dlshade.org.apache.bookkeeper.stats.StatsLogger;
import dlshade.org.apache.zookeeper.WatchedEvent;
import dlshade.org.apache.zookeeper.Watcher;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import org.apache.distributedlog.ZooKeeperClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKWatcherManager
implements Watcher {
    private static final Logger logger = LoggerFactory.getLogger(ZKWatcherManager.class);
    private final String name;
    private final ZooKeeperClient zkc;
    private final StatsLogger statsLogger;
    private final Gauge<Number> totalWatchesGauge;
    private static final String totalWatchesGauageLabel = "total_watches";
    private final Gauge<Number> numChildWatchesGauge;
    private static final String numChildWatchesGauageLabel = "num_child_watches";
    protected final ConcurrentMap<String, Set<Watcher>> childWatches;
    protected final LongAdder allWatchesGauge;

    public static Builder newBuilder() {
        return new Builder();
    }

    private ZKWatcherManager(String name, ZooKeeperClient zkc, StatsLogger statsLogger) {
        this.name = name;
        this.zkc = zkc;
        this.statsLogger = statsLogger;
        this.childWatches = new ConcurrentHashMap<String, Set<Watcher>>();
        this.allWatchesGauge = new LongAdder();
        this.totalWatchesGauge = new Gauge<Number>(){

            @Override
            public Number getDefaultValue() {
                return 0;
            }

            @Override
            public Number getSample() {
                return ZKWatcherManager.this.allWatchesGauge.sum();
            }
        };
        this.statsLogger.registerGauge(totalWatchesGauageLabel, this.totalWatchesGauge);
        this.numChildWatchesGauge = new Gauge<Number>(){

            @Override
            public Number getDefaultValue() {
                return 0;
            }

            @Override
            public Number getSample() {
                return ZKWatcherManager.this.childWatches.size();
            }
        };
        this.statsLogger.registerGauge(numChildWatchesGauageLabel, this.numChildWatchesGauge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Watcher registerChildWatcher(String path, Watcher watcher) {
        HashSet<Watcher> watchers = (HashSet<Watcher>)this.childWatches.get(path);
        if (null == watchers) {
            HashSet newWatchers = new HashSet();
            Set oldWatchers = this.childWatches.putIfAbsent(path, newWatchers);
            watchers = null == oldWatchers ? newWatchers : oldWatchers;
        }
        HashSet<Watcher> hashSet = watchers;
        synchronized (hashSet) {
            if (this.childWatches.get(path) == watchers) {
                if (watchers.add(watcher)) {
                    this.allWatchesGauge.increment();
                }
            } else {
                logger.warn("Watcher set for path {} has been changed while registering child watcher {}.", (Object)path, (Object)watcher);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterChildWatcher(String path, Watcher watcher, boolean removeFromServer) {
        Set watchers = (Set)this.childWatches.get(path);
        if (null == watchers) {
            logger.warn("No watchers found on path {} while unregistering child watcher {}.", (Object)path, (Object)watcher);
            return;
        }
        Set set = watchers;
        synchronized (set) {
            if (watchers.remove(watcher)) {
                this.allWatchesGauge.decrement();
            } else {
                logger.warn("Remove a non-registered child watcher {} from path {}", (Object)watcher, (Object)path);
            }
            if (watchers.isEmpty()) {
                this.childWatches.remove(path, watchers);
            }
        }
    }

    public void unregisterGauges() {
        this.statsLogger.unregisterGauge(totalWatchesGauageLabel, this.totalWatchesGauge);
        this.statsLogger.unregisterGauge(numChildWatchesGauageLabel, this.numChildWatchesGauge);
    }

    @Override
    public void process(WatchedEvent event) {
        switch (event.getType()) {
            case None: {
                this.handleKeeperStateEvent(event);
                break;
            }
            case NodeChildrenChanged: {
                this.handleChildWatchEvent(event);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleKeeperStateEvent(WatchedEvent event) {
        HashSet savedAllWatches = new HashSet((int)this.allWatchesGauge.sum());
        Iterator<Object> iterator = this.childWatches.values().iterator();
        while (iterator.hasNext()) {
            Set watcherSet;
            Set set = watcherSet = (Set)iterator.next();
            synchronized (set) {
                savedAllWatches.addAll(watcherSet);
            }
        }
        for (Watcher watcher : savedAllWatches) {
            watcher.process(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChildWatchEvent(WatchedEvent event) {
        HashSet watchersToFire;
        String path = event.getPath();
        if (null == path) {
            logger.warn("Received zookeeper watch event with null path : {}", (Object)event);
            return;
        }
        Set watchers = (Set)this.childWatches.get(path);
        if (null == watchers) {
            return;
        }
        Set set = watchers;
        synchronized (set) {
            watchersToFire = new HashSet(watchers.size());
            watchersToFire.addAll(watchers);
        }
        for (Watcher watcher : watchersToFire) {
            watcher.process(event);
        }
    }

    public static class Builder {
        private String pName;
        private StatsLogger pStatsLogger;
        private ZooKeeperClient pZkc;

        public Builder name(String name) {
            this.pName = name;
            return this;
        }

        public Builder zkc(ZooKeeperClient zkc) {
            this.pZkc = zkc;
            return this;
        }

        public Builder statsLogger(StatsLogger statsLogger) {
            this.pStatsLogger = statsLogger;
            return this;
        }

        public ZKWatcherManager build() {
            return new ZKWatcherManager(this.pName, this.pZkc, this.pStatsLogger);
        }
    }
}

