/*
 * Decompiled with CFR 0.152.
 */
package dlshade.com.scurrilous.circe.crc;

import dlshade.com.scurrilous.circe.Hash;
import dlshade.com.scurrilous.circe.HashSupport;
import dlshade.com.scurrilous.circe.StatelessHash;
import dlshade.com.scurrilous.circe.crc.JavaCrc32;
import dlshade.com.scurrilous.circe.crc.NormalByteCrc;
import dlshade.com.scurrilous.circe.crc.NormalIntCrc;
import dlshade.com.scurrilous.circe.crc.NormalLongCrc;
import dlshade.com.scurrilous.circe.crc.ReflectedIntCrc;
import dlshade.com.scurrilous.circe.crc.ReflectedLongCrc;
import dlshade.com.scurrilous.circe.impl.AbstractHashProvider;
import dlshade.com.scurrilous.circe.params.CrcParameters;
import java.util.EnumSet;

public final class StandardCrcProvider
extends AbstractHashProvider<CrcParameters> {
    public StandardCrcProvider() {
        super(CrcParameters.class);
    }

    @Override
    protected EnumSet<HashSupport> querySupportTyped(CrcParameters params) {
        EnumSet<HashSupport> result = EnumSet.of(HashSupport.STATEFUL, HashSupport.INCREMENTAL, HashSupport.STATELESS_INCREMENTAL, HashSupport.LONG_SIZED);
        if (params.bitWidth() <= 32) {
            result.add(HashSupport.INT_SIZED);
        }
        if (params.equals(CrcParameters.CRC32)) {
            result.add(HashSupport.NATIVE);
        }
        return result;
    }

    @Override
    protected Hash get(CrcParameters params, EnumSet<HashSupport> required) {
        if (!required.contains((Object)HashSupport.STATELESS_INCREMENTAL) && params.equals(CrcParameters.CRC32)) {
            return new JavaCrc32();
        }
        if (required.contains((Object)HashSupport.NATIVE)) {
            throw new UnsupportedOperationException();
        }
        return this.getCacheable(params, required);
    }

    @Override
    protected StatelessHash createCacheable(CrcParameters params, EnumSet<HashSupport> required) {
        int bitWidth = params.bitWidth();
        if (bitWidth > 32 || required.contains((Object)HashSupport.LONG_SIZED) && bitWidth >= 8) {
            if (required.contains((Object)HashSupport.INT_SIZED)) {
                throw new UnsupportedOperationException();
            }
            if (params.reflected()) {
                return new ReflectedLongCrc(params.algorithm(), bitWidth, params.polynomial(), params.initial(), params.xorOut());
            }
            return new NormalLongCrc(params.algorithm(), bitWidth, params.polynomial(), params.initial(), params.xorOut());
        }
        if (params.reflected()) {
            return new ReflectedIntCrc(params.algorithm(), bitWidth, (int)params.polynomial(), (int)params.initial(), (int)params.xorOut());
        }
        if (bitWidth > 8) {
            return new NormalIntCrc(params.algorithm(), bitWidth, (int)params.polynomial(), (int)params.initial(), (int)params.xorOut());
        }
        return new NormalByteCrc(params.algorithm(), bitWidth, (int)params.polynomial(), (int)params.initial(), (int)params.xorOut());
    }
}

