/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.bookie;

public class GarbageCollectionStatus {
    private boolean forceCompacting;
    private boolean majorCompacting;
    private boolean minorCompacting;
    private long lastMajorCompactionTime;
    private long lastMinorCompactionTime;
    private long majorCompactionCounter;
    private long minorCompactionCounter;

    GarbageCollectionStatus(boolean forceCompacting, boolean majorCompacting, boolean minorCompacting, long lastMajorCompactionTime, long lastMinorCompactionTime, long majorCompactionCounter, long minorCompactionCounter) {
        this.forceCompacting = forceCompacting;
        this.majorCompacting = majorCompacting;
        this.minorCompacting = minorCompacting;
        this.lastMajorCompactionTime = lastMajorCompactionTime;
        this.lastMinorCompactionTime = lastMinorCompactionTime;
        this.majorCompactionCounter = majorCompactionCounter;
        this.minorCompactionCounter = minorCompactionCounter;
    }

    public static GarbageCollectionStatusBuilder builder() {
        return new GarbageCollectionStatusBuilder();
    }

    public void setForceCompacting(boolean forceCompacting) {
        this.forceCompacting = forceCompacting;
    }

    public void setMajorCompacting(boolean majorCompacting) {
        this.majorCompacting = majorCompacting;
    }

    public void setMinorCompacting(boolean minorCompacting) {
        this.minorCompacting = minorCompacting;
    }

    public void setLastMajorCompactionTime(long lastMajorCompactionTime) {
        this.lastMajorCompactionTime = lastMajorCompactionTime;
    }

    public void setLastMinorCompactionTime(long lastMinorCompactionTime) {
        this.lastMinorCompactionTime = lastMinorCompactionTime;
    }

    public void setMajorCompactionCounter(long majorCompactionCounter) {
        this.majorCompactionCounter = majorCompactionCounter;
    }

    public void setMinorCompactionCounter(long minorCompactionCounter) {
        this.minorCompactionCounter = minorCompactionCounter;
    }

    public boolean isForceCompacting() {
        return this.forceCompacting;
    }

    public boolean isMajorCompacting() {
        return this.majorCompacting;
    }

    public boolean isMinorCompacting() {
        return this.minorCompacting;
    }

    public long getLastMajorCompactionTime() {
        return this.lastMajorCompactionTime;
    }

    public long getLastMinorCompactionTime() {
        return this.lastMinorCompactionTime;
    }

    public long getMajorCompactionCounter() {
        return this.majorCompactionCounter;
    }

    public long getMinorCompactionCounter() {
        return this.minorCompactionCounter;
    }

    public static class GarbageCollectionStatusBuilder {
        private boolean forceCompacting;
        private boolean majorCompacting;
        private boolean minorCompacting;
        private long lastMajorCompactionTime;
        private long lastMinorCompactionTime;
        private long majorCompactionCounter;
        private long minorCompactionCounter;

        GarbageCollectionStatusBuilder() {
        }

        public GarbageCollectionStatusBuilder forceCompacting(boolean forceCompacting) {
            this.forceCompacting = forceCompacting;
            return this;
        }

        public GarbageCollectionStatusBuilder majorCompacting(boolean majorCompacting) {
            this.majorCompacting = majorCompacting;
            return this;
        }

        public GarbageCollectionStatusBuilder minorCompacting(boolean minorCompacting) {
            this.minorCompacting = minorCompacting;
            return this;
        }

        public GarbageCollectionStatusBuilder lastMajorCompactionTime(long lastMajorCompactionTime) {
            this.lastMajorCompactionTime = lastMajorCompactionTime;
            return this;
        }

        public GarbageCollectionStatusBuilder lastMinorCompactionTime(long lastMinorCompactionTime) {
            this.lastMinorCompactionTime = lastMinorCompactionTime;
            return this;
        }

        public GarbageCollectionStatusBuilder majorCompactionCounter(long majorCompactionCounter) {
            this.majorCompactionCounter = majorCompactionCounter;
            return this;
        }

        public GarbageCollectionStatusBuilder minorCompactionCounter(long minorCompactionCounter) {
            this.minorCompactionCounter = minorCompactionCounter;
            return this;
        }

        public GarbageCollectionStatus build() {
            return new GarbageCollectionStatus(this.forceCompacting, this.majorCompacting, this.minorCompacting, this.lastMajorCompactionTime, this.lastMinorCompactionTime, this.majorCompactionCounter, this.minorCompactionCounter);
        }

        public String toString() {
            return "GarbageCollectionStatus.GarbageCollectionStatusBuilder(forceCompacting=" + this.forceCompacting + ", majorCompacting=" + this.majorCompacting + ", minorCompacting=" + this.minorCompacting + ", lastMajorCompactionTime=" + this.lastMajorCompactionTime + ", lastMinorCompactionTime=" + this.lastMinorCompactionTime + ", majorCompactionCounter=" + this.majorCompactionCounter + ", minorCompactionCounter=" + this.minorCompactionCounter + ")";
        }
    }
}

