/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.bookie;

import dlshade.com.google.common.annotations.VisibleForTesting;
import dlshade.org.apache.bookkeeper.bookie.AbstractLogCompactor;
import dlshade.org.apache.bookkeeper.bookie.CompactableLedgerStorage;
import dlshade.org.apache.bookkeeper.bookie.EntryLogCompactor;
import dlshade.org.apache.bookkeeper.bookie.EntryLogMetadata;
import dlshade.org.apache.bookkeeper.bookie.EntryLogger;
import dlshade.org.apache.bookkeeper.bookie.GarbageCollectionStatus;
import dlshade.org.apache.bookkeeper.bookie.GarbageCollector;
import dlshade.org.apache.bookkeeper.bookie.ScanAndCompareGarbageCollector;
import dlshade.org.apache.bookkeeper.bookie.TransactionalEntryLogCompactor;
import dlshade.org.apache.bookkeeper.bookie.stats.GarbageCollectorStats;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.meta.LedgerManager;
import dlshade.org.apache.bookkeeper.stats.StatsLogger;
import dlshade.org.apache.bookkeeper.util.MathUtils;
import dlshade.org.apache.bookkeeper.util.SafeRunnable;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GarbageCollectorThread
extends SafeRunnable {
    private static final Logger LOG = LoggerFactory.getLogger(GarbageCollectorThread.class);
    private static final int SECOND = 1000;
    private Map<Long, EntryLogMetadata> entryLogMetaMap = new ConcurrentHashMap<Long, EntryLogMetadata>();
    private final ScheduledExecutorService gcExecutor;
    Future<?> scheduledFuture = null;
    final long gcWaitTime;
    boolean isForceMinorCompactionAllow = false;
    boolean enableMinorCompaction = false;
    final double minorCompactionThreshold;
    final long minorCompactionInterval;
    final long minorCompactionMaxTimeMillis;
    long lastMinorCompactionTime;
    boolean isForceMajorCompactionAllow = false;
    boolean enableMajorCompaction = false;
    final double majorCompactionThreshold;
    final long majorCompactionInterval;
    long majorCompactionMaxTimeMillis;
    long lastMajorCompactionTime;
    final boolean isForceGCAllowWhenNoSpace;
    final EntryLogger entryLogger;
    final AbstractLogCompactor compactor;
    private final GarbageCollectorStats gcStats;
    private volatile long totalEntryLogSize;
    private volatile int numActiveEntryLogs;
    final CompactableLedgerStorage ledgerStorage;
    final AtomicBoolean compacting = new AtomicBoolean(false);
    final AtomicBoolean minorCompacting = new AtomicBoolean(false);
    final AtomicBoolean majorCompacting = new AtomicBoolean(false);
    volatile boolean running = true;
    long scannedLogId = 0L;
    final AtomicBoolean forceGarbageCollection = new AtomicBoolean(false);
    final AtomicBoolean suspendMajorCompaction = new AtomicBoolean(false);
    final AtomicBoolean suspendMinorCompaction = new AtomicBoolean(false);
    final ScanAndCompareGarbageCollector garbageCollector;
    final GarbageCollector.GarbageCleaner garbageCleaner;
    final ServerConfiguration conf;

    public GarbageCollectorThread(ServerConfiguration conf, LedgerManager ledgerManager, CompactableLedgerStorage ledgerStorage, StatsLogger statsLogger) throws IOException {
        this(conf, ledgerManager, ledgerStorage, statsLogger, Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("GarbageCollectorThread")));
    }

    public GarbageCollectorThread(ServerConfiguration conf, LedgerManager ledgerManager, CompactableLedgerStorage ledgerStorage, StatsLogger statsLogger, ScheduledExecutorService gcExecutor) throws IOException {
        this.gcExecutor = gcExecutor;
        this.conf = conf;
        this.entryLogger = ledgerStorage.getEntryLogger();
        this.ledgerStorage = ledgerStorage;
        this.gcWaitTime = conf.getGcWaitTime();
        this.numActiveEntryLogs = 0;
        this.totalEntryLogSize = 0L;
        this.garbageCollector = new ScanAndCompareGarbageCollector(ledgerManager, ledgerStorage, conf, statsLogger);
        this.gcStats = new GarbageCollectorStats(statsLogger, () -> this.numActiveEntryLogs, () -> this.totalEntryLogSize, () -> this.garbageCollector.getNumActiveLedgers());
        this.garbageCleaner = ledgerId -> {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("delete ledger : " + ledgerId);
                }
                this.gcStats.getDeletedLedgerCounter().inc();
                ledgerStorage.deleteLedger(ledgerId);
            }
            catch (IOException e) {
                LOG.error("Exception when deleting the ledger index file on the Bookie: ", (Throwable)e);
            }
        };
        this.minorCompactionThreshold = conf.getMinorCompactionThreshold();
        this.minorCompactionInterval = conf.getMinorCompactionInterval() * 1000L;
        this.majorCompactionThreshold = conf.getMajorCompactionThreshold();
        this.majorCompactionInterval = conf.getMajorCompactionInterval() * 1000L;
        this.isForceGCAllowWhenNoSpace = conf.getIsForceGCAllowWhenNoSpace();
        this.majorCompactionMaxTimeMillis = conf.getMajorCompactionMaxTimeMillis();
        this.minorCompactionMaxTimeMillis = conf.getMinorCompactionMaxTimeMillis();
        boolean isForceAllowCompaction = conf.isForceAllowCompaction();
        AbstractLogCompactor.LogRemovalListener remover = new AbstractLogCompactor.LogRemovalListener(){

            @Override
            public void removeEntryLog(long logToRemove) {
                GarbageCollectorThread.this.removeEntryLog(logToRemove);
            }
        };
        this.compactor = conf.getUseTransactionalCompaction() ? new TransactionalEntryLogCompactor(conf, this.entryLogger, ledgerStorage, remover) : new EntryLogCompactor(conf, this.entryLogger, ledgerStorage, remover);
        if (this.minorCompactionInterval > 0L && this.minorCompactionThreshold > 0.0) {
            if (this.minorCompactionThreshold > 1.0) {
                throw new IOException("Invalid minor compaction threshold " + this.minorCompactionThreshold);
            }
            if (this.minorCompactionInterval < this.gcWaitTime) {
                throw new IOException("Too short minor compaction interval : " + this.minorCompactionInterval);
            }
            this.enableMinorCompaction = true;
        }
        if (isForceAllowCompaction) {
            if (this.minorCompactionThreshold > 0.0 && this.minorCompactionThreshold < 1.0) {
                this.isForceMinorCompactionAllow = true;
            }
            if (this.majorCompactionThreshold > 0.0 && this.majorCompactionThreshold < 1.0) {
                this.isForceMajorCompactionAllow = true;
            }
        }
        if (this.majorCompactionInterval > 0L && this.majorCompactionThreshold > 0.0) {
            if (this.majorCompactionThreshold > 1.0) {
                throw new IOException("Invalid major compaction threshold " + this.majorCompactionThreshold);
            }
            if (this.majorCompactionInterval < this.gcWaitTime) {
                throw new IOException("Too short major compaction interval : " + this.majorCompactionInterval);
            }
            this.enableMajorCompaction = true;
        }
        if (this.enableMinorCompaction && this.enableMajorCompaction && (this.minorCompactionInterval >= this.majorCompactionInterval || this.minorCompactionThreshold >= this.majorCompactionThreshold)) {
            throw new IOException("Invalid minor/major compaction settings : minor (" + this.minorCompactionThreshold + ", " + this.minorCompactionInterval + "), major (" + this.majorCompactionThreshold + ", " + this.majorCompactionInterval + ")");
        }
        LOG.info("Minor Compaction : enabled=" + this.enableMinorCompaction + ", threshold=" + this.minorCompactionThreshold + ", interval=" + this.minorCompactionInterval);
        LOG.info("Major Compaction : enabled=" + this.enableMajorCompaction + ", threshold=" + this.majorCompactionThreshold + ", interval=" + this.majorCompactionInterval);
        this.lastMinorCompactionTime = this.lastMajorCompactionTime = System.currentTimeMillis();
    }

    public void enableForceGC() {
        if (this.forceGarbageCollection.compareAndSet(false, true)) {
            LOG.info("Forced garbage collection triggered by thread: {}", (Object)Thread.currentThread().getName());
            this.triggerGC(true, this.suspendMajorCompaction.get(), this.suspendMinorCompaction.get());
        }
    }

    public void disableForceGC() {
        if (this.forceGarbageCollection.compareAndSet(true, false)) {
            LOG.info("{} disabled force garbage collection since bookie has enough space now.", (Object)Thread.currentThread().getName());
        }
    }

    Future<?> triggerGC(boolean force, boolean suspendMajor, boolean suspendMinor) {
        return this.gcExecutor.submit(() -> this.runWithFlags(force, suspendMajor, suspendMinor));
    }

    Future<?> triggerGC() {
        boolean force = this.forceGarbageCollection.get();
        boolean suspendMajor = this.suspendMajorCompaction.get();
        boolean suspendMinor = this.suspendMinorCompaction.get();
        return this.gcExecutor.submit(() -> this.runWithFlags(force, suspendMajor, suspendMinor));
    }

    public boolean isInForceGC() {
        return this.forceGarbageCollection.get();
    }

    public void suspendMajorGC() {
        if (this.suspendMajorCompaction.compareAndSet(false, true)) {
            LOG.info("Suspend Major Compaction triggered by thread: {}", (Object)Thread.currentThread().getName());
        }
    }

    public void resumeMajorGC() {
        if (this.suspendMajorCompaction.compareAndSet(true, false)) {
            LOG.info("{} Major Compaction back to normal since bookie has enough space now.", (Object)Thread.currentThread().getName());
        }
    }

    public void suspendMinorGC() {
        if (this.suspendMinorCompaction.compareAndSet(false, true)) {
            LOG.info("Suspend Minor Compaction triggered by thread: {}", (Object)Thread.currentThread().getName());
        }
    }

    public void resumeMinorGC() {
        if (this.suspendMinorCompaction.compareAndSet(true, false)) {
            LOG.info("{} Minor Compaction back to normal since bookie has enough space now.", (Object)Thread.currentThread().getName());
        }
    }

    public void start() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
        this.scheduledFuture = this.gcExecutor.scheduleAtFixedRate(this, this.gcWaitTime, this.gcWaitTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public void safeRun() {
        boolean force = this.forceGarbageCollection.get();
        boolean suspendMajor = this.suspendMajorCompaction.get();
        boolean suspendMinor = this.suspendMinorCompaction.get();
        this.runWithFlags(force, suspendMajor, suspendMinor);
        if (force) {
            this.forceGarbageCollection.set(false);
        }
    }

    public void runWithFlags(boolean force, boolean suspendMajor, boolean suspendMinor) {
        long threadStart = MathUtils.nowInNano();
        if (force) {
            LOG.info("Garbage collector thread forced to perform GC before expiry of wait time.");
        }
        this.compactor.cleanUpAndRecover();
        this.entryLogMetaMap = this.extractMetaFromEntryLogs(this.entryLogMetaMap);
        this.doGcLedgers();
        this.doGcEntryLogs();
        if (suspendMajor) {
            LOG.info("Disk almost full, suspend major compaction to slow down filling disk.");
        }
        if (suspendMinor) {
            LOG.info("Disk full, suspend minor compaction to slow down filling disk.");
        }
        long curTime = System.currentTimeMillis();
        if ((this.isForceMajorCompactionAllow && force || this.enableMajorCompaction && (force || curTime - this.lastMajorCompactionTime > this.majorCompactionInterval)) && !suspendMajor) {
            LOG.info("Enter major compaction, suspendMajor {}", (Object)suspendMajor);
            this.majorCompacting.set(true);
            this.doCompactEntryLogs(this.majorCompactionThreshold, this.majorCompactionMaxTimeMillis);
            this.lastMinorCompactionTime = this.lastMajorCompactionTime = System.currentTimeMillis();
            this.gcStats.getMajorCompactionCounter().inc();
            this.majorCompacting.set(false);
        } else if ((this.isForceMinorCompactionAllow && force || this.enableMinorCompaction && (force || curTime - this.lastMinorCompactionTime > this.minorCompactionInterval)) && !suspendMinor) {
            LOG.info("Enter minor compaction, suspendMinor {}", (Object)suspendMinor);
            this.minorCompacting.set(true);
            this.doCompactEntryLogs(this.minorCompactionThreshold, this.minorCompactionMaxTimeMillis);
            this.lastMinorCompactionTime = System.currentTimeMillis();
            this.gcStats.getMinorCompactionCounter().inc();
            this.minorCompacting.set(false);
        }
        if (force && this.forceGarbageCollection.compareAndSet(true, false)) {
            LOG.info("{} Set forceGarbageCollection to false after force GC to make it forceGC-able again.", (Object)Thread.currentThread().getName());
        }
        this.gcStats.getGcThreadRuntime().registerSuccessfulEvent(MathUtils.nowInNano() - threadStart, TimeUnit.NANOSECONDS);
    }

    private void doGcLedgers() {
        this.garbageCollector.gc(this.garbageCleaner);
    }

    private void doGcEntryLogs() {
        AtomicLong totalEntryLogSizeAcc = new AtomicLong(0L);
        this.entryLogMetaMap.forEach((entryLogId, meta) -> {
            this.removeIfLedgerNotExists((EntryLogMetadata)meta);
            if (meta.isEmpty()) {
                LOG.info("Deleting entryLogId " + entryLogId + " as it has no active ledgers!");
                this.removeEntryLog((long)entryLogId);
                this.gcStats.getReclaimedSpaceViaDeletes().add(meta.getTotalSize());
            }
            totalEntryLogSizeAcc.getAndAdd(meta.getRemainingSize());
        });
        this.totalEntryLogSize = totalEntryLogSizeAcc.get();
        this.numActiveEntryLogs = this.entryLogMetaMap.keySet().size();
    }

    private void removeIfLedgerNotExists(EntryLogMetadata meta) {
        meta.removeLedgerIf(entryLogLedger -> {
            try {
                return !this.ledgerStorage.ledgerExists(entryLogLedger);
            }
            catch (IOException e) {
                LOG.error("Error reading from ledger storage", (Throwable)e);
                return false;
            }
        });
    }

    @VisibleForTesting
    void doCompactEntryLogs(double threshold, long maxTimeMillis) {
        long start;
        LOG.info("Do compaction to compact those files lower than {}", (Object)threshold);
        ArrayList<EntryLogMetadata> logsToCompact = new ArrayList<EntryLogMetadata>();
        logsToCompact.addAll(this.entryLogMetaMap.values());
        logsToCompact.sort(Comparator.comparing(EntryLogMetadata::getUsage));
        int numBuckets = 10;
        int[] entryLogUsageBuckets = new int[10];
        int[] compactedBuckets = new int[10];
        long end = start = System.currentTimeMillis();
        long timeDiff = 0L;
        for (EntryLogMetadata meta : logsToCompact) {
            int bucketIndex;
            int n = bucketIndex = this.calculateUsageIndex(10, meta.getUsage());
            entryLogUsageBuckets[n] = entryLogUsageBuckets[n] + 1;
            if (timeDiff < maxTimeMillis) {
                end = System.currentTimeMillis();
                timeDiff = end - start;
            }
            if (meta.getUsage() >= threshold || maxTimeMillis > 0L && timeDiff > maxTimeMillis || !this.running) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Compacting entry log {} with usage {} below threshold {}", new Object[]{meta.getEntryLogId(), meta.getUsage(), threshold});
            }
            long priorRemainingSize = meta.getRemainingSize();
            this.compactEntryLog(meta);
            this.gcStats.getReclaimedSpaceViaCompaction().add(meta.getTotalSize() - priorRemainingSize);
            int n2 = bucketIndex;
            compactedBuckets[n2] = compactedBuckets[n2] + 1;
        }
        if (LOG.isDebugEnabled()) {
            if (!this.running) {
                LOG.debug("Compaction exited due to gc not running");
            }
            if (timeDiff > maxTimeMillis) {
                LOG.debug("Compaction ran for {}ms but was limited by {}ms", (Object)timeDiff, (Object)maxTimeMillis);
            }
        }
        LOG.info("Compaction: entry log usage buckets[10% 20% 30% 40% 50% 60% 70% 80% 90% 100%] = {}, compacted {}", (Object)entryLogUsageBuckets, (Object)compactedBuckets);
    }

    int calculateUsageIndex(int numBuckets, double usage) {
        return Math.min(numBuckets - 1, (int)Math.floor(usage * (double)numBuckets));
    }

    public void shutdown() throws InterruptedException {
        this.running = false;
        LOG.info("Shutting down GarbageCollectorThread");
        while (!this.compacting.compareAndSet(false, true)) {
            Thread.sleep(100L);
        }
        this.gcExecutor.shutdownNow();
    }

    protected void removeEntryLog(long entryLogId) {
        if (this.entryLogger.removeEntryLog(entryLogId)) {
            LOG.info("Removing entry log metadata for {}", (Object)entryLogId);
            this.entryLogMetaMap.remove(entryLogId);
        }
    }

    protected void compactEntryLog(EntryLogMetadata entryLogMeta) {
        if (!this.compacting.compareAndSet(false, true)) {
            return;
        }
        try {
            this.compactor.compact(entryLogMeta);
        }
        catch (Exception e) {
            LOG.error("Failed to compact entry log {} due to unexpected error", (Object)entryLogMeta.getEntryLogId(), (Object)e);
        }
        finally {
            this.compacting.set(false);
        }
    }

    protected Map<Long, EntryLogMetadata> extractMetaFromEntryLogs(Map<Long, EntryLogMetadata> entryLogMetaMap) {
        long curLogId = this.entryLogger.getLeastUnflushedLogId();
        boolean hasExceptionWhenScan = false;
        for (long entryLogId = this.scannedLogId; entryLogId < curLogId; ++entryLogId) {
            if (entryLogMetaMap.containsKey(entryLogId) || !this.entryLogger.logExists(entryLogId)) continue;
            LOG.info("Extracting entry log meta from entryLogId: {}", (Object)entryLogId);
            try {
                EntryLogMetadata entryLogMeta = this.entryLogger.getEntryLogMetadata(entryLogId);
                this.removeIfLedgerNotExists(entryLogMeta);
                if (entryLogMeta.isEmpty()) {
                    this.entryLogger.removeEntryLog(entryLogId);
                } else {
                    entryLogMetaMap.put(entryLogId, entryLogMeta);
                }
            }
            catch (IOException e) {
                hasExceptionWhenScan = true;
                LOG.warn("Premature exception when processing " + entryLogId + " recovery will take care of the problem", (Throwable)e);
            }
            if (hasExceptionWhenScan) continue;
            ++this.scannedLogId;
        }
        return entryLogMetaMap;
    }

    CompactableLedgerStorage getLedgerStorage() {
        return this.ledgerStorage;
    }

    public GarbageCollectionStatus getGarbageCollectionStatus() {
        return GarbageCollectionStatus.builder().forceCompacting(this.forceGarbageCollection.get()).majorCompacting(this.majorCompacting.get()).minorCompacting(this.minorCompacting.get()).lastMajorCompactionTime(this.lastMajorCompactionTime).lastMinorCompactionTime(this.lastMinorCompactionTime).majorCompactionCounter(this.gcStats.getMajorCompactionCounter().get()).minorCompactionCounter(this.gcStats.getMinorCompactionCounter().get()).build();
    }

    public boolean isForceGCAllowWhenNoSpace() {
        return this.isForceGCAllowWhenNoSpace;
    }
}

