/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.bookie;

import dlshade.com.google.common.annotations.VisibleForTesting;
import dlshade.com.google.common.cache.Cache;
import dlshade.com.google.common.cache.CacheBuilder;
import dlshade.com.google.common.cache.RemovalListener;
import dlshade.com.google.common.cache.RemovalNotification;
import dlshade.com.google.common.util.concurrent.UncheckedExecutionException;
import dlshade.org.apache.bookkeeper.bookie.Bookie;
import dlshade.org.apache.bookkeeper.bookie.BookieException;
import dlshade.org.apache.bookkeeper.bookie.FileInfo;
import dlshade.org.apache.bookkeeper.bookie.FileInfoBackingCache;
import dlshade.org.apache.bookkeeper.bookie.LastAddConfirmedUpdateNotification;
import dlshade.org.apache.bookkeeper.bookie.LedgerCache;
import dlshade.org.apache.bookkeeper.bookie.LedgerDirsManager;
import dlshade.org.apache.bookkeeper.bookie.LedgerEntryPage;
import dlshade.org.apache.bookkeeper.bookie.ShortReadException;
import dlshade.org.apache.bookkeeper.bookie.stats.IndexPersistenceMgrStats;
import dlshade.org.apache.bookkeeper.common.util.Watcher;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.stats.StatsLogger;
import dlshade.org.apache.bookkeeper.util.SnapshotMap;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexPersistenceMgr {
    private static final Logger LOG = LoggerFactory.getLogger(IndexPersistenceMgr.class);
    private static final String IDX = ".idx";
    static final String RLOC = ".rloc";
    final Cache<Long, FileInfoBackingCache.CachedFileInfo> writeFileInfoCache;
    final Cache<Long, FileInfoBackingCache.CachedFileInfo> readFileInfoCache;
    final FileInfoBackingCache fileInfoBackingCache;
    final int openFileLimit;
    final int pageSize;
    final int entriesPerPage;
    final SnapshotMap<Long, Boolean> activeLedgers;
    final LedgerDirsManager ledgerDirsManager;
    private final IndexPersistenceMgrStats persistenceMgrStats;

    @VisibleForTesting
    public static final String getLedgerName(long ledgerId) {
        int parent = (int)(ledgerId & 0xFFL);
        int grandParent = (int)((ledgerId & 0xFF00L) >> 8);
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toHexString(grandParent));
        sb.append('/');
        sb.append(Integer.toHexString(parent));
        sb.append('/');
        sb.append(Long.toHexString(ledgerId));
        sb.append(IDX);
        return sb.toString();
    }

    public IndexPersistenceMgr(int pageSize, int entriesPerPage, ServerConfiguration conf, SnapshotMap<Long, Boolean> activeLedgers, LedgerDirsManager ledgerDirsManager, StatsLogger statsLogger) throws IOException {
        this.openFileLimit = conf.getOpenFileLimit();
        this.activeLedgers = activeLedgers;
        this.ledgerDirsManager = ledgerDirsManager;
        this.pageSize = pageSize;
        this.entriesPerPage = entriesPerPage;
        LOG.info("openFileLimit = {}", (Object)this.openFileLimit);
        this.getActiveLedgers();
        int concurrencyLevel = Math.max(1, Math.max(conf.getNumAddWorkerThreads(), conf.getNumReadWorkerThreads()));
        this.fileInfoBackingCache = new FileInfoBackingCache(this::createFileInfoBackingFile, conf.getFileInfoFormatVersionToWrite());
        RemovalListener<Long, FileInfoBackingCache.CachedFileInfo> fileInfoEvictionListener = this::handleLedgerEviction;
        this.writeFileInfoCache = IndexPersistenceMgr.buildCache(concurrencyLevel, conf.getFileInfoCacheInitialCapacity(), this.openFileLimit, conf.getFileInfoMaxIdleTime(), fileInfoEvictionListener);
        this.readFileInfoCache = IndexPersistenceMgr.buildCache(concurrencyLevel, 2 * conf.getFileInfoCacheInitialCapacity(), 2 * this.openFileLimit, conf.getFileInfoMaxIdleTime(), fileInfoEvictionListener);
        this.persistenceMgrStats = new IndexPersistenceMgrStats(statsLogger, () -> this.writeFileInfoCache.size(), () -> this.readFileInfoCache.size());
    }

    private static Cache<Long, FileInfoBackingCache.CachedFileInfo> buildCache(int concurrencyLevel, int initialCapacity, int maximumSize, long expireAfterAccessSeconds, RemovalListener<Long, FileInfoBackingCache.CachedFileInfo> removalListener) {
        CacheBuilder<Long, FileInfoBackingCache.CachedFileInfo> builder = CacheBuilder.newBuilder().concurrencyLevel(concurrencyLevel).initialCapacity(initialCapacity).maximumSize(maximumSize).removalListener(removalListener);
        if (expireAfterAccessSeconds > 0L) {
            builder.expireAfterAccess(expireAfterAccessSeconds, TimeUnit.SECONDS);
        }
        return builder.build();
    }

    private File createFileInfoBackingFile(long ledger, boolean createIfMissing) throws IOException {
        File lf = this.findIndexFile(ledger);
        if (null == lf) {
            if (!createIfMissing) {
                throw new Bookie.NoLedgerException(ledger);
            }
            lf = this.getNewLedgerIndexFile(ledger, null);
        }
        return lf;
    }

    private void handleLedgerEviction(RemovalNotification<Long, FileInfoBackingCache.CachedFileInfo> notification) {
        FileInfoBackingCache.CachedFileInfo fileInfo = (FileInfoBackingCache.CachedFileInfo)notification.getValue();
        if (null == fileInfo || null == notification.getKey()) {
            return;
        }
        if (notification.wasEvicted()) {
            this.persistenceMgrStats.getEvictedLedgersCounter().inc();
        }
        fileInfo.release();
    }

    FileInfoBackingCache.CachedFileInfo getFileInfo(Long ledger, byte[] masterKey) throws IOException {
        try {
            FileInfoBackingCache.CachedFileInfo fi;
            this.persistenceMgrStats.getPendingGetFileInfoCounter().inc();
            Callable<FileInfoBackingCache.CachedFileInfo> loader = () -> {
                FileInfoBackingCache.CachedFileInfo fileInfo = this.fileInfoBackingCache.loadFileInfo(ledger, masterKey);
                this.activeLedgers.put(ledger, true);
                return fileInfo;
            };
            do {
                if ((fi = null != masterKey ? this.writeFileInfoCache.get(ledger, loader) : this.readFileInfoCache.get(ledger, loader)).tryRetain()) continue;
                boolean inWriteMap = this.writeFileInfoCache.asMap().remove(ledger, fi);
                boolean inReadMap = this.readFileInfoCache.asMap().remove(ledger, fi);
                if (inWriteMap || inReadMap) {
                    LOG.error("Dead fileinfo({}) forced out of cache (write:{}, read:{}). It must have been double-released somewhere.", new Object[]{fi, inWriteMap, inReadMap});
                }
                fi = null;
            } while (fi == null);
            FileInfoBackingCache.CachedFileInfo cachedFileInfo = fi;
            return cachedFileInfo;
        }
        catch (UncheckedExecutionException | ExecutionException ee) {
            if (ee.getCause() instanceof IOException) {
                throw (IOException)ee.getCause();
            }
            throw new LedgerCache.NoIndexForLedgerException("Failed to load file info for ledger " + ledger, ee);
        }
        finally {
            this.persistenceMgrStats.getPendingGetFileInfoCounter().dec();
        }
    }

    private File getNewLedgerIndexFile(Long ledger, File excludedDir) throws LedgerDirsManager.NoWritableLedgerDirException {
        File dir = this.ledgerDirsManager.pickRandomWritableDirForNewIndexFile(excludedDir);
        String ledgerName = IndexPersistenceMgr.getLedgerName(ledger);
        return new File(dir, ledgerName);
    }

    private void getActiveLedgers() throws IOException {
        for (File ledgerDirectory : this.ledgerDirsManager.getAllLedgerDirs()) {
            File[] grandParents = ledgerDirectory.listFiles();
            if (grandParents == null) continue;
            for (File grandParent : grandParents) {
                File[] parents;
                if (!grandParent.isDirectory() || (parents = grandParent.listFiles()) == null) continue;
                for (File parent : parents) {
                    File[] indexFiles;
                    if (!parent.isDirectory() || (indexFiles = parent.listFiles()) == null) continue;
                    for (File index : indexFiles) {
                        if (!index.isFile() || !index.getName().endsWith(IDX) && !index.getName().endsWith(RLOC)) continue;
                        String ledgerIdInHex = index.getName().replace(RLOC, "").replace(IDX, "");
                        long ledgerId = Long.parseLong(ledgerIdInHex, 16);
                        if (index.getName().endsWith(RLOC)) {
                            if (this.findIndexFile(ledgerId) != null) {
                                if (index.delete()) continue;
                                LOG.warn("Deleting the rloc file " + index + " failed");
                                continue;
                            }
                            File dest = new File(index.getParentFile(), ledgerIdInHex + IDX);
                            if (!index.renameTo(dest)) {
                                throw new IOException("Renaming rloc file " + index + " to index file has failed");
                            }
                        }
                        this.activeLedgers.put(ledgerId, true);
                    }
                }
            }
        }
    }

    void removeLedger(Long ledgerId) throws IOException {
        FileInfoBackingCache.CachedFileInfo fi = null;
        try {
            fi = this.getFileInfo(ledgerId, null);
            fi.close(false);
            fi.delete();
        }
        finally {
            if (fi != null) {
                fi.release();
                this.activeLedgers.remove(ledgerId);
                this.writeFileInfoCache.invalidate(ledgerId);
                this.readFileInfoCache.invalidate(ledgerId);
            }
        }
    }

    private File findIndexFile(long ledgerId) throws IOException {
        String ledgerName = IndexPersistenceMgr.getLedgerName(ledgerId);
        for (File d : this.ledgerDirsManager.getAllLedgerDirs()) {
            File lf = new File(d, ledgerName);
            if (!lf.exists()) continue;
            return lf;
        }
        return null;
    }

    boolean ledgerExists(long ledgerId) throws IOException {
        return this.activeLedgers.containsKey(ledgerId);
    }

    void close() throws IOException {
        this.fileInfoBackingCache.closeAllWithoutFlushing();
        this.writeFileInfoCache.invalidateAll();
        this.readFileInfoCache.invalidateAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Long getLastAddConfirmed(long ledgerId) throws IOException {
        FileInfoBackingCache.CachedFileInfo fi = null;
        try {
            fi = this.getFileInfo(ledgerId, null);
            Long l = fi.getLastAddConfirmed();
            return l;
        }
        finally {
            if (null != fi) {
                fi.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForLastAddConfirmedUpdate(long ledgerId, long previousLAC, Watcher<LastAddConfirmedUpdateNotification> watcher) throws IOException {
        FileInfoBackingCache.CachedFileInfo fi = null;
        try {
            fi = this.getFileInfo(ledgerId, null);
            boolean bl = fi.waitForLastAddConfirmedUpdate(previousLAC, watcher);
            return bl;
        }
        finally {
            if (null != fi) {
                fi.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelWaitForLastAddConfirmedUpdate(long ledgerId, Watcher<LastAddConfirmedUpdateNotification> watcher) throws IOException {
        FileInfoBackingCache.CachedFileInfo fi = null;
        try {
            fi = this.getFileInfo(ledgerId, null);
            fi.cancelWaitForLastAddConfirmedUpdate(watcher);
        }
        finally {
            if (null != fi) {
                fi.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long updateLastAddConfirmed(long ledgerId, long lac) throws IOException {
        FileInfoBackingCache.CachedFileInfo fi = null;
        try {
            fi = this.getFileInfo(ledgerId, null);
            long l = fi.setLastAddConfirmed(lac);
            return l;
        }
        finally {
            if (null != fi) {
                fi.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] readMasterKey(long ledgerId) throws IOException, BookieException {
        FileInfoBackingCache.CachedFileInfo fi = null;
        try {
            fi = this.getFileInfo(ledgerId, null);
            byte[] byArray = fi.getMasterKey();
            return byArray;
        }
        finally {
            if (null != fi) {
                fi.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMasterKey(long ledgerId, byte[] masterKey) throws IOException {
        FileInfoBackingCache.CachedFileInfo fi = null;
        try {
            fi = this.getFileInfo(ledgerId, masterKey);
        }
        finally {
            if (null != fi) {
                fi.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setFenced(long ledgerId) throws IOException {
        FileInfoBackingCache.CachedFileInfo fi = null;
        try {
            fi = this.getFileInfo(ledgerId, null);
            boolean bl = fi.setFenced();
            return bl;
        }
        finally {
            if (null != fi) {
                fi.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isFenced(long ledgerId) throws IOException {
        FileInfoBackingCache.CachedFileInfo fi = null;
        try {
            fi = this.getFileInfo(ledgerId, null);
            boolean bl = fi.isFenced();
            return bl;
        }
        finally {
            if (null != fi) {
                fi.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setExplicitLac(long ledgerId, ByteBuf lac) throws IOException {
        FileInfoBackingCache.CachedFileInfo fi = null;
        try {
            fi = this.getFileInfo(ledgerId, null);
            fi.setExplicitLac(lac);
        }
        finally {
            if (null != fi) {
                fi.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuf getExplicitLac(long ledgerId) {
        FileInfoBackingCache.CachedFileInfo fi = null;
        try {
            fi = this.getFileInfo(ledgerId, null);
            ByteBuf byteBuf = fi.getExplicitLac();
            return byteBuf;
        }
        catch (IOException e) {
            LOG.error("Exception during getLastAddConfirmed", (Throwable)e);
            ByteBuf byteBuf = null;
            return byteBuf;
        }
        finally {
            if (null != fi) {
                fi.release();
            }
        }
    }

    int getOpenFileLimit() {
        return this.openFileLimit;
    }

    private void relocateIndexFileAndFlushHeader(long ledger, FileInfo fi) throws IOException {
        block3: {
            File currentDir = this.getLedgerDirForLedger(fi);
            if (this.ledgerDirsManager.isDirFull(currentDir)) {
                try {
                    this.moveLedgerIndexFile(ledger, fi);
                }
                catch (LedgerDirsManager.NoWritableLedgerDirException nwe) {
                    if (this.ledgerDirsManager.isDirWritableForNewIndexFile(currentDir)) break block3;
                    throw nwe;
                }
            }
        }
        fi.flushHeader();
    }

    private File getLedgerDirForLedger(FileInfo fi) {
        return fi.getLf().getParentFile().getParentFile().getParentFile();
    }

    private void moveLedgerIndexFile(Long l, FileInfo fi) throws LedgerDirsManager.NoWritableLedgerDirException, IOException {
        File newLedgerIndexFile = this.getNewLedgerIndexFile(l, this.getLedgerDirForLedger(fi));
        try {
            fi.moveToNewLocation(newLedgerIndexFile, fi.getSizeSinceLastWrite());
        }
        catch (FileInfo.FileInfoDeletedException fileInfoDeleted) {
            throw new Bookie.NoLedgerException(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushLedgerHeader(long ledger) throws IOException {
        FileInfoBackingCache.CachedFileInfo fi = null;
        try {
            fi = this.getFileInfo(ledger, null);
            this.relocateIndexFileAndFlushHeader(ledger, fi);
        }
        catch (Bookie.NoLedgerException nle) {
            LOG.info("No ledger {} found when flushing header.", (Object)ledger);
            return;
        }
        finally {
            if (null != fi) {
                fi.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushLedgerEntries(long l, List<LedgerEntryPage> entries) throws IOException {
        FileInfoBackingCache.CachedFileInfo fi = null;
        try {
            int i;
            Collections.sort(entries, new Comparator<LedgerEntryPage>(){

                @Override
                public int compare(LedgerEntryPage o1, LedgerEntryPage o2) {
                    return (int)(o1.getFirstEntry() - o2.getFirstEntry());
                }
            });
            int[] versions = new int[entries.size()];
            try {
                fi = this.getFileInfo(l, null);
            }
            catch (Bookie.NoLedgerException nle) {
                LOG.info("No ledger {} found when flushing entries.", (Object)l);
                if (fi != null) {
                    fi.release();
                }
                return;
            }
            this.relocateIndexFileAndFlushHeader(l, fi);
            int start = 0;
            long lastOffset = -1L;
            for (i = 0; i < entries.size(); ++i) {
                versions[i] = entries.get(i).getVersion();
                if (lastOffset != -1L && entries.get(i).getFirstEntry() - lastOffset != (long)this.entriesPerPage) {
                    int count = i - start;
                    if (count == 0) {
                        LOG.warn("Count cannot possibly be zero!");
                    }
                    this.writeBuffers(l, entries, fi, start, count);
                    start = i;
                }
                lastOffset = entries.get(i).getFirstEntry();
            }
            if (entries.size() - start == 0 && entries.size() != 0) {
                LOG.warn("Nothing to write, but there were entries!");
            }
            this.writeBuffers(l, entries, fi, start, entries.size() - start);
            for (i = 0; i < entries.size(); ++i) {
                LedgerEntryPage lep = entries.get(i);
                lep.setClean(versions[i]);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Flushed ledger {} with {} pages.", (Object)l, (Object)entries.size());
            }
        }
        finally {
            if (fi != null) {
                fi.release();
            }
        }
    }

    private void writeBuffers(Long ledger, List<LedgerEntryPage> entries, FileInfo fi, int start, int count) throws IOException, Bookie.NoLedgerException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Writing {} buffers of {}", (Object)count, (Object)Long.toHexString(ledger));
        }
        if (count == 0) {
            return;
        }
        ByteBuffer[] buffs = new ByteBuffer[count];
        for (int j = 0; j < count; ++j) {
            buffs[j] = entries.get(start + j).getPageToWrite();
            if (entries.get(start + j).getLedger() == ledger.longValue()) continue;
            throw new IOException("Writing to " + ledger + " but page belongs to " + entries.get(start + j).getLedger());
        }
        long totalWritten = 0L;
        while (buffs[buffs.length - 1].remaining() > 0) {
            long rc = 0L;
            try {
                rc = fi.write(buffs, entries.get(start + 0).getFirstEntryPosition());
            }
            catch (FileInfo.FileInfoDeletedException e) {
                throw new Bookie.NoLedgerException(ledger);
            }
            if (rc <= 0L) {
                throw new IOException("Short write to ledger " + ledger + " rc = " + rc);
            }
            totalWritten += rc;
        }
        if (totalWritten != (long)count * (long)this.pageSize) {
            throw new IOException("Short write to ledger " + ledger + " wrote " + totalWritten + " expected " + count * this.pageSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updatePage(LedgerEntryPage lep) throws IOException {
        if (!lep.isClean()) {
            throw new IOException("Trying to update a dirty page");
        }
        FileInfoBackingCache.CachedFileInfo fi = null;
        try {
            fi = this.getFileInfo(lep.getLedger(), null);
            long pos = lep.getFirstEntryPosition();
            if (pos >= fi.size()) {
                lep.zeroPage();
                boolean bl = true;
                return bl;
            }
            lep.readPage(fi);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fi != null) {
                fi.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getPersistEntryBeyondInMem(long ledgerId, long lastEntryInMem) throws IOException {
        long lastEntry;
        block10: {
            FileInfoBackingCache.CachedFileInfo fi = null;
            lastEntry = lastEntryInMem;
            try {
                fi = this.getFileInfo(ledgerId, null);
                long size = fi.size();
                if (0L != size % (long)LedgerEntryPage.getIndexEntrySize()) {
                    LOG.warn("Index file of ledger {} is not aligned with index entry size.", (Object)ledgerId);
                    size -= size % (long)LedgerEntryPage.getIndexEntrySize();
                }
                if (size <= lastEntry * (long)LedgerEntryPage.getIndexEntrySize()) break block10;
                ByteBuffer bb = ByteBuffer.allocate(this.pageSize);
                long position = size - (long)this.pageSize;
                if (position < 0L) {
                    position = 0L;
                }
                try {
                    fi.read(bb, position, false);
                }
                catch (ShortReadException sre) {
                    throw new ShortReadException("Short read on ledger " + ledgerId + " : ", sre);
                }
                bb.flip();
                long startingEntryId = position / (long)LedgerEntryPage.getIndexEntrySize();
                for (int i = this.entriesPerPage - 1; i >= 0; --i) {
                    if (bb.getLong(i * LedgerEntryPage.getIndexEntrySize()) == 0L) continue;
                    if (lastEntry < startingEntryId + (long)i) {
                        lastEntry = startingEntryId + (long)i;
                    }
                    break;
                }
            }
            finally {
                if (fi != null) {
                    fi.release();
                }
            }
        }
        return lastEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LedgerCache.LedgerIndexMetadata readLedgerIndexMetadata(long ledgerId) throws IOException {
        FileInfoBackingCache.CachedFileInfo fi = null;
        try {
            fi = this.getFileInfo(ledgerId, null);
            LedgerCache.LedgerIndexMetadata ledgerIndexMetadata = new LedgerCache.LedgerIndexMetadata(fi.getMasterKey(), fi.size(), fi.isFenced());
            return ledgerIndexMetadata;
        }
        finally {
            if (fi != null) {
                fi.release();
            }
        }
    }
}

