/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.bookie;

import dlshade.com.google.common.util.concurrent.RateLimiter;
import dlshade.org.apache.bookkeeper.bookie.BookieException;
import dlshade.org.apache.bookkeeper.bookie.CheckpointSource;
import dlshade.org.apache.bookkeeper.bookie.Checkpointer;
import dlshade.org.apache.bookkeeper.bookie.GarbageCollectionStatus;
import dlshade.org.apache.bookkeeper.bookie.LastAddConfirmedUpdateNotification;
import dlshade.org.apache.bookkeeper.bookie.LedgerDirsManager;
import dlshade.org.apache.bookkeeper.bookie.StateManager;
import dlshade.org.apache.bookkeeper.common.util.Watcher;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.meta.LedgerManager;
import dlshade.org.apache.bookkeeper.stats.StatsLogger;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.PrimitiveIterator;

public interface LedgerStorage {
    public void initialize(ServerConfiguration var1, LedgerManager var2, LedgerDirsManager var3, LedgerDirsManager var4, StateManager var5, CheckpointSource var6, Checkpointer var7, StatsLogger var8, ByteBufAllocator var9) throws IOException;

    public void start();

    public void shutdown() throws InterruptedException;

    public boolean ledgerExists(long var1) throws IOException;

    public boolean setFenced(long var1) throws IOException;

    public boolean isFenced(long var1) throws IOException;

    public void setMasterKey(long var1, byte[] var3) throws IOException;

    public byte[] readMasterKey(long var1) throws IOException, BookieException;

    public long addEntry(ByteBuf var1) throws IOException, BookieException;

    public ByteBuf getEntry(long var1, long var3) throws IOException;

    public long getLastAddConfirmed(long var1) throws IOException;

    public boolean waitForLastAddConfirmedUpdate(long var1, long var3, Watcher<LastAddConfirmedUpdateNotification> var5) throws IOException;

    public void cancelWaitForLastAddConfirmedUpdate(long var1, Watcher<LastAddConfirmedUpdateNotification> var3) throws IOException;

    public void flush() throws IOException;

    public void checkpoint(CheckpointSource.Checkpoint var1) throws IOException;

    public void deleteLedger(long var1) throws IOException;

    public void registerLedgerDeletionListener(LedgerDeletionListener var1);

    public void setExplicitLac(long var1, ByteBuf var3) throws IOException;

    public ByteBuf getExplicitLac(long var1) throws IOException;

    default public LedgerStorage getUnderlyingLedgerStorage() {
        return this;
    }

    default public void forceGC() {
    }

    default public List<DetectedInconsistency> localConsistencyCheck(Optional<RateLimiter> rateLimiter) throws IOException {
        return new ArrayList<DetectedInconsistency>();
    }

    default public boolean isInForceGC() {
        return false;
    }

    default public List<GarbageCollectionStatus> getGarbageCollectionStatus() {
        return Collections.emptyList();
    }

    public PrimitiveIterator.OfLong getListOfEntriesOfLedger(long var1) throws IOException;

    public static class DetectedInconsistency {
        private long ledgerId;
        private long entryId;
        private Exception detail;

        DetectedInconsistency(long ledgerId, long entryId, Exception detail) {
            this.ledgerId = ledgerId;
            this.entryId = entryId;
            this.detail = detail;
        }

        public long getLedgerId() {
            return this.ledgerId;
        }

        public long getEntryId() {
            return this.entryId;
        }

        public Exception getException() {
            return this.detail;
        }
    }

    public static interface LedgerDeletionListener {
        public void ledgerDeleted(long var1);
    }
}

