/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.client;

import dlshade.org.apache.bookkeeper.client.BKException;
import dlshade.org.apache.bookkeeper.client.BookieInfoReader;
import dlshade.org.apache.bookkeeper.client.BookiesHealthInfo;
import dlshade.org.apache.bookkeeper.client.DistributionSchedule;
import dlshade.org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import dlshade.org.apache.bookkeeper.client.WeightedRandomSelection;
import dlshade.org.apache.bookkeeper.client.WeightedRandomSelectionImpl;
import dlshade.org.apache.bookkeeper.conf.ClientConfiguration;
import dlshade.org.apache.bookkeeper.feature.FeatureProvider;
import dlshade.org.apache.bookkeeper.net.BookieId;
import dlshade.org.apache.bookkeeper.net.DNSToSwitchMapping;
import dlshade.org.apache.bookkeeper.proto.BookieAddressResolver;
import dlshade.org.apache.bookkeeper.stats.StatsLogger;
import dlshade.org.apache.commons.collections4.CollectionUtils;
import io.netty.util.HashedWheelTimer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEnsemblePlacementPolicy
implements EnsemblePlacementPolicy {
    static final Logger LOG = LoggerFactory.getLogger(DefaultEnsemblePlacementPolicy.class);
    static final Set<BookieId> EMPTY_SET = new HashSet<BookieId>();
    private boolean isWeighted;
    private int maxWeightMultiple;
    private Set<BookieId> knownBookies = new HashSet<BookieId>();
    private Map<BookieId, WeightedRandomSelection.WeightedObject> bookieInfoMap = new HashMap<BookieId, WeightedRandomSelection.WeightedObject>();
    private WeightedRandomSelection<BookieId> weightedSelection;
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();

    DefaultEnsemblePlacementPolicy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnsemblePlacementPolicy.PlacementResult<List<BookieId>> newEnsemble(int ensembleSize, int quorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        ArrayList<BookieId> allBookies;
        ArrayList<BookieId> newBookies = new ArrayList<BookieId>(ensembleSize);
        if (ensembleSize <= 0) {
            return EnsemblePlacementPolicy.PlacementResult.of(newBookies, EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL);
        }
        this.rwLock.readLock().lock();
        try {
            allBookies = new ArrayList<BookieId>(this.knownBookies);
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        if (this.isWeighted) {
            this.rwLock.readLock().lock();
            try {
                if (CollectionUtils.subtract(allBookies, excludeBookies).size() < ensembleSize) {
                    throw new BKException.BKNotEnoughBookiesException();
                }
                while (ensembleSize > 0) {
                    BookieId b = this.weightedSelection.getNextRandom();
                    if (newBookies.contains(b) || excludeBookies.contains(b)) continue;
                    newBookies.add(b);
                    if (--ensembleSize != 0) continue;
                    EnsemblePlacementPolicy.PlacementResult<List<BookieId>> placementResult = EnsemblePlacementPolicy.PlacementResult.of(newBookies, this.isEnsembleAdheringToPlacementPolicy(newBookies, quorumSize, ackQuorumSize));
                    return placementResult;
                }
            }
            finally {
                this.rwLock.readLock().unlock();
            }
        }
        Collections.shuffle(allBookies);
        for (BookieId bookie : allBookies) {
            if (excludeBookies.contains(bookie)) continue;
            newBookies.add(bookie);
            if (--ensembleSize != 0) continue;
            return EnsemblePlacementPolicy.PlacementResult.of(newBookies, this.isEnsembleAdheringToPlacementPolicy(newBookies, quorumSize, ackQuorumSize));
        }
        throw new BKException.BKNotEnoughBookiesException();
    }

    @Override
    public EnsemblePlacementPolicy.PlacementResult<BookieId> replaceBookie(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, List<BookieId> currentEnsemble, BookieId bookieToReplace, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        excludeBookies.addAll(currentEnsemble);
        List<BookieId> addresses = this.newEnsemble(1, 1, 1, customMetadata, excludeBookies).getResult();
        BookieId candidateAddr = addresses.get(0);
        ArrayList<BookieId> newEnsemble = new ArrayList<BookieId>(currentEnsemble);
        newEnsemble.set(currentEnsemble.indexOf(bookieToReplace), candidateAddr);
        return EnsemblePlacementPolicy.PlacementResult.of(candidateAddr, this.isEnsembleAdheringToPlacementPolicy(newEnsemble, writeQuorumSize, ackQuorumSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<BookieId> onClusterChanged(Set<BookieId> writableBookies, Set<BookieId> readOnlyBookies) {
        this.rwLock.writeLock().lock();
        try {
            HashSet<BookieId> deadBookies = new HashSet<BookieId>(this.knownBookies);
            deadBookies.removeAll(writableBookies);
            deadBookies.removeAll(readOnlyBookies);
            if (this.isWeighted) {
                for (BookieId b : deadBookies) {
                    this.bookieInfoMap.remove(b);
                }
                Collection<BookieId> newBookies = CollectionUtils.subtract(writableBookies, this.knownBookies);
                for (BookieId b : newBookies) {
                    this.bookieInfoMap.put(b, new BookieInfoReader.BookieInfo());
                }
                if (deadBookies.size() > 0 || newBookies.size() > 0) {
                    this.weightedSelection.updateMap(this.bookieInfoMap);
                }
            }
            this.knownBookies = writableBookies;
            HashSet<BookieId> hashSet = deadBookies;
            return hashSet;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public void registerSlowBookie(BookieId bookieSocketAddress, long entryId) {
    }

    @Override
    public DistributionSchedule.WriteSet reorderReadSequence(List<BookieId> ensemble, BookiesHealthInfo bookiesHealthInfo, DistributionSchedule.WriteSet writeSet) {
        return writeSet;
    }

    @Override
    public DistributionSchedule.WriteSet reorderReadLACSequence(List<BookieId> ensemble, BookiesHealthInfo bookiesHealthInfo, DistributionSchedule.WriteSet writeSet) {
        writeSet.addMissingIndices(ensemble.size());
        return writeSet;
    }

    @Override
    public EnsemblePlacementPolicy initialize(ClientConfiguration conf, Optional<DNSToSwitchMapping> optionalDnsResolver, HashedWheelTimer hashedWheelTimer, FeatureProvider featureProvider, StatsLogger statsLogger, BookieAddressResolver bookieAddressResolver) {
        this.isWeighted = conf.getDiskWeightBasedPlacementEnabled();
        if (this.isWeighted) {
            this.maxWeightMultiple = conf.getBookieMaxWeightMultipleForWeightBasedPlacement();
            this.weightedSelection = new WeightedRandomSelectionImpl<BookieId>(this.maxWeightMultiple);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBookieInfo(Map<BookieId, BookieInfoReader.BookieInfo> bookieInfoMap) {
        this.rwLock.writeLock().lock();
        try {
            for (Map.Entry<BookieId, BookieInfoReader.BookieInfo> e : bookieInfoMap.entrySet()) {
                this.bookieInfoMap.put(e.getKey(), e.getValue());
            }
            this.weightedSelection.updateMap(this.bookieInfoMap);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public void uninitalize() {
    }

    @Override
    public EnsemblePlacementPolicy.PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy(List<BookieId> ensembleList, int writeQuorumSize, int ackQuorumSize) {
        return EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT;
    }
}

