/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.client.api;

import dlshade.org.apache.bookkeeper.client.api.BKException;
import dlshade.org.apache.bookkeeper.client.api.ForceableHandle;
import dlshade.org.apache.bookkeeper.client.api.ReadHandle;
import dlshade.org.apache.bookkeeper.common.annotation.InterfaceAudience;
import dlshade.org.apache.bookkeeper.common.annotation.InterfaceStability;
import dlshade.org.apache.bookkeeper.common.concurrent.FutureUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public interface WriteHandle
extends ReadHandle,
ForceableHandle {
    public CompletableFuture<Long> appendAsync(ByteBuf var1);

    default public long append(ByteBuf data) throws BKException, InterruptedException {
        return FutureUtils.result(this.appendAsync(data), BKException.HANDLER);
    }

    default public CompletableFuture<Long> appendAsync(ByteBuffer data) {
        return this.appendAsync(Unpooled.wrappedBuffer((ByteBuffer)data));
    }

    default public long append(ByteBuffer data) throws BKException, InterruptedException {
        return this.append(Unpooled.wrappedBuffer((ByteBuffer)data));
    }

    default public CompletableFuture<Long> appendAsync(byte[] data) {
        return this.appendAsync(Unpooled.wrappedBuffer((byte[])data));
    }

    default public long append(byte[] data) throws BKException, InterruptedException {
        return this.append(Unpooled.wrappedBuffer((byte[])data));
    }

    default public CompletableFuture<Long> appendAsync(byte[] data, int offset, int length) {
        return this.appendAsync(Unpooled.wrappedBuffer((byte[])data, (int)offset, (int)length));
    }

    default public long append(byte[] data, int offset, int length) throws BKException, InterruptedException {
        return this.append(Unpooled.wrappedBuffer((byte[])data, (int)offset, (int)length));
    }

    public long getLastAddPushed();

    @Override
    public CompletableFuture<Void> closeAsync();

    @Override
    default public void close() throws BKException, InterruptedException {
        FutureUtils.result(this.closeAsync(), BKException.HANDLER);
    }
}

