/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.common.component;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentInfoPublisher {
    private static final Logger log = LoggerFactory.getLogger(ComponentInfoPublisher.class);
    private final Map<String, String> properties = new ConcurrentHashMap<String, String>();
    private final Map<String, EndpointInfo> endpoints = new ConcurrentHashMap<String, EndpointInfo>();
    private volatile boolean startupFinished;

    public void publishProperty(String key, String value) {
        if (log.isDebugEnabled()) {
            log.debug("publish {}={}", (Object)key, (Object)value);
        }
        if (this.startupFinished) {
            throw new IllegalStateException("Server already started, cannot publish " + key);
        }
        Objects.requireNonNull(key);
        Objects.requireNonNull(value, "Value for " + key + " cannot be null");
        this.properties.put(key, value);
    }

    public void publishEndpoint(EndpointInfo endpoint) {
        EndpointInfo exists;
        if (log.isDebugEnabled()) {
            log.debug("publishEndpoint {} on {}", (Object)endpoint, (Object)this);
        }
        if ((exists = this.endpoints.put(endpoint.id, endpoint)) != null) {
            throw new IllegalStateException("An endpoint with id " + endpoint.id + " has already been published: " + exists);
        }
    }

    public Map<String, String> getProperties() {
        if (!this.startupFinished) {
            throw new IllegalStateException("Startup not yet finished");
        }
        return Collections.unmodifiableMap(this.properties);
    }

    public Map<String, EndpointInfo> getEndpoints() {
        if (!this.startupFinished) {
            throw new IllegalStateException("Startup not yet finished");
        }
        return Collections.unmodifiableMap(this.endpoints);
    }

    public void startupFinished() {
        this.startupFinished = true;
    }

    public static final class EndpointInfo {
        private final String id;
        private final int port;
        private final String host;
        private final String protocol;
        private final List<String> auth;
        private final List<String> extensions;

        public EndpointInfo(String id, int port, String host, String protocol, List<String> auth, List<String> extensions) {
            this.id = id;
            this.port = port;
            this.host = host;
            this.protocol = protocol;
            this.auth = auth == null ? Collections.emptyList() : Collections.unmodifiableList(auth);
            this.extensions = extensions == null ? Collections.emptyList() : Collections.unmodifiableList(extensions);
        }

        public String getId() {
            return this.id;
        }

        public int getPort() {
            return this.port;
        }

        public String getHost() {
            return this.host;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public List<String> getAuth() {
            return this.auth;
        }

        public List<String> getExtensions() {
            return this.extensions;
        }

        public String toString() {
            return "EndpointInfo{id=" + this.id + ", port=" + this.port + ", host=" + this.host + ", protocol=" + this.protocol + ", auth=" + this.auth + ", extensions=" + this.extensions + '}';
        }
    }
}

