/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.meta;

import dlshade.com.google.protobuf.Message;
import dlshade.com.google.protobuf.TextFormat;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.meta.LedgerAuditorManager;
import dlshade.org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import dlshade.org.apache.bookkeeper.net.BookieId;
import dlshade.org.apache.bookkeeper.proto.DataFormats;
import dlshade.org.apache.bookkeeper.stats.Counter;
import dlshade.org.apache.bookkeeper.stats.StatsLogger;
import dlshade.org.apache.bookkeeper.stats.annotations.StatsDoc;
import dlshade.org.apache.bookkeeper.util.ZkUtils;
import dlshade.org.apache.commons.lang.StringUtils;
import dlshade.org.apache.zookeeper.CreateMode;
import dlshade.org.apache.zookeeper.KeeperException;
import dlshade.org.apache.zookeeper.WatchedEvent;
import dlshade.org.apache.zookeeper.Watcher;
import dlshade.org.apache.zookeeper.ZooKeeper;
import dlshade.org.apache.zookeeper.data.ACL;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkLedgerAuditorManager
implements LedgerAuditorManager {
    private static final Logger log = LoggerFactory.getLogger(ZkLedgerAuditorManager.class);
    private final ZooKeeper zkc;
    private final ServerConfiguration conf;
    private final String basePath;
    private final String electionPath;
    private String myVote;
    private static final String ELECTION_ZNODE = "auditorelection";
    private static final int AUDITOR_INDEX = 0;
    private static final String VOTE_PREFIX = "V_";
    private static final String PATH_SEPARATOR = "/";
    private volatile Consumer<LedgerAuditorManager.AuditorEvent> listener;
    private volatile boolean isClosed = false;
    @StatsDoc(name="election_attempts", help="The number of auditor election attempts")
    private final Counter electionAttempts;

    public ZkLedgerAuditorManager(ZooKeeper zkc, ServerConfiguration conf, StatsLogger statsLogger) {
        this.zkc = zkc;
        this.conf = conf;
        this.basePath = ZKMetadataDriverBase.resolveZkLedgersRootPath(conf) + '/' + "underreplication";
        this.electionPath = this.basePath + '/' + ELECTION_ZNODE;
        this.electionAttempts = statsLogger.getCounter("election_attempts");
    }

    @Override
    public void tryToBecomeAuditor(String bookieId, Consumer<LedgerAuditorManager.AuditorEvent> listener) throws IOException, InterruptedException {
        this.listener = listener;
        this.createElectorPath();
        try {
            while (!this.isClosed) {
                this.createMyVote(bookieId);
                List<String> children = this.zkc.getChildren(this.getVotePath(""), false);
                if (0 >= children.size()) {
                    throw new IllegalArgumentException("At least one bookie server should present to elect the Auditor!");
                }
                Collections.sort(children, new ElectionComparator());
                String voteNode = StringUtils.substringAfterLast(this.myVote, PATH_SEPARATOR);
                if (children.get(0).equals(voteNode)) {
                    DataFormats.AuditorVoteFormat.Builder builder = DataFormats.AuditorVoteFormat.newBuilder().setBookieId(bookieId);
                    this.zkc.setData(this.getVotePath(""), builder.build().toString().getBytes(StandardCharsets.UTF_8), -1);
                    return;
                }
                int myIndex = children.indexOf(voteNode);
                if (myIndex < 0) {
                    throw new IllegalArgumentException("My vote has disappeared");
                }
                int prevNodeIndex = myIndex - 1;
                CountDownLatch latch = new CountDownLatch(1);
                if (null == this.zkc.exists(this.getVotePath(PATH_SEPARATOR) + children.get(prevNodeIndex), event -> latch.countDown())) continue;
                latch.await();
                this.electionAttempts.inc();
            }
        }
        catch (KeeperException e) {
            throw new IOException(e);
        }
    }

    @Override
    public BookieId getCurrentAuditor() throws IOException, InterruptedException {
        String electionRoot = ZKMetadataDriverBase.resolveZkLedgersRootPath(this.conf) + '/' + "underreplication" + '/' + ELECTION_ZNODE;
        try {
            List<String> children = this.zkc.getChildren(electionRoot, false);
            Collections.sort(children, new ElectionComparator());
            if (children.size() < 1) {
                return null;
            }
            String ledger = electionRoot + PATH_SEPARATOR + children.get(0);
            byte[] data = this.zkc.getData(ledger, false, null);
            DataFormats.AuditorVoteFormat.Builder builder = DataFormats.AuditorVoteFormat.newBuilder();
            TextFormat.merge(new String(data, StandardCharsets.UTF_8), (Message.Builder)builder);
            DataFormats.AuditorVoteFormat v = builder.build();
            return BookieId.parse(v.getBookieId());
        }
        catch (KeeperException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws Exception {
        log.info("Shutting down AuditorElector");
        this.isClosed = true;
        if (this.myVote != null) {
            try {
                this.zkc.delete(this.myVote, -1);
            }
            catch (KeeperException.NoNodeException noNodeException) {
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                log.warn("InterruptedException while deleting myVote: " + this.myVote, (Throwable)ie);
            }
            catch (KeeperException ke) {
                log.error("Exception while deleting myVote:" + this.myVote, (Throwable)ke);
            }
        }
    }

    private void createMyVote(String bookieId) throws IOException, InterruptedException {
        List<ACL> zkAcls = ZkUtils.getACLs(this.conf);
        DataFormats.AuditorVoteFormat.Builder builder = DataFormats.AuditorVoteFormat.newBuilder().setBookieId(bookieId);
        try {
            if (null == this.myVote || null == this.zkc.exists(this.myVote, false)) {
                this.myVote = this.zkc.create(this.getVotePath("/V_"), builder.build().toString().getBytes(StandardCharsets.UTF_8), zkAcls, CreateMode.EPHEMERAL_SEQUENTIAL);
            }
        }
        catch (KeeperException e) {
            throw new IOException(e);
        }
    }

    private void createElectorPath() throws IOException {
        try {
            List<ACL> zkAcls = ZkUtils.getACLs(this.conf);
            if (this.zkc.exists(this.basePath, false) == null) {
                try {
                    this.zkc.create(this.basePath, new byte[0], zkAcls, CreateMode.PERSISTENT);
                }
                catch (KeeperException.NodeExistsException nodeExistsException) {
                    // empty catch block
                }
            }
            if (this.zkc.exists(this.getVotePath(""), false) == null) {
                try {
                    this.zkc.create(this.getVotePath(""), new byte[0], zkAcls, CreateMode.PERSISTENT);
                }
                catch (KeeperException.NodeExistsException nodeExistsException) {}
            }
        }
        catch (KeeperException ke) {
            throw new IOException("Failed to initialize Auditor Elector", ke);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new IOException("Failed to initialize Auditor Elector", ie);
        }
    }

    private String getVotePath(String vote) {
        return this.electionPath + vote;
    }

    private void handleZkWatch(WatchedEvent event) {
        if (this.isClosed) {
            return;
        }
        if (event.getState() == Watcher.Event.KeeperState.Expired) {
            log.error("Lost ZK connection, shutting down");
            this.listener.accept(LedgerAuditorManager.AuditorEvent.SessionLost);
        } else if (event.getType() == Watcher.Event.EventType.NodeDeleted) {
            this.listener.accept(LedgerAuditorManager.AuditorEvent.VoteWasDeleted);
        }
    }

    private static class ElectionComparator
    implements Comparator<String>,
    Serializable {
        private ElectionComparator() {
        }

        @Override
        public int compare(String vote1, String vote2) {
            long voteSeqId2;
            long voteSeqId1 = this.getVoteSequenceId(vote1);
            int result = voteSeqId1 < (voteSeqId2 = this.getVoteSequenceId(vote2)) ? -1 : (voteSeqId1 > voteSeqId2 ? 1 : 0);
            return result;
        }

        private long getVoteSequenceId(String vote) {
            String voteId = StringUtils.substringAfter(vote, ZkLedgerAuditorManager.VOTE_PREFIX);
            return Long.parseLong(voteId);
        }
    }
}

