/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.proto;

import dlshade.org.apache.bookkeeper.bookie.Bookie;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.discover.BookieServiceInfo;
import dlshade.org.apache.bookkeeper.discover.BookieServiceInfoUtils;
import dlshade.org.apache.bookkeeper.net.BookieSocketAddress;
import java.net.UnknownHostException;
import java.util.function.Supplier;

public class SimpleBookieServiceInfoProvider
implements Supplier<BookieServiceInfo> {
    private final BookieSocketAddress bookieSocketAddress;

    public SimpleBookieServiceInfoProvider(ServerConfiguration serverConfiguration) {
        try {
            this.bookieSocketAddress = Bookie.getBookieAddress(serverConfiguration);
        }
        catch (UnknownHostException err) {
            throw new RuntimeException(err);
        }
    }

    @Override
    public BookieServiceInfo get() {
        try {
            return BookieServiceInfoUtils.buildLegacyBookieServiceInfo(this.bookieSocketAddress.toBookieId().toString());
        }
        catch (UnknownHostException err) {
            throw new RuntimeException(err);
        }
    }
}

