/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.server.http.service;

import dlshade.com.google.common.base.Preconditions;
import dlshade.com.google.common.collect.Lists;
import dlshade.org.apache.bookkeeper.bookie.Bookie;
import dlshade.org.apache.bookkeeper.bookie.BookieException;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.http.HttpServer;
import dlshade.org.apache.bookkeeper.http.service.HttpEndpointService;
import dlshade.org.apache.bookkeeper.http.service.HttpServiceRequest;
import dlshade.org.apache.bookkeeper.http.service.HttpServiceResponse;
import dlshade.org.apache.bookkeeper.meta.MetadataBookieDriver;
import dlshade.org.apache.bookkeeper.meta.MetadataDrivers;
import dlshade.org.apache.bookkeeper.stats.NullStatsLogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpandStorageService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(ExpandStorageService.class);
    protected ServerConfiguration conf;

    public ExpandStorageService(ServerConfiguration conf) {
        Preconditions.checkNotNull(conf);
        this.conf = conf;
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        if (HttpServer.Method.PUT == request.getMethod()) {
            File[] ledgerDirectories = Bookie.getCurrentDirectories(this.conf.getLedgerDirs());
            File[] journalDirectories = Bookie.getCurrentDirectories(this.conf.getJournalDirs());
            File[] indexDirectories = null == this.conf.getIndexDirs() ? ledgerDirectories : Bookie.getCurrentDirectories(this.conf.getIndexDirs());
            ArrayList<File> allLedgerDirs = Lists.newArrayList();
            allLedgerDirs.addAll(Arrays.asList(ledgerDirectories));
            if (indexDirectories != ledgerDirectories) {
                allLedgerDirs.addAll(Arrays.asList(indexDirectories));
            }
            try (MetadataBookieDriver driver = MetadataDrivers.getBookieDriver(URI.create(this.conf.getMetadataServiceUri()));){
                driver.initialize(this.conf, () -> {}, NullStatsLogger.INSTANCE);
                Bookie.checkEnvironmentWithStorageExpansion(this.conf, driver, Lists.newArrayList(journalDirectories), allLedgerDirs);
            }
            catch (BookieException e) {
                LOG.error("Exception occurred while updating cookie for storage expansion", (Throwable)e);
                response.setCode(HttpServer.StatusCode.INTERNAL_ERROR);
                response.setBody("Exception while updating cookie for storage expansion");
                return response;
            }
            String jsonResponse = "Success expand storage";
            LOG.debug("output body:" + jsonResponse);
            response.setBody(jsonResponse);
            response.setCode(HttpServer.StatusCode.OK);
            return response;
        }
        response.setCode(HttpServer.StatusCode.NOT_FOUND);
        response.setBody("Not found method. Should be PUT method");
        return response;
    }
}

