/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.server.http.service;

import dlshade.com.google.common.base.Preconditions;
import dlshade.org.apache.bookkeeper.bookie.GarbageCollectionStatus;
import dlshade.org.apache.bookkeeper.common.util.JsonUtil;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.http.HttpServer;
import dlshade.org.apache.bookkeeper.http.service.HttpEndpointService;
import dlshade.org.apache.bookkeeper.http.service.HttpServiceRequest;
import dlshade.org.apache.bookkeeper.http.service.HttpServiceResponse;
import dlshade.org.apache.bookkeeper.proto.BookieServer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCDetailsService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(GCDetailsService.class);
    protected ServerConfiguration conf;
    protected BookieServer bookieServer;

    public GCDetailsService(ServerConfiguration conf, BookieServer bookieServer) {
        Preconditions.checkNotNull(conf);
        Preconditions.checkNotNull(bookieServer);
        this.conf = conf;
        this.bookieServer = bookieServer;
    }

    @Override
    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        if (HttpServer.Method.GET == request.getMethod()) {
            List<GarbageCollectionStatus> details = this.bookieServer.getBookie().getLedgerStorage().getGarbageCollectionStatus();
            String jsonResponse = JsonUtil.toJson(details);
            if (LOG.isDebugEnabled()) {
                LOG.debug("output body:" + jsonResponse);
            }
            response.setBody(jsonResponse);
            response.setCode(HttpServer.StatusCode.OK);
            return response;
        }
        response.setCode(HttpServer.StatusCode.NOT_FOUND);
        response.setBody("Only support GET method to retrieve GC details. If you want to trigger gc, send a POST to gc endpoint.");
        return response;
    }
}

