/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.bookkeeper.tools.cli.commands.client;

import com.beust.jcommander.Parameter;
import dlshade.com.google.common.util.concurrent.UncheckedExecutionException;
import dlshade.org.apache.bookkeeper.client.api.LedgerMetadata;
import dlshade.org.apache.bookkeeper.conf.ServerConfiguration;
import dlshade.org.apache.bookkeeper.meta.LedgerManager;
import dlshade.org.apache.bookkeeper.meta.LedgerMetadataSerDe;
import dlshade.org.apache.bookkeeper.meta.MetadataDrivers;
import dlshade.org.apache.bookkeeper.meta.exceptions.MetadataException;
import dlshade.org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import dlshade.org.apache.bookkeeper.tools.framework.CliFlags;
import dlshade.org.apache.bookkeeper.tools.framework.CliSpec;
import dlshade.org.apache.bookkeeper.util.LedgerIdFormatter;
import dlshade.org.apache.bookkeeper.versioning.Versioned;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
public class LedgerMetaDataCommand
extends BookieCommand<LedgerMetadataFlag> {
    private static final String NAME = "show";
    private static final String DESC = "Print the metadata for a ledger, or optionally dump to a file.";
    private static final String DEFAULT = "";
    private static final long DEFAULT_ID = -1L;
    private static final Logger LOG = LoggerFactory.getLogger(LedgerMetaDataCommand.class);
    private LedgerMetadataSerDe serDe = new LedgerMetadataSerDe();
    private LedgerIdFormatter ledgerIdFormatter;

    public LedgerMetaDataCommand() {
        this(new LedgerMetadataFlag());
    }

    public LedgerMetaDataCommand(LedgerIdFormatter ledgerIdFormatter) {
        this();
        this.ledgerIdFormatter = ledgerIdFormatter;
    }

    public LedgerMetaDataCommand(LedgerMetadataFlag flag) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(flag).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, LedgerMetadataFlag cmdFlags) {
        if (!cmdFlags.ledgerIdFormatter.equals(DEFAULT) && this.ledgerIdFormatter == null) {
            this.ledgerIdFormatter = LedgerIdFormatter.newLedgerIdFormatter(cmdFlags.ledgerIdFormatter, conf);
        } else if (this.ledgerIdFormatter == null) {
            this.ledgerIdFormatter = LedgerIdFormatter.newLedgerIdFormatter(conf);
        }
        try {
            return this.handler(conf, cmdFlags);
        }
        catch (Exception e) {
            throw new UncheckedExecutionException(e.getMessage(), e);
        }
    }

    private boolean handler(ServerConfiguration conf, LedgerMetadataFlag flag) throws MetadataException, ExecutionException {
        if (flag.ledgerId == -1L) {
            LOG.error("Must specific a ledger id");
            return false;
        }
        MetadataDrivers.runFunctionWithLedgerManagerFactory(conf, mFactory -> {
            try (LedgerManager m = mFactory.newLedgerManager();){
                if (!flag.dumpToFile.equals(DEFAULT)) {
                    Versioned<LedgerMetadata> md = m.readLedgerMetadata(flag.ledgerId).join();
                    Files.write(FileSystems.getDefault().getPath(flag.dumpToFile, new String[0]), this.serDe.serialize(md.getValue()), new OpenOption[0]);
                } else if (!flag.restoreFromFile.equals(DEFAULT)) {
                    byte[] serialized = Files.readAllBytes(FileSystems.getDefault().getPath(flag.restoreFromFile, new String[0]));
                    LedgerMetadata md = this.serDe.parseConfig(serialized, flag.ledgerId, Optional.empty());
                    m.createLedgerMetadata(flag.ledgerId, md).join();
                } else {
                    this.printLedgerMetadata(flag.ledgerId, m.readLedgerMetadata(flag.ledgerId).get().getValue(), true);
                }
            }
            catch (Exception e) {
                throw new UncheckedExecutionException(e);
            }
            return null;
        });
        return true;
    }

    private void printLedgerMetadata(long ledgerId, LedgerMetadata md, boolean printMeta) {
        LOG.info("ledgerID: " + this.ledgerIdFormatter.formatLedgerId(ledgerId));
        if (printMeta) {
            LOG.info(md.toString());
        }
    }

    public static class LedgerMetadataFlag
    extends CliFlags {
        @Parameter(names={"-l", "--ledgerid"}, description="Ledger ID", required=true)
        private long ledgerId = -1L;
        @Parameter(names={"-d", "--dumptofile"}, description="Dump metadata for ledger, to a file")
        private String dumpToFile = "";
        @Parameter(names={"-r", "--restorefromefile"}, description="Restore metadata for ledger, from a file")
        private String restoreFromFile = "";
        @Parameter(names={"-lf", "--ledgeridformatter"}, description="Set ledger id formatter")
        private String ledgerIdFormatter = "";

        public LedgerMetadataFlag ledgerId(long ledgerId) {
            this.ledgerId = ledgerId;
            return this;
        }

        public LedgerMetadataFlag dumpToFile(String dumpToFile) {
            this.dumpToFile = dumpToFile;
            return this;
        }

        public LedgerMetadataFlag restoreFromFile(String restoreFromFile) {
            this.restoreFromFile = restoreFromFile;
            return this;
        }

        public LedgerMetadataFlag ledgerIdFormatter(String ledgerIdFormatter) {
            this.ledgerIdFormatter = ledgerIdFormatter;
            return this;
        }
    }
}

