/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.http.client.protocol;

import dlshade.org.apache.http.HttpEntity;
import dlshade.org.apache.http.HttpEntityEnclosingRequest;
import dlshade.org.apache.http.HttpException;
import dlshade.org.apache.http.HttpRequest;
import dlshade.org.apache.http.HttpRequestInterceptor;
import dlshade.org.apache.http.HttpVersion;
import dlshade.org.apache.http.ProtocolVersion;
import dlshade.org.apache.http.annotation.Contract;
import dlshade.org.apache.http.annotation.ThreadingBehavior;
import dlshade.org.apache.http.client.config.RequestConfig;
import dlshade.org.apache.http.client.protocol.HttpClientContext;
import dlshade.org.apache.http.protocol.HttpContext;
import dlshade.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

