/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.http.protocol;

import dlshade.org.apache.http.HttpException;
import dlshade.org.apache.http.HttpRequest;
import dlshade.org.apache.http.HttpRequestInterceptor;
import dlshade.org.apache.http.annotation.Contract;
import dlshade.org.apache.http.annotation.ThreadingBehavior;
import dlshade.org.apache.http.protocol.HttpContext;
import dlshade.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

