/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.zookeeper.server.quorum;

import dlshade.org.apache.zookeeper.jmx.ZKMBeanInfo;
import dlshade.org.apache.zookeeper.server.ZooKeeperServer;
import dlshade.org.apache.zookeeper.server.quorum.Observer;
import dlshade.org.apache.zookeeper.server.quorum.QuorumMXBean;
import dlshade.org.apache.zookeeper.server.quorum.QuorumPeer;

public class QuorumBean
implements QuorumMXBean,
ZKMBeanInfo {
    private final QuorumPeer peer;
    private final String name;

    public QuorumBean(QuorumPeer peer) {
        this.peer = peer;
        this.name = "ReplicatedServer_id" + peer.getId();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public int getQuorumSize() {
        return this.peer.getQuorumSize();
    }

    @Override
    public int getSyncLimit() {
        return this.peer.getSyncLimit();
    }

    @Override
    public int getInitLimit() {
        return this.peer.getInitLimit();
    }

    @Override
    public void setInitLimit(int initLimit) {
        this.peer.setInitLimit(initLimit);
    }

    @Override
    public void setSyncLimit(int syncLimit) {
        this.peer.setSyncLimit(syncLimit);
    }

    @Override
    public boolean isSslQuorum() {
        return this.peer.isSslQuorum();
    }

    @Override
    public boolean isPortUnification() {
        return this.peer.shouldUsePortUnification();
    }

    @Override
    public long getObserverElectionDelayMS() {
        return Observer.getObserverElectionDelayMs();
    }

    @Override
    public void setObserverElectionDelayMS(long delayMS) {
        Observer.setObserverElectionDelayMs(delayMS);
    }

    @Override
    public boolean getDigestEnabled() {
        return ZooKeeperServer.isDigestEnabled();
    }

    @Override
    public void disableDigest() {
        ZooKeeperServer.setDigestEnabled(false);
    }
}

