/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.rocksdb;

import dlshade.org.rocksdb.ColumnFamilyDescriptor;
import dlshade.org.rocksdb.RocksDB;
import dlshade.org.rocksdb.RocksDBException;
import dlshade.org.rocksdb.RocksObject;
import java.util.Arrays;
import java.util.Objects;

public class ColumnFamilyHandle
extends RocksObject {
    private final RocksDB rocksDB_;

    ColumnFamilyHandle(RocksDB rocksDB, long l) {
        super(l);
        assert (rocksDB != null);
        this.rocksDB_ = rocksDB;
    }

    ColumnFamilyHandle(long l) {
        super(l);
        this.rocksDB_ = null;
        this.disOwnNativeHandle();
    }

    public byte[] getName() throws RocksDBException {
        assert (this.isOwningHandle() || this.isDefaultColumnFamily());
        return this.getName(this.nativeHandle_);
    }

    public int getID() {
        assert (this.isOwningHandle() || this.isDefaultColumnFamily());
        return this.getID(this.nativeHandle_);
    }

    public ColumnFamilyDescriptor getDescriptor() throws RocksDBException {
        assert (this.isOwningHandle() || this.isDefaultColumnFamily());
        return this.getDescriptor(this.nativeHandle_);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ColumnFamilyHandle columnFamilyHandle = (ColumnFamilyHandle)object;
        try {
            return this.rocksDB_.nativeHandle_ == columnFamilyHandle.rocksDB_.nativeHandle_ && this.getID() == columnFamilyHandle.getID() && Arrays.equals(this.getName(), columnFamilyHandle.getName());
        }
        catch (RocksDBException rocksDBException) {
            throw new RuntimeException("Cannot compare column family handles", rocksDBException);
        }
    }

    public int hashCode() {
        try {
            return Objects.hash(this.getName(), this.getID(), this.rocksDB_.nativeHandle_);
        }
        catch (RocksDBException rocksDBException) {
            throw new RuntimeException("Cannot calculate hash code of column family handle", rocksDBException);
        }
    }

    protected boolean isDefaultColumnFamily() {
        return this.nativeHandle_ == this.rocksDB_.getDefaultColumnFamily().nativeHandle_;
    }

    @Override
    protected void disposeInternal() {
        if (this.rocksDB_.isOwningHandle()) {
            this.disposeInternal(this.nativeHandle_);
        }
    }

    private native byte[] getName(long var1) throws RocksDBException;

    private native int getID(long var1);

    private native ColumnFamilyDescriptor getDescriptor(long var1) throws RocksDBException;

    @Override
    protected final native void disposeInternal(long var1);
}

