/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.rocksdb;

import dlshade.org.rocksdb.HistogramData;
import dlshade.org.rocksdb.HistogramType;
import dlshade.org.rocksdb.RocksDBException;
import dlshade.org.rocksdb.RocksObject;
import dlshade.org.rocksdb.StatsLevel;
import dlshade.org.rocksdb.TickerType;
import java.util.EnumSet;

public class Statistics
extends RocksObject {
    public Statistics() {
        super(Statistics.newStatistics());
    }

    public Statistics(Statistics statistics) {
        super(Statistics.newStatistics(statistics.nativeHandle_));
    }

    public Statistics(EnumSet<HistogramType> enumSet) {
        super(Statistics.newStatistics(Statistics.toArrayValues(enumSet)));
    }

    public Statistics(EnumSet<HistogramType> enumSet, Statistics statistics) {
        super(Statistics.newStatistics(Statistics.toArrayValues(enumSet), statistics.nativeHandle_));
    }

    Statistics(long l) {
        super(l);
    }

    private static byte[] toArrayValues(EnumSet<HistogramType> enumSet) {
        byte[] byArray = new byte[enumSet.size()];
        int n = 0;
        for (HistogramType histogramType : enumSet) {
            byArray[n++] = histogramType.getValue();
        }
        return byArray;
    }

    public StatsLevel statsLevel() {
        return StatsLevel.getStatsLevel(this.statsLevel(this.nativeHandle_));
    }

    public void setStatsLevel(StatsLevel statsLevel) {
        this.setStatsLevel(this.nativeHandle_, statsLevel.getValue());
    }

    public long getTickerCount(TickerType tickerType) {
        assert (this.isOwningHandle());
        return this.getTickerCount(this.nativeHandle_, tickerType.getValue());
    }

    public long getAndResetTickerCount(TickerType tickerType) {
        assert (this.isOwningHandle());
        return this.getAndResetTickerCount(this.nativeHandle_, tickerType.getValue());
    }

    public HistogramData getHistogramData(HistogramType histogramType) {
        assert (this.isOwningHandle());
        return this.getHistogramData(this.nativeHandle_, histogramType.getValue());
    }

    public String getHistogramString(HistogramType histogramType) {
        assert (this.isOwningHandle());
        return this.getHistogramString(this.nativeHandle_, histogramType.getValue());
    }

    public void reset() throws RocksDBException {
        assert (this.isOwningHandle());
        this.reset(this.nativeHandle_);
    }

    public String toString() {
        assert (this.isOwningHandle());
        return this.toString(this.nativeHandle_);
    }

    private static native long newStatistics();

    private static native long newStatistics(long var0);

    private static native long newStatistics(byte[] var0);

    private static native long newStatistics(byte[] var0, long var1);

    @Override
    protected final native void disposeInternal(long var1);

    private native byte statsLevel(long var1);

    private native void setStatsLevel(long var1, byte var3);

    private native long getTickerCount(long var1, byte var3);

    private native long getAndResetTickerCount(long var1, byte var3);

    private native HistogramData getHistogramData(long var1, byte var3);

    private native String getHistogramString(long var1, byte var3);

    private native void reset(long var1) throws RocksDBException;

    private native String toString(long var1);
}

