/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.rocksdb;

import dlshade.org.rocksdb.AbstractTransactionNotifier;
import dlshade.org.rocksdb.ColumnFamilyHandle;
import dlshade.org.rocksdb.ReadOptions;
import dlshade.org.rocksdb.RocksDB;
import dlshade.org.rocksdb.RocksDBException;
import dlshade.org.rocksdb.RocksIterator;
import dlshade.org.rocksdb.RocksObject;
import dlshade.org.rocksdb.Snapshot;
import dlshade.org.rocksdb.WriteBatch;
import dlshade.org.rocksdb.WriteBatchWithIndex;
import dlshade.org.rocksdb.WriteOptions;
import java.util.List;

public class Transaction
extends RocksObject {
    private final RocksDB parent;

    Transaction(RocksDB rocksDB, long l) {
        super(l);
        this.parent = rocksDB;
    }

    public void setSnapshot() {
        assert (this.isOwningHandle());
        this.setSnapshot(this.nativeHandle_);
    }

    public void setSnapshotOnNextOperation() {
        assert (this.isOwningHandle());
        this.setSnapshotOnNextOperation(this.nativeHandle_);
    }

    public void setSnapshotOnNextOperation(AbstractTransactionNotifier abstractTransactionNotifier) {
        assert (this.isOwningHandle());
        this.setSnapshotOnNextOperation(this.nativeHandle_, abstractTransactionNotifier.nativeHandle_);
    }

    public Snapshot getSnapshot() {
        assert (this.isOwningHandle());
        long l = this.getSnapshot(this.nativeHandle_);
        if (l == 0L) {
            return null;
        }
        Snapshot snapshot = new Snapshot(l);
        return snapshot;
    }

    public void clearSnapshot() {
        assert (this.isOwningHandle());
        this.clearSnapshot(this.nativeHandle_);
    }

    void prepare() throws RocksDBException {
        assert (this.isOwningHandle());
        this.prepare(this.nativeHandle_);
    }

    public void commit() throws RocksDBException {
        assert (this.isOwningHandle());
        this.commit(this.nativeHandle_);
    }

    public void rollback() throws RocksDBException {
        assert (this.isOwningHandle());
        this.rollback(this.nativeHandle_);
    }

    public void setSavePoint() throws RocksDBException {
        assert (this.isOwningHandle());
        this.setSavePoint(this.nativeHandle_);
    }

    public void rollbackToSavePoint() throws RocksDBException {
        assert (this.isOwningHandle());
        this.rollbackToSavePoint(this.nativeHandle_);
    }

    public byte[] get(ColumnFamilyHandle columnFamilyHandle, ReadOptions readOptions, byte[] byArray) throws RocksDBException {
        assert (this.isOwningHandle());
        return this.get(this.nativeHandle_, readOptions.nativeHandle_, byArray, byArray.length, columnFamilyHandle.nativeHandle_);
    }

    public byte[] get(ReadOptions readOptions, byte[] byArray) throws RocksDBException {
        assert (this.isOwningHandle());
        return this.get(this.nativeHandle_, readOptions.nativeHandle_, byArray, byArray.length);
    }

    public byte[][] multiGet(ReadOptions readOptions, List<ColumnFamilyHandle> list, byte[][] byArray) throws RocksDBException {
        assert (this.isOwningHandle());
        if (byArray.length != list.size()) {
            throw new IllegalArgumentException("For each key there must be a ColumnFamilyHandle.");
        }
        if (byArray.length == 0) {
            return new byte[0][0];
        }
        long[] lArray = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            lArray[i] = list.get((int)i).nativeHandle_;
        }
        return this.multiGet(this.nativeHandle_, readOptions.nativeHandle_, byArray, lArray);
    }

    public byte[][] multiGet(ReadOptions readOptions, byte[][] byArray) throws RocksDBException {
        assert (this.isOwningHandle());
        if (byArray.length == 0) {
            return new byte[0][0];
        }
        return this.multiGet(this.nativeHandle_, readOptions.nativeHandle_, byArray);
    }

    public byte[] getForUpdate(ReadOptions readOptions, ColumnFamilyHandle columnFamilyHandle, byte[] byArray, boolean bl, boolean bl2) throws RocksDBException {
        assert (this.isOwningHandle());
        return this.getForUpdate(this.nativeHandle_, readOptions.nativeHandle_, byArray, byArray.length, columnFamilyHandle.nativeHandle_, bl, bl2);
    }

    public byte[] getForUpdate(ReadOptions readOptions, ColumnFamilyHandle columnFamilyHandle, byte[] byArray, boolean bl) throws RocksDBException {
        assert (this.isOwningHandle());
        return this.getForUpdate(this.nativeHandle_, readOptions.nativeHandle_, byArray, byArray.length, columnFamilyHandle.nativeHandle_, bl, true);
    }

    public byte[] getForUpdate(ReadOptions readOptions, byte[] byArray, boolean bl) throws RocksDBException {
        assert (this.isOwningHandle());
        return this.getForUpdate(this.nativeHandle_, readOptions.nativeHandle_, byArray, byArray.length, bl, true);
    }

    public byte[][] multiGetForUpdate(ReadOptions readOptions, List<ColumnFamilyHandle> list, byte[][] byArray) throws RocksDBException {
        assert (this.isOwningHandle());
        if (byArray.length != list.size()) {
            throw new IllegalArgumentException("For each key there must be a ColumnFamilyHandle.");
        }
        if (byArray.length == 0) {
            return new byte[0][0];
        }
        long[] lArray = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            lArray[i] = list.get((int)i).nativeHandle_;
        }
        return this.multiGetForUpdate(this.nativeHandle_, readOptions.nativeHandle_, byArray, lArray);
    }

    public byte[][] multiGetForUpdate(ReadOptions readOptions, byte[][] byArray) throws RocksDBException {
        assert (this.isOwningHandle());
        if (byArray.length == 0) {
            return new byte[0][0];
        }
        return this.multiGetForUpdate(this.nativeHandle_, readOptions.nativeHandle_, byArray);
    }

    public RocksIterator getIterator(ReadOptions readOptions) {
        assert (this.isOwningHandle());
        return new RocksIterator(this.parent, this.getIterator(this.nativeHandle_, readOptions.nativeHandle_));
    }

    public RocksIterator getIterator(ReadOptions readOptions, ColumnFamilyHandle columnFamilyHandle) {
        assert (this.isOwningHandle());
        return new RocksIterator(this.parent, this.getIterator(this.nativeHandle_, readOptions.nativeHandle_, columnFamilyHandle.nativeHandle_));
    }

    public void put(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, byte[] byArray2, boolean bl) throws RocksDBException {
        assert (this.isOwningHandle());
        this.put(this.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length, columnFamilyHandle.nativeHandle_, bl);
    }

    public void put(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, byte[] byArray2) throws RocksDBException {
        assert (this.isOwningHandle());
        this.put(this.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length, columnFamilyHandle.nativeHandle_, false);
    }

    public void put(byte[] byArray, byte[] byArray2) throws RocksDBException {
        assert (this.isOwningHandle());
        this.put(this.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length);
    }

    public void put(ColumnFamilyHandle columnFamilyHandle, byte[][] byArray, byte[][] byArray2, boolean bl) throws RocksDBException {
        assert (this.isOwningHandle());
        this.put(this.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length, columnFamilyHandle.nativeHandle_, bl);
    }

    public void put(ColumnFamilyHandle columnFamilyHandle, byte[][] byArray, byte[][] byArray2) throws RocksDBException {
        assert (this.isOwningHandle());
        this.put(this.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length, columnFamilyHandle.nativeHandle_, false);
    }

    public void put(byte[][] byArray, byte[][] byArray2) throws RocksDBException {
        assert (this.isOwningHandle());
        this.put(this.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length);
    }

    public void merge(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, byte[] byArray2, boolean bl) throws RocksDBException {
        assert (this.isOwningHandle());
        this.merge(this.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length, columnFamilyHandle.nativeHandle_, bl);
    }

    public void merge(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, byte[] byArray2) throws RocksDBException {
        assert (this.isOwningHandle());
        this.merge(this.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length, columnFamilyHandle.nativeHandle_, false);
    }

    public void merge(byte[] byArray, byte[] byArray2) throws RocksDBException {
        assert (this.isOwningHandle());
        this.merge(this.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length);
    }

    public void delete(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, boolean bl) throws RocksDBException {
        assert (this.isOwningHandle());
        this.delete(this.nativeHandle_, byArray, byArray.length, columnFamilyHandle.nativeHandle_, bl);
    }

    public void delete(ColumnFamilyHandle columnFamilyHandle, byte[] byArray) throws RocksDBException {
        assert (this.isOwningHandle());
        this.delete(this.nativeHandle_, byArray, byArray.length, columnFamilyHandle.nativeHandle_, false);
    }

    public void delete(byte[] byArray) throws RocksDBException {
        assert (this.isOwningHandle());
        this.delete(this.nativeHandle_, byArray, byArray.length);
    }

    public void delete(ColumnFamilyHandle columnFamilyHandle, byte[][] byArray, boolean bl) throws RocksDBException {
        assert (this.isOwningHandle());
        this.delete(this.nativeHandle_, byArray, byArray.length, columnFamilyHandle.nativeHandle_, bl);
    }

    public void delete(ColumnFamilyHandle columnFamilyHandle, byte[][] byArray) throws RocksDBException {
        assert (this.isOwningHandle());
        this.delete(this.nativeHandle_, byArray, byArray.length, columnFamilyHandle.nativeHandle_, false);
    }

    public void delete(byte[][] byArray) throws RocksDBException {
        assert (this.isOwningHandle());
        this.delete(this.nativeHandle_, byArray, byArray.length);
    }

    public void singleDelete(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, boolean bl) throws RocksDBException {
        assert (this.isOwningHandle());
        this.singleDelete(this.nativeHandle_, byArray, byArray.length, columnFamilyHandle.nativeHandle_, bl);
    }

    public void singleDelete(ColumnFamilyHandle columnFamilyHandle, byte[] byArray) throws RocksDBException {
        assert (this.isOwningHandle());
        this.singleDelete(this.nativeHandle_, byArray, byArray.length, columnFamilyHandle.nativeHandle_, false);
    }

    public void singleDelete(byte[] byArray) throws RocksDBException {
        assert (this.isOwningHandle());
        this.singleDelete(this.nativeHandle_, byArray, byArray.length);
    }

    public void singleDelete(ColumnFamilyHandle columnFamilyHandle, byte[][] byArray, boolean bl) throws RocksDBException {
        assert (this.isOwningHandle());
        this.singleDelete(this.nativeHandle_, byArray, byArray.length, columnFamilyHandle.nativeHandle_, bl);
    }

    public void singleDelete(ColumnFamilyHandle columnFamilyHandle, byte[][] byArray) throws RocksDBException {
        assert (this.isOwningHandle());
        this.singleDelete(this.nativeHandle_, byArray, byArray.length, columnFamilyHandle.nativeHandle_, false);
    }

    public void singleDelete(byte[][] byArray) throws RocksDBException {
        assert (this.isOwningHandle());
        this.singleDelete(this.nativeHandle_, byArray, byArray.length);
    }

    public void putUntracked(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, byte[] byArray2) throws RocksDBException {
        assert (this.isOwningHandle());
        this.putUntracked(this.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length, columnFamilyHandle.nativeHandle_);
    }

    public void putUntracked(byte[] byArray, byte[] byArray2) throws RocksDBException {
        assert (this.isOwningHandle());
        this.putUntracked(this.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length);
    }

    public void putUntracked(ColumnFamilyHandle columnFamilyHandle, byte[][] byArray, byte[][] byArray2) throws RocksDBException {
        assert (this.isOwningHandle());
        this.putUntracked(this.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length, columnFamilyHandle.nativeHandle_);
    }

    public void putUntracked(byte[][] byArray, byte[][] byArray2) throws RocksDBException {
        assert (this.isOwningHandle());
        this.putUntracked(this.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length);
    }

    public void mergeUntracked(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.mergeUntracked(this.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length, columnFamilyHandle.nativeHandle_);
    }

    public void mergeUntracked(byte[] byArray, byte[] byArray2) throws RocksDBException {
        assert (this.isOwningHandle());
        this.mergeUntracked(this.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length);
    }

    public void deleteUntracked(ColumnFamilyHandle columnFamilyHandle, byte[] byArray) throws RocksDBException {
        assert (this.isOwningHandle());
        this.deleteUntracked(this.nativeHandle_, byArray, byArray.length, columnFamilyHandle.nativeHandle_);
    }

    public void deleteUntracked(byte[] byArray) throws RocksDBException {
        assert (this.isOwningHandle());
        this.deleteUntracked(this.nativeHandle_, byArray, byArray.length);
    }

    public void deleteUntracked(ColumnFamilyHandle columnFamilyHandle, byte[][] byArray) throws RocksDBException {
        assert (this.isOwningHandle());
        this.deleteUntracked(this.nativeHandle_, byArray, byArray.length, columnFamilyHandle.nativeHandle_);
    }

    public void deleteUntracked(byte[][] byArray) throws RocksDBException {
        assert (this.isOwningHandle());
        this.deleteUntracked(this.nativeHandle_, byArray, byArray.length);
    }

    public void putLogData(byte[] byArray) {
        assert (this.isOwningHandle());
        this.putLogData(this.nativeHandle_, byArray, byArray.length);
    }

    public void disableIndexing() {
        assert (this.isOwningHandle());
        this.disableIndexing(this.nativeHandle_);
    }

    public void enableIndexing() {
        assert (this.isOwningHandle());
        this.enableIndexing(this.nativeHandle_);
    }

    public long getNumKeys() {
        assert (this.isOwningHandle());
        return this.getNumKeys(this.nativeHandle_);
    }

    public long getNumPuts() {
        assert (this.isOwningHandle());
        return this.getNumPuts(this.nativeHandle_);
    }

    public long getNumDeletes() {
        assert (this.isOwningHandle());
        return this.getNumDeletes(this.nativeHandle_);
    }

    public long getNumMerges() {
        assert (this.isOwningHandle());
        return this.getNumMerges(this.nativeHandle_);
    }

    public long getElapsedTime() {
        assert (this.isOwningHandle());
        return this.getElapsedTime(this.nativeHandle_);
    }

    public WriteBatchWithIndex getWriteBatch() {
        assert (this.isOwningHandle());
        WriteBatchWithIndex writeBatchWithIndex = new WriteBatchWithIndex(this.getWriteBatch(this.nativeHandle_));
        return writeBatchWithIndex;
    }

    public void setLockTimeout(long l) {
        assert (this.isOwningHandle());
        this.setLockTimeout(this.nativeHandle_, l);
    }

    public WriteOptions getWriteOptions() {
        assert (this.isOwningHandle());
        WriteOptions writeOptions = new WriteOptions(this.getWriteOptions(this.nativeHandle_));
        return writeOptions;
    }

    public void setWriteOptions(WriteOptions writeOptions) {
        assert (this.isOwningHandle());
        this.setWriteOptions(this.nativeHandle_, writeOptions.nativeHandle_);
    }

    public void undoGetForUpdate(ColumnFamilyHandle columnFamilyHandle, byte[] byArray) {
        assert (this.isOwningHandle());
        this.undoGetForUpdate(this.nativeHandle_, byArray, byArray.length, columnFamilyHandle.nativeHandle_);
    }

    public void undoGetForUpdate(byte[] byArray) {
        assert (this.isOwningHandle());
        this.undoGetForUpdate(this.nativeHandle_, byArray, byArray.length);
    }

    public void rebuildFromWriteBatch(WriteBatch writeBatch) throws RocksDBException {
        assert (this.isOwningHandle());
        this.rebuildFromWriteBatch(this.nativeHandle_, writeBatch.nativeHandle_);
    }

    public WriteBatch getCommitTimeWriteBatch() {
        assert (this.isOwningHandle());
        WriteBatch writeBatch = new WriteBatch(this.getCommitTimeWriteBatch(this.nativeHandle_));
        return writeBatch;
    }

    public void setLogNumber(long l) {
        assert (this.isOwningHandle());
        this.setLogNumber(this.nativeHandle_, l);
    }

    public long getLogNumber() {
        assert (this.isOwningHandle());
        return this.getLogNumber(this.nativeHandle_);
    }

    public void setName(String string) throws RocksDBException {
        assert (this.isOwningHandle());
        this.setName(this.nativeHandle_, string);
    }

    public String getName() {
        assert (this.isOwningHandle());
        return this.getName(this.nativeHandle_);
    }

    public long getID() {
        assert (this.isOwningHandle());
        return this.getID(this.nativeHandle_);
    }

    public boolean isDeadlockDetect() {
        assert (this.isOwningHandle());
        return this.isDeadlockDetect(this.nativeHandle_);
    }

    public WaitingTransactions getWaitingTxns() {
        assert (this.isOwningHandle());
        return this.getWaitingTxns(this.nativeHandle_);
    }

    public TransactionState getState() {
        assert (this.isOwningHandle());
        return TransactionState.getTransactionState(this.getState(this.nativeHandle_));
    }

    public long getId() {
        assert (this.isOwningHandle());
        return this.getId(this.nativeHandle_);
    }

    private WaitingTransactions newWaitingTransactions(long l, String string, long[] lArray) {
        return new WaitingTransactions(l, string, lArray);
    }

    private native void setSnapshot(long var1);

    private native void setSnapshotOnNextOperation(long var1);

    private native void setSnapshotOnNextOperation(long var1, long var3);

    private native long getSnapshot(long var1);

    private native void clearSnapshot(long var1);

    private native void prepare(long var1) throws RocksDBException;

    private native void commit(long var1) throws RocksDBException;

    private native void rollback(long var1) throws RocksDBException;

    private native void setSavePoint(long var1) throws RocksDBException;

    private native void rollbackToSavePoint(long var1) throws RocksDBException;

    private native byte[] get(long var1, long var3, byte[] var5, int var6, long var7) throws RocksDBException;

    private native byte[] get(long var1, long var3, byte[] var5, int var6) throws RocksDBException;

    private native byte[][] multiGet(long var1, long var3, byte[][] var5, long[] var6) throws RocksDBException;

    private native byte[][] multiGet(long var1, long var3, byte[][] var5) throws RocksDBException;

    private native byte[] getForUpdate(long var1, long var3, byte[] var5, int var6, long var7, boolean var9, boolean var10) throws RocksDBException;

    private native byte[] getForUpdate(long var1, long var3, byte[] var5, int var6, boolean var7, boolean var8) throws RocksDBException;

    private native byte[][] multiGetForUpdate(long var1, long var3, byte[][] var5, long[] var6) throws RocksDBException;

    private native byte[][] multiGetForUpdate(long var1, long var3, byte[][] var5) throws RocksDBException;

    private native long getIterator(long var1, long var3);

    private native long getIterator(long var1, long var3, long var5);

    private native void put(long var1, byte[] var3, int var4, byte[] var5, int var6, long var7, boolean var9) throws RocksDBException;

    private native void put(long var1, byte[] var3, int var4, byte[] var5, int var6) throws RocksDBException;

    private native void put(long var1, byte[][] var3, int var4, byte[][] var5, int var6, long var7, boolean var9) throws RocksDBException;

    private native void put(long var1, byte[][] var3, int var4, byte[][] var5, int var6) throws RocksDBException;

    private native void merge(long var1, byte[] var3, int var4, byte[] var5, int var6, long var7, boolean var9) throws RocksDBException;

    private native void merge(long var1, byte[] var3, int var4, byte[] var5, int var6) throws RocksDBException;

    private native void delete(long var1, byte[] var3, int var4, long var5, boolean var7) throws RocksDBException;

    private native void delete(long var1, byte[] var3, int var4) throws RocksDBException;

    private native void delete(long var1, byte[][] var3, int var4, long var5, boolean var7) throws RocksDBException;

    private native void delete(long var1, byte[][] var3, int var4) throws RocksDBException;

    private native void singleDelete(long var1, byte[] var3, int var4, long var5, boolean var7) throws RocksDBException;

    private native void singleDelete(long var1, byte[] var3, int var4) throws RocksDBException;

    private native void singleDelete(long var1, byte[][] var3, int var4, long var5, boolean var7) throws RocksDBException;

    private native void singleDelete(long var1, byte[][] var3, int var4) throws RocksDBException;

    private native void putUntracked(long var1, byte[] var3, int var4, byte[] var5, int var6, long var7) throws RocksDBException;

    private native void putUntracked(long var1, byte[] var3, int var4, byte[] var5, int var6) throws RocksDBException;

    private native void putUntracked(long var1, byte[][] var3, int var4, byte[][] var5, int var6, long var7) throws RocksDBException;

    private native void putUntracked(long var1, byte[][] var3, int var4, byte[][] var5, int var6) throws RocksDBException;

    private native void mergeUntracked(long var1, byte[] var3, int var4, byte[] var5, int var6, long var7) throws RocksDBException;

    private native void mergeUntracked(long var1, byte[] var3, int var4, byte[] var5, int var6) throws RocksDBException;

    private native void deleteUntracked(long var1, byte[] var3, int var4, long var5) throws RocksDBException;

    private native void deleteUntracked(long var1, byte[] var3, int var4) throws RocksDBException;

    private native void deleteUntracked(long var1, byte[][] var3, int var4, long var5) throws RocksDBException;

    private native void deleteUntracked(long var1, byte[][] var3, int var4) throws RocksDBException;

    private native void putLogData(long var1, byte[] var3, int var4);

    private native void disableIndexing(long var1);

    private native void enableIndexing(long var1);

    private native long getNumKeys(long var1);

    private native long getNumPuts(long var1);

    private native long getNumDeletes(long var1);

    private native long getNumMerges(long var1);

    private native long getElapsedTime(long var1);

    private native long getWriteBatch(long var1);

    private native void setLockTimeout(long var1, long var3);

    private native long getWriteOptions(long var1);

    private native void setWriteOptions(long var1, long var3);

    private native void undoGetForUpdate(long var1, byte[] var3, int var4, long var5);

    private native void undoGetForUpdate(long var1, byte[] var3, int var4);

    private native void rebuildFromWriteBatch(long var1, long var3) throws RocksDBException;

    private native long getCommitTimeWriteBatch(long var1);

    private native void setLogNumber(long var1, long var3);

    private native long getLogNumber(long var1);

    private native void setName(long var1, String var3) throws RocksDBException;

    private native String getName(long var1);

    private native long getID(long var1);

    private native boolean isDeadlockDetect(long var1);

    private native WaitingTransactions getWaitingTxns(long var1);

    private native byte getState(long var1);

    private native long getId(long var1);

    @Override
    protected final native void disposeInternal(long var1);

    public static class WaitingTransactions {
        private final long columnFamilyId;
        private final String key;
        private final long[] transactionIds;

        private WaitingTransactions(long l, String string, long[] lArray) {
            this.columnFamilyId = l;
            this.key = string;
            this.transactionIds = lArray;
        }

        public long getColumnFamilyId() {
            return this.columnFamilyId;
        }

        public String getKey() {
            return this.key;
        }

        public long[] getTransactionIds() {
            return this.transactionIds;
        }
    }

    public static enum TransactionState {
        STARTED(0),
        AWAITING_PREPARE(1),
        PREPARED(2),
        AWAITING_COMMIT(3),
        COMMITTED(4),
        AWAITING_ROLLBACK(5),
        ROLLEDBACK(6),
        LOCKS_STOLEN(7);

        public static final TransactionState COMMITED;
        private final byte value;

        private TransactionState(byte by) {
            this.value = by;
        }

        public static TransactionState getTransactionState(byte by) {
            for (TransactionState transactionState : TransactionState.values()) {
                if (transactionState.value != by) continue;
                return transactionState;
            }
            throw new IllegalArgumentException("Illegal value provided for TransactionState.");
        }

        static {
            COMMITED = COMMITTED;
        }
    }
}

