/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.LogRecordSet;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.io.CompressionCodec;
import org.apache.distributedlog.io.CompressionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EnvelopedRecordSetReader
implements LogRecordSet.Reader {
    private static final Logger log = LoggerFactory.getLogger(EnvelopedRecordSetReader.class);
    private final long logSegmentSeqNo;
    private final long entryId;
    private final long transactionId;
    private final long startSequenceId;
    private int numRecords;
    private final ByteBuf reader;
    private long slotId;
    private int position;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EnvelopedRecordSetReader(long logSegmentSeqNo, long entryId, long transactionId, long startSlotId, int startPositionWithinLogSegment, long startSequenceId, ByteBuf src) throws IOException {
        this.logSegmentSeqNo = logSegmentSeqNo;
        this.entryId = entryId;
        this.transactionId = transactionId;
        this.slotId = startSlotId;
        this.position = startPositionWithinLogSegment;
        this.startSequenceId = startSequenceId;
        int metadata = src.readInt();
        int version = metadata & 0xF000;
        if (version != 4096) {
            throw new IOException(String.format("Version mismatch while reading. Received: %d, Required: %d", version, 4096));
        }
        int codecCode = metadata & 3;
        this.numRecords = src.readInt();
        int decompressedDataLen = src.readInt();
        int compressedDataLen = src.readInt();
        ByteBuf compressedBuf = src.slice(src.readerIndex(), compressedDataLen);
        try {
            if (CompressionCodec.Type.NONE.code() == codecCode && decompressedDataLen != compressedDataLen) {
                throw new IOException("Inconsistent data length found for a non-compressed record set : decompressed = " + decompressedDataLen + ", actual = " + compressedDataLen);
            }
            CompressionCodec codec = CompressionUtils.getCompressionCodec(CompressionCodec.Type.of(codecCode));
            this.reader = codec.decompress(compressedBuf, decompressedDataLen);
        }
        finally {
            ReferenceCountUtil.safeRelease((Object)compressedBuf);
        }
        if (this.numRecords == 0) {
            ReferenceCountUtil.safeRelease((Object)this.reader);
        }
    }

    @Override
    public LogRecordWithDLSN nextRecord() throws IOException {
        if (this.numRecords <= 0) {
            return null;
        }
        int recordLen = this.reader.readInt();
        ByteBuf recordBuf = this.reader.slice(this.reader.readerIndex(), recordLen);
        this.reader.readerIndex(this.reader.readerIndex() + recordLen);
        DLSN dlsn = new DLSN(this.logSegmentSeqNo, this.entryId, this.slotId);
        LogRecordWithDLSN record = new LogRecordWithDLSN(dlsn, this.startSequenceId);
        record.setPositionWithinLogSegment(this.position);
        record.setTransactionId(this.transactionId);
        record.setPayloadBuf(recordBuf, true);
        ++this.slotId;
        ++this.position;
        --this.numRecords;
        if (0 == this.numRecords) {
            ReferenceCountUtil.safeRelease((Object)this.reader);
        }
        return record;
    }

    @Override
    public void release() {
        if (0 != this.numRecords) {
            this.numRecords = 0;
            ReferenceCountUtil.safeRelease((Object)this.reader);
        }
    }
}

