/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.impl.acl;

import dlshade.com.google.common.annotations.VisibleForTesting;
import dlshade.com.google.common.base.Objects;
import dlshade.org.apache.thrift.TException;
import dlshade.org.apache.thrift.protocol.TJSONProtocol;
import dlshade.org.apache.thrift.transport.TMemoryBuffer;
import dlshade.org.apache.thrift.transport.TMemoryInputTransport;
import dlshade.org.apache.zookeeper.AsyncCallback;
import dlshade.org.apache.zookeeper.CreateMode;
import dlshade.org.apache.zookeeper.KeeperException;
import dlshade.org.apache.zookeeper.Watcher;
import dlshade.org.apache.zookeeper.data.Stat;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.thrift.AccessControlEntry;

public class ZKAccessControl {
    private static final int BUFFER_SIZE = 4096;
    public static final AccessControlEntry DEFAULT_ACCESS_CONTROL_ENTRY = new AccessControlEntry();
    protected final AccessControlEntry accessControlEntry;
    protected final String zkPath;
    private int zkVersion;

    public ZKAccessControl(AccessControlEntry ace, String zkPath) {
        this(ace, zkPath, -1);
    }

    private ZKAccessControl(AccessControlEntry ace, String zkPath, int zkVersion) {
        this.accessControlEntry = ace;
        this.zkPath = zkPath;
        this.zkVersion = zkVersion;
    }

    public int hashCode() {
        return Objects.hashCode(this.zkPath, this.accessControlEntry);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ZKAccessControl)) {
            return false;
        }
        ZKAccessControl other = (ZKAccessControl)obj;
        return Objects.equal(this.zkPath, other.zkPath) && Objects.equal(this.accessControlEntry, other.accessControlEntry);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("entry(path=").append(this.zkPath).append(", acl=").append(this.accessControlEntry).append(")");
        return sb.toString();
    }

    @VisibleForTesting
    public String getZKPath() {
        return this.zkPath;
    }

    @VisibleForTesting
    public AccessControlEntry getAccessControlEntry() {
        return this.accessControlEntry;
    }

    public CompletableFuture<ZKAccessControl> create(ZooKeeperClient zkc) {
        final CompletableFuture<ZKAccessControl> promise = new CompletableFuture<ZKAccessControl>();
        try {
            zkc.get().create(this.zkPath, ZKAccessControl.serialize(this.accessControlEntry), zkc.getDefaultACL(), CreateMode.PERSISTENT, new AsyncCallback.StringCallback(){

                @Override
                public void processResult(int rc, String path, Object ctx, String name) {
                    if (KeeperException.Code.OK.intValue() == rc) {
                        ZKAccessControl.this.zkVersion = 0;
                        promise.complete(ZKAccessControl.this);
                    } else {
                        promise.completeExceptionally(KeeperException.create(KeeperException.Code.get(rc)));
                    }
                }
            }, null);
        }
        catch (ZooKeeperClient.ZooKeeperConnectionException e) {
            promise.completeExceptionally(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            promise.completeExceptionally(e);
        }
        catch (IOException e) {
            promise.completeExceptionally(e);
        }
        return promise;
    }

    public CompletableFuture<ZKAccessControl> update(ZooKeeperClient zkc) {
        final CompletableFuture<ZKAccessControl> promise = new CompletableFuture<ZKAccessControl>();
        try {
            zkc.get().setData(this.zkPath, ZKAccessControl.serialize(this.accessControlEntry), this.zkVersion, new AsyncCallback.StatCallback(){

                @Override
                public void processResult(int rc, String path, Object ctx, Stat stat) {
                    if (KeeperException.Code.OK.intValue() == rc) {
                        ZKAccessControl.this.zkVersion = stat.getVersion();
                        promise.complete(ZKAccessControl.this);
                    } else {
                        promise.completeExceptionally(KeeperException.create(KeeperException.Code.get(rc)));
                    }
                }
            }, null);
        }
        catch (ZooKeeperClient.ZooKeeperConnectionException e) {
            promise.completeExceptionally(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            promise.completeExceptionally(e);
        }
        catch (IOException e) {
            promise.completeExceptionally(e);
        }
        return promise;
    }

    public static CompletableFuture<ZKAccessControl> read(ZooKeeperClient zkc, final String zkPath, Watcher watcher) {
        final CompletableFuture<ZKAccessControl> promise = new CompletableFuture<ZKAccessControl>();
        try {
            zkc.get().getData(zkPath, watcher, new AsyncCallback.DataCallback(){

                @Override
                public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                    if (KeeperException.Code.OK.intValue() == rc) {
                        try {
                            AccessControlEntry ace = ZKAccessControl.deserialize(zkPath, data);
                            promise.complete(new ZKAccessControl(ace, zkPath, stat.getVersion()));
                        }
                        catch (IOException ioe) {
                            promise.completeExceptionally(ioe);
                        }
                    } else {
                        promise.completeExceptionally(KeeperException.create(KeeperException.Code.get(rc)));
                    }
                }
            }, null);
        }
        catch (ZooKeeperClient.ZooKeeperConnectionException e) {
            promise.completeExceptionally(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            promise.completeExceptionally(e);
        }
        return promise;
    }

    public static CompletableFuture<Void> delete(ZooKeeperClient zkc, String zkPath) {
        final CompletableFuture<Void> promise = new CompletableFuture<Void>();
        try {
            zkc.get().delete(zkPath, -1, new AsyncCallback.VoidCallback(){

                @Override
                public void processResult(int rc, String path, Object ctx) {
                    if (KeeperException.Code.OK.intValue() == rc || KeeperException.Code.NONODE.intValue() == rc) {
                        promise.complete(null);
                    } else {
                        promise.completeExceptionally(KeeperException.create(KeeperException.Code.get(rc)));
                    }
                }
            }, null);
        }
        catch (ZooKeeperClient.ZooKeeperConnectionException e) {
            promise.completeExceptionally(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            promise.completeExceptionally(e);
        }
        return promise;
    }

    static byte[] serialize(AccessControlEntry ace) throws IOException {
        try {
            TMemoryBuffer transport = new TMemoryBuffer(4096);
            TJSONProtocol protocol = new TJSONProtocol(transport);
            ace.write(protocol);
            transport.flush();
            return transport.toString(StandardCharsets.UTF_8).getBytes(StandardCharsets.UTF_8);
        }
        catch (TException e) {
            throw new IOException("Failed to serialize access control entry : ", e);
        }
    }

    static AccessControlEntry deserialize(String zkPath, byte[] data) throws IOException {
        if (data.length == 0) {
            return DEFAULT_ACCESS_CONTROL_ENTRY;
        }
        AccessControlEntry ace = new AccessControlEntry();
        try {
            TMemoryInputTransport transport = new TMemoryInputTransport(data);
            TJSONProtocol protocol = new TJSONProtocol(transport);
            ace.read(protocol);
        }
        catch (TException e) {
            throw new CorruptedAccessControlException(zkPath, e);
        }
        return ace;
    }

    public static class CorruptedAccessControlException
    extends IOException {
        private static final long serialVersionUID = 5391285182476211603L;

        public CorruptedAccessControlException(String zkPath, Throwable t) {
            super("Access Control @ " + zkPath + " is corrupted.", t);
        }
    }
}

