/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.impl.subscription;

import dlshade.org.apache.bookkeeper.common.concurrent.FutureUtils;
import dlshade.org.apache.bookkeeper.versioning.LongVersion;
import dlshade.org.apache.commons.lang3.tuple.Pair;
import dlshade.org.apache.zookeeper.AsyncCallback;
import dlshade.org.apache.zookeeper.KeeperException;
import dlshade.org.apache.zookeeper.data.Stat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.api.subscription.SubscriptionStateStore;
import org.apache.distributedlog.api.subscription.SubscriptionsStore;
import org.apache.distributedlog.exceptions.DLInterruptedException;
import org.apache.distributedlog.impl.subscription.ZKSubscriptionStateStore;
import org.apache.distributedlog.util.Utils;

public class ZKSubscriptionsStore
implements SubscriptionsStore {
    private final ZooKeeperClient zkc;
    private final String zkPath;
    private final ConcurrentMap<String, ZKSubscriptionStateStore> subscribers = new ConcurrentHashMap<String, ZKSubscriptionStateStore>();

    public ZKSubscriptionsStore(ZooKeeperClient zkc, String zkPath) {
        this.zkc = zkc;
        this.zkPath = zkPath;
    }

    private ZKSubscriptionStateStore getSubscriber(String subscriberId) {
        ZKSubscriptionStateStore ss = (ZKSubscriptionStateStore)this.subscribers.get(subscriberId);
        if (ss == null) {
            ZKSubscriptionStateStore newSS = new ZKSubscriptionStateStore(this.zkc, this.getSubscriberZKPath(subscriberId));
            ZKSubscriptionStateStore oldSS = this.subscribers.putIfAbsent(subscriberId, newSS);
            if (oldSS == null) {
                ss = newSS;
            } else {
                try {
                    newSS.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ss = oldSS;
            }
        }
        return ss;
    }

    private String getSubscriberZKPath(String subscriberId) {
        return String.format("%s/%s", this.zkPath, subscriberId);
    }

    @Override
    public CompletableFuture<DLSN> getLastCommitPosition(String subscriberId) {
        return this.getSubscriber(subscriberId).getLastCommitPosition();
    }

    @Override
    public CompletableFuture<Map<String, DLSN>> getLastCommitPositions() {
        final CompletableFuture<Map<String, DLSN>> result = new CompletableFuture<Map<String, DLSN>>();
        try {
            this.zkc.get().getChildren(this.zkPath, false, new AsyncCallback.Children2Callback(){

                @Override
                public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
                    if (KeeperException.Code.NONODE.intValue() == rc) {
                        result.complete(new HashMap());
                    } else if (KeeperException.Code.OK.intValue() != rc) {
                        result.completeExceptionally(KeeperException.create(KeeperException.Code.get(rc), path));
                    } else {
                        ZKSubscriptionsStore.this.getLastCommitPositions(result, children);
                    }
                }
            }, null);
        }
        catch (ZooKeeperClient.ZooKeeperConnectionException zkce) {
            result.completeExceptionally(zkce);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            result.completeExceptionally(new DLInterruptedException("getLastCommitPositions was interrupted", (Throwable)ie));
        }
        return result;
    }

    private void getLastCommitPositions(CompletableFuture<Map<String, DLSN>> result, List<String> subscribers) {
        ArrayList futures = new ArrayList(subscribers.size());
        Iterator<String> iterator = subscribers.iterator();
        while (iterator.hasNext()) {
            String s;
            String subscriber = s = iterator.next();
            CompletionStage future = this.getSubscriber(subscriber).getLastCommitPositionFromZK().thenApply(dlsn -> Pair.of(subscriber, dlsn));
            futures.add(future);
        }
        FutureUtils.collect(futures).thenAccept(subscriptions -> {
            HashMap subscriptionMap = new HashMap();
            for (Pair pair : subscriptions) {
                subscriptionMap.put(pair.getLeft(), pair.getRight());
            }
            result.complete(subscriptionMap);
        });
    }

    @Override
    public CompletableFuture<Void> advanceCommitPosition(String subscriberId, DLSN newPosition) {
        return this.getSubscriber(subscriberId).advanceCommitPosition(newPosition);
    }

    @Override
    public CompletableFuture<Boolean> deleteSubscriber(String subscriberId) {
        this.subscribers.remove(subscriberId);
        String path = this.getSubscriberZKPath(subscriberId);
        return Utils.zkDeleteIfNotExist(this.zkc, path, new LongVersion(-1L));
    }

    @Override
    public void close() throws IOException {
        for (SubscriptionStateStore store : this.subscribers.values()) {
            store.close();
        }
    }
}

