/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.io;

import dlshade.com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import org.apache.distributedlog.io.CompressionCodec;

public class IdentityCompressionCodec
implements CompressionCodec {
    private static final IdentityCompressionCodec INSTANCE = new IdentityCompressionCodec();

    public static IdentityCompressionCodec of() {
        return INSTANCE;
    }

    @Override
    public ByteBuf compress(ByteBuf uncompressed, int headerLen) {
        Preconditions.checkNotNull(uncompressed);
        Preconditions.checkArgument(uncompressed.readableBytes() >= 0);
        if (headerLen == 0) {
            return uncompressed.retain();
        }
        CompositeByteBuf composited = PooledByteBufAllocator.DEFAULT.compositeBuffer(2);
        composited.addComponent(PooledByteBufAllocator.DEFAULT.buffer(headerLen, headerLen));
        composited.addComponent(uncompressed.retain());
        return composited;
    }

    @Override
    public ByteBuf decompress(ByteBuf compressed, int decompressedSize) {
        Preconditions.checkNotNull(compressed);
        Preconditions.checkArgument(compressed.readableBytes() >= 0);
        Preconditions.checkArgument(decompressedSize >= 0);
        return compressed.retain();
    }
}

