/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.util;

import dlshade.com.google.common.base.Objects;
import dlshade.com.google.common.base.Preconditions;
import dlshade.org.apache.bookkeeper.common.net.ServiceURI;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.exceptions.InvalidStreamNameException;
import org.apache.distributedlog.exceptions.UnexpectedException;

public class DLUtils {
    public static int findLogSegmentNotLessThanTxnId(List<LogSegmentMetadata> segments, long transactionId) {
        int found = -1;
        for (int i = segments.size() - 1; i >= 0; --i) {
            LogSegmentMetadata segment = segments.get(i);
            if (segment.getFirstTxId() > transactionId) continue;
            found = i;
            break;
        }
        if (found <= -1) {
            return -1;
        }
        if (found == 0 && segments.get(0).getFirstTxId() == transactionId) {
            return 0;
        }
        LogSegmentMetadata foundSegment = segments.get(found);
        if (foundSegment.getFirstTxId() == transactionId) {
            LogSegmentMetadata segment;
            int i = found - 1;
            while (i >= 0 && !(segment = segments.get(i)).isInProgress() && segment.getLastTxId() >= transactionId) {
                found = i--;
            }
            return found;
        }
        if (foundSegment.isInProgress() || found == segments.size() - 1) {
            return found;
        }
        if (foundSegment.getLastTxId() >= transactionId) {
            return found;
        }
        return found + 1;
    }

    public static Long nextLogSegmentSequenceNumber(List<LogSegmentMetadata> segmentListDesc) {
        int lastAssignedLogSegmentIdx = -1;
        Long lastAssignedLogSegmentSeqNo = null;
        Long nextLogSegmentSeqNo = null;
        for (int i = 0; i < segmentListDesc.size(); ++i) {
            LogSegmentMetadata metadata = segmentListDesc.get(i);
            if (!LogSegmentMetadata.supportsLogSegmentSequenceNo(metadata.getVersion())) continue;
            lastAssignedLogSegmentSeqNo = metadata.getLogSegmentSequenceNumber();
            lastAssignedLogSegmentIdx = i;
            break;
        }
        if (null != lastAssignedLogSegmentSeqNo) {
            nextLogSegmentSeqNo = lastAssignedLogSegmentSeqNo + (long)lastAssignedLogSegmentIdx + 1L;
        }
        return nextLogSegmentSeqNo;
    }

    public static long computeStartSequenceId(List<LogSegmentMetadata> logSegmentDescList, LogSegmentMetadata segment) throws UnexpectedException {
        long startSequenceId = 0L;
        for (LogSegmentMetadata metadata : logSegmentDescList) {
            if (metadata.getLogSegmentSequenceNumber() >= segment.getLogSegmentSequenceNumber()) continue;
            if (metadata.getLogSegmentSequenceNumber() < segment.getLogSegmentSequenceNumber() - 1L) break;
            if (metadata.isInProgress()) {
                throw new UnexpectedException("Should not complete log segment " + segment.getLogSegmentSequenceNumber() + " since it's previous log segment is still inprogress : " + logSegmentDescList);
            }
            if (!metadata.supportsSequenceId()) continue;
            startSequenceId = metadata.getStartSequenceId() + (long)metadata.getRecordCount();
        }
        return startSequenceId;
    }

    public static long deserializeLogSegmentSequenceNumber(byte[] data) {
        String seqNoStr = new String(data, StandardCharsets.UTF_8);
        return Long.parseLong(seqNoStr);
    }

    public static byte[] serializeLogSegmentSequenceNumber(long logSegmentSeqNo) {
        return Long.toString(logSegmentSeqNo).getBytes(StandardCharsets.UTF_8);
    }

    public static long deserializeTransactionId(byte[] data) {
        String seqNoStr = new String(data, StandardCharsets.UTF_8);
        return Long.parseLong(seqNoStr);
    }

    public static byte[] serializeTransactionId(long transactionId) {
        return Long.toString(transactionId).getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] logSegmentId2Bytes(long logSegmentId) {
        return Long.toString(logSegmentId).getBytes(StandardCharsets.UTF_8);
    }

    public static long bytes2LogSegmentId(byte[] data) {
        return Long.parseLong(new String(data, StandardCharsets.UTF_8));
    }

    public static URI normalizeURI(URI uri) {
        URI normalizedUri;
        ServiceURI serviceURI = ServiceURI.create(uri);
        Preconditions.checkNotNull(serviceURI.getServiceName(), "Invalid distributedlog uri : " + uri);
        Preconditions.checkArgument(Objects.equal("distributedlog", serviceURI.getServiceName()), "Unknown distributedlog scheme found : " + uri);
        try {
            normalizedUri = new URI(serviceURI.getServiceName(), uri.getAuthority(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid distributedlog uri found : " + uri, e);
        }
        return normalizedUri;
    }

    private static String getHostIpLockClientId() {
        try {
            return InetAddress.getLocalHost().toString();
        }
        catch (Exception ex) {
            return "Unknown-ClientId";
        }
    }

    public static String normalizeClientId(String clientId) {
        String normalizedClientId = clientId.equals("Unknown-ClientId") ? DLUtils.getHostIpLockClientId() : clientId;
        return normalizedClientId;
    }

    public static boolean isReservedStreamName(String name) {
        return name.startsWith(".") || name.startsWith("<");
    }

    public static String validateAndNormalizeName(String logName) throws InvalidStreamNameException {
        if (DLUtils.isReservedStreamName(logName)) {
            throw new InvalidStreamNameException(logName, "Log Name is reserved");
        }
        if (logName.charAt(0) == '/') {
            DLUtils.validatePathName(logName);
            return logName.substring(1);
        }
        DLUtils.validatePathName("/" + logName);
        return logName;
    }

    private static void validatePathName(String logName) throws InvalidStreamNameException {
        if (logName == null) {
            throw new InvalidStreamNameException("Log name cannot be null");
        }
        if (logName.length() == 0) {
            throw new InvalidStreamNameException("Log name length must be > 0");
        }
        if (logName.charAt(0) != '/') {
            throw new InvalidStreamNameException("Log name must start with / character");
        }
        if (logName.length() != 1) {
            if (logName.charAt(logName.length() - 1) == '/') {
                throw new InvalidStreamNameException("Log name must not end with / character");
            }
            String reason = null;
            int lastc = 47;
            char[] chars = logName.toCharArray();
            for (int i = 1; i < chars.length; ++i) {
                char c = chars[i];
                if (c == '\u0000') {
                    reason = "null character not allowed @" + i;
                    break;
                }
                if (c == '<' || c == '>') {
                    reason = "< or > specified @" + i;
                    break;
                }
                if (c == ' ') {
                    reason = "empty space specified @" + i;
                    break;
                }
                if (c == '/' && lastc == 47) {
                    reason = "empty node name specified @" + i;
                    break;
                }
                if (c == '.' && lastc == 46) {
                    if (chars[i - 2] == '/' && (i + 1 == chars.length || chars[i + 1] == '/')) {
                        reason = "relative paths not allowed @" + i;
                        break;
                    }
                } else if (c == '.') {
                    if (chars[i - 1] == '/' && (i + 1 == chars.length || chars[i + 1] == '/')) {
                        reason = "relative paths not allowed @" + i;
                        break;
                    }
                } else if (c > '\u0000' && c < '\u001f' || c > '\u007f' && c < '\u009f' || c > '\ud800' && c < '\uf8ff' || c > '\ufff0' && c < '\uffff') {
                    reason = "invalid character @" + i;
                    break;
                }
                lastc = chars[i];
            }
            if (reason != null) {
                throw new InvalidStreamNameException("Invalid log name \"" + logName + "\" caused by " + reason);
            }
        }
    }
}

