/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.zk;

import dlshade.org.apache.bookkeeper.stats.Gauge;
import dlshade.org.apache.bookkeeper.stats.NullStatsLogger;
import dlshade.org.apache.bookkeeper.stats.StatsLogger;
import dlshade.org.apache.zookeeper.WatchedEvent;
import dlshade.org.apache.zookeeper.Watcher;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.distributedlog.common.util.PermitManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LimitedPermitManager
implements PermitManager,
Runnable,
Watcher {
    static final Logger LOG = LoggerFactory.getLogger(LimitedPermitManager.class);
    boolean enablePermits = true;
    final Semaphore semaphore;
    final int period;
    final TimeUnit timeUnit;
    final ScheduledExecutorService executorService;
    private static final AtomicIntegerFieldUpdater<LimitedPermitManager> epochUpdater = AtomicIntegerFieldUpdater.newUpdater(LimitedPermitManager.class, "epoch");
    volatile int epoch = 0;
    private StatsLogger statsLogger = null;
    private Gauge<Number> outstandingGauge = null;

    public LimitedPermitManager(int concurrency, int period, TimeUnit timeUnit, ScheduledExecutorService executorService) {
        this(concurrency, period, timeUnit, executorService, NullStatsLogger.INSTANCE);
    }

    public LimitedPermitManager(final int concurrency, int period, TimeUnit timeUnit, ScheduledExecutorService executorService, StatsLogger statsLogger) {
        this.semaphore = concurrency > 0 ? new Semaphore(concurrency) : null;
        this.period = period;
        this.timeUnit = timeUnit;
        this.executorService = executorService;
        this.statsLogger = statsLogger;
        this.outstandingGauge = new Gauge<Number>(){

            @Override
            public Number getDefaultValue() {
                return 0;
            }

            @Override
            public Number getSample() {
                return null == LimitedPermitManager.this.semaphore ? 0 : concurrency - LimitedPermitManager.this.semaphore.availablePermits();
            }
        };
        this.statsLogger.scope("permits").registerGauge("outstanding", this.outstandingGauge);
    }

    @Override
    public synchronized PermitManager.Permit acquirePermit() {
        if (!this.enablePermits) {
            return new EpochPermit(PermitState.DISABLED, epochUpdater.get(this));
        }
        if (null != this.semaphore) {
            return this.semaphore.tryAcquire() ? new EpochPermit(PermitState.ALLOWED, epochUpdater.get(this)) : new EpochPermit(PermitState.DISALLOWED, epochUpdater.get(this));
        }
        return new EpochPermit(PermitState.ALLOWED, epochUpdater.get(this));
    }

    @Override
    public synchronized void releasePermit(PermitManager.Permit permit) {
        if (null != this.semaphore && permit.isAllowed()) {
            if (this.period <= 0) {
                this.semaphore.release();
            } else {
                try {
                    this.executorService.schedule(this, (long)this.period, this.timeUnit);
                }
                catch (RejectedExecutionException ree) {
                    LOG.warn("Failed on scheduling releasing permit in given period ({}ms). Release it immediately : ", (Object)this.timeUnit.toMillis(this.period), (Object)ree);
                    this.semaphore.release();
                }
            }
        }
    }

    @Override
    public synchronized boolean disallowObtainPermits(PermitManager.Permit permit) {
        if (!(permit instanceof EpochPermit)) {
            return false;
        }
        int epoch = epochUpdater.getAndIncrement(this);
        if (epoch == ((EpochPermit)permit).getEpoch()) {
            this.enablePermits = false;
            LOG.info("EnablePermits = {}, Epoch = {}.", (Object)this.enablePermits, (Object)epoch);
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.unregisterGauge();
    }

    @Override
    public synchronized boolean allowObtainPermits() {
        this.forceSetAllowPermits(true);
        return true;
    }

    synchronized void forceSetAllowPermits(boolean allowPermits) {
        int epoch = epochUpdater.getAndIncrement(this);
        this.enablePermits = allowPermits;
        LOG.info("EnablePermits = {}, Epoch = {}.", (Object)this.enablePermits, (Object)epoch);
    }

    @Override
    public void run() {
        this.semaphore.release();
    }

    @Override
    public void process(WatchedEvent event) {
        if (event.getType().equals((Object)Watcher.Event.EventType.None)) {
            switch (event.getState()) {
                case SyncConnected: {
                    this.forceSetAllowPermits(true);
                    break;
                }
                case Disconnected: {
                    this.forceSetAllowPermits(false);
                    break;
                }
                case Expired: {
                    this.forceSetAllowPermits(false);
                    break;
                }
            }
        }
    }

    public void unregisterGauge() {
        if (this.statsLogger != null && this.outstandingGauge != null) {
            this.statsLogger.scope("permits").unregisterGauge("outstanding", this.outstandingGauge);
        }
    }

    static class EpochPermit
    implements PermitManager.Permit {
        final PermitState state;
        final int epoch;

        EpochPermit(PermitState state, int epoch) {
            this.state = state;
            this.epoch = epoch;
        }

        int getEpoch() {
            return this.epoch;
        }

        @Override
        public boolean isAllowed() {
            return PermitState.ALLOWED == this.state;
        }
    }

    static enum PermitState {
        ALLOWED,
        DISALLOWED,
        DISABLED;

    }
}

