/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert.api;

import java.util.Objects;

public class AlertData {
    private int id;
    private String title;
    private String content;
    private String log;
    private int warnType;

    public AlertData(int id, String title, String content, String log, int warnType) {
        this.id = id;
        this.title = title;
        this.content = content;
        this.log = log;
        this.warnType = warnType;
    }

    public AlertData() {
    }

    public static AlertDataBuilder builder() {
        return new AlertDataBuilder();
    }

    public int getId() {
        return this.id;
    }

    public AlertData setId(int id) {
        this.id = id;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public AlertData setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getContent() {
        return this.content;
    }

    public AlertData setContent(String content) {
        this.content = content;
        return this;
    }

    public String getLog() {
        return this.log;
    }

    public AlertData setLog(String log) {
        this.log = log;
        return this;
    }

    public int getWarnType() {
        return this.warnType;
    }

    public void setWarnType(int warnType) {
        this.warnType = warnType;
    }

    public boolean equals(Object o) {
        String otherContent;
        String otherTitle;
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlertData)) {
            return false;
        }
        AlertData other = (AlertData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getWarnType() != other.getWarnType()) {
            return false;
        }
        String thisTitle = this.getTitle();
        if (!Objects.equals(thisTitle, otherTitle = other.getTitle())) {
            return false;
        }
        String thisContent = this.getContent();
        if (!Objects.equals(thisContent, otherContent = other.getContent())) {
            return false;
        }
        String thisLog = this.getLog();
        String otherLog = other.getLog();
        return Objects.equals(thisLog, otherLog);
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlertData;
    }

    public int hashCode() {
        int prime = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + this.getWarnType();
        String title = this.getTitle();
        result = result * 59 + (title == null ? 43 : title.hashCode());
        String content = this.getContent();
        result = result * 59 + (content == null ? 43 : content.hashCode());
        String log = this.getLog();
        result = result * 59 + (log == null ? 43 : log.hashCode());
        return result;
    }

    public String toString() {
        return "AlertData(id=" + this.getId() + ", title=" + this.getTitle() + ", content=" + this.getContent() + ", log=" + this.getLog() + ", warnType=" + this.getWarnType() + ")";
    }

    public static class AlertDataBuilder {
        private int id;
        private String title;
        private String content;
        private String log;
        private int warnType;

        AlertDataBuilder() {
        }

        public AlertDataBuilder id(int id) {
            this.id = id;
            return this;
        }

        public AlertDataBuilder title(String title) {
            this.title = title;
            return this;
        }

        public AlertDataBuilder content(String content) {
            this.content = content;
            return this;
        }

        public AlertDataBuilder log(String log) {
            this.log = log;
            return this;
        }

        public AlertDataBuilder warnType(int warnType) {
            this.warnType = warnType;
            return this;
        }

        public AlertData build() {
            return new AlertData(this.id, this.title, this.content, this.log, this.warnType);
        }

        public String toString() {
            return "AlertData.AlertDataBuilder(id=" + this.id + ", title=" + this.title + ", content=" + this.content + ", log=" + this.log + ", warnType=" + this.warnType + ")";
        }
    }
}

